@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" setlocal
set PERL5LIB=
set PERLLIB=
set PERL5OPT=
set PERLIO=
set PERL_UNICODE=
if "%OS%" == "Windows_NT" goto WinNT
Perl\bin\perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
Perl\bin\perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!Perl/bin/perl -w
#line 20
#
# ActivePerl ZIP installer
#
# Copyright (c) 2000-2009 ActiveState Software Inc.  All rights reserved.
#
# This program completes a simple installation of ActivePerl
#
# The intent of this program is to provide a "fail-safe" way of installing
# a fully-functional version of ActivePerl.  If there is a failure, this
# script should explain exactly what went wrong, and how to fix it.
# If not, submit that as a bug.
#
# What is does:
#     o Relocates Perl
#     o Creates MSWin32 Shortcuts to the HTML documentation
#     o Configures PPM
#     o Configures lib/Config.pm for use with a development system
#     o Creates ActivePerl registry entries
#     o Updates the PATH environment variable
#     o Create PerlEx script mapping and virtual directory
#
# Todo:
#     o uninstall (pretty simple)
#

use strict;

use ActiveState::Prompt qw(prompt yes);
use ActiveState::Run qw(run);
use Config;
use Cwd;
use File::Basename qw(dirname);

use Win32;
use Win32API::Registry (':ALL');
use Win32::Shortcut;

$| = 1;

my $product = "ActivePerl";
die "Template not expanded yet" if $product =~ /TMPL_VAR/;

my $license_accepted;

# The path we will be replacing
#my \$replace = q[$path];

# The ActivePerl version we are installing
my $APVersion = defined &ActivePerl::BUILD ? ActivePerl::BUILD() : Win32::BuildNumber();
my $is_enterprise = $product =~ /enterprise/i;

(-d 'Perl/bin' && -d 'Perl/lib' && -d 'Perl/site')
    || die "Error: you must run this script from the directory in which you unzipped $product into.\n";

my $temp = $ENV{'TEMP'}
    || die "You must set the 'TEMP' environment variable.\n";

my $cwd = cwd;
$cwd =~ s#/#\\#g;

if (@ARGV && $ARGV[0] eq '--remove') {
    remove_html_shortcuts();
    print <<EOT;

$product uninstalled...you may now delete this directory and
its subdirectories.

EOT
    exit;
}

print <<EOT;
    Welcome to $product.

EOT

if (open(my $f, "LICENSE.txt")) {
    my $title = <$f>;
    chomp($title);
    close($f);

    if ($ActiveState::Prompt::USE_DEFAULT) {
	if (!$license_accepted) {
	    die <<EOT;
    In order to install $product you need to agree to the
    $title.  Please read the included
    LICENSE.txt file and confirm agreement by passing the
    --license-accepted option to this installer.

EOT
	}
    }
    local $ActiveState::Prompt::USE_DEFAULT = 1 if $license_accepted;

    print <<"EOT";
    ActivePerl is ActiveState's quality-assured binary build of
    Perl.  In order to install $product you need to agree to the
    $title.

EOT
    if (!yes("Did you read the LICENSE.txt file?", $license_accepted)) {
	if (yes("Do you want to read it now?", 1)) {
	    my $pager = $ENV{PAGER} || "more";
	    print "\n";
	    run("\@$pager", "LICENSE.txt");
	    print "\n";
	}
	else {
	    print "Ok. Aborting installer.\n\n";
	    exit;
	}
    }

    if (!yes("Do you agree to the $title?", $license_accepted)) {
	print "Ok. Aborting installer.\n\n";
	exit;
    }
}

print <<"EOT";

    This installer can install $product in any location of your choice.
    You do not need Administrator privileges.  However, please make sure
    that you have write access to this location.

EOT

my $prefix;
do {
    $prefix = "$ENV{SYSTEMDRIVE}\\Perl";
    $prefix .= "64" if $Config{ptrsize} == 8;
    $prefix = prompt("Enter top level directory for install?", $prefix);
    unless ($prefix) {
	print "No directory given, aborting!\n";
	exit 1;
    }

    unless ($prefix =~/(^.:\\)|(\\\\)/) {
	print "Error: You must include the drive letter or the full UNC PATH\n\n";
	undef $prefix;
    }

    if (-d $prefix) {
	for (qw(bin\\PerlCore.dll bin\\perl56.dll bin\\ppm3.bat
		site\\lib\\ActivePerl\\DocTools.pm))
	{
	    next unless -f "$prefix/$_";
	    print <<EOT;

    The directory contains an older version of ActivePerl (817 or earlier).
    The order of the lib and site\\lib directories in \@INC has changed in
    ActivePerl 818.  Therefore older modules in the site\\lib tree from the
    previous installation might hide the newer versions included in the lib
    directory in this release.

    Please choose an installation directory that does not already contain
    a conflicting version of ActivePerl!

EOT

	    undef $prefix;
	    last;
	}
    }
} until defined $prefix;

if (-d $prefix) {
    print <<EOT;

$prefix appears to already exist.

    WARNING: Install may fail if any existing files cannot be
    overwritten.
EOT
}

if ($prefix =~ /[\s;,!|<>~\@\%\&\$\*\?\+]/) {
    print <<EOT;

    Looks like you are trying to install Perl into a path that contains
    spaces or other special characters.  Though the latest Windows
    operating systems claim to support filenames with such special
    characters, many existing utilities will have trouble with such
    path names.  Chances are that you will find this is simply too
    much of a bad idea to be worth it.

EOT
    }

print <<EOT;

    The typical $product software installation requires 80 megabytes.
    Please make sure enough free space is available before continuing.

    $product $APVersion will be installed into '$prefix'
EOT

# Hint to MSWin32 users that devsys environment should be set before installing
#
if ((!defined($ENV{'INCLUDE'}) || !defined($ENV{'LIB'})) && $^O eq 'MSWin32') {
    print <<EOT;

    If you have a development environment (e.g. Visual Studio) that you
    wish to use with Perl, you should ensure that your environment (e.g.
    %LIB% and %INCLUDE%) is set before installing, for example, by running
    vcvars32.bat first.
EOT

    exit unless yes('Proceed?', 1);
}

print "\n";
my $create_html_shortcuts = yes("Create shortcuts to the HTML documentation?", 1);

print "\n";
my $perlbin = "Perl\\bin directory";
$perlbin = "Perl\\site\\bin and Perl\\bin directories" if $APVersion >= 819;
my $add_path = yes("Add the $perlbin to the PATH?", 1);

my $IISScriptMap  = "$prefix\\bin\\IISScriptMap.pl";
my $ap_iis_config = "$prefix\\bin\\ap-iis-config.bat";

my($create_file_association,$create_perl_mapping,$create_isapi_mapping);
if (Win32::IsWinNT() && Win32::IsAdminUser()) {
    # XXX This could be done on Win9X by direct registry hacking
    print "\n";
    $create_file_association = yes("Create Perl file extension association?", 1);

    if (-f $ap_iis_config || -f $IISScriptMap) {
	print "\n";
	$create_perl_mapping = yes("Create IIS script mapping for Perl?", 1);

	print "\n";
	$create_isapi_mapping = yes("Create IIS script mapping for Perl ISAPI?", 1);
    }
}

print "\n";
if (yes("Proceed?", 1)) {
    print "Ok.\n\nInstalling $product...\n";
}
else {
    print "Ok. Installation aborted!\n\n";
    exit 1;
}

#alright, copy the files
print <<EOT;

    Copying files...
EOT

# disables prompting in newer versions of cmd.exe if there are
# older files of the same name
$ENV{COPYCMD} = "/y";

my $cmd = "xcopy /q /r /i /e /k Perl\\* \"$prefix\" ";
system($cmd) && die "$!\n";

print "    Finished copying files...\n";

my $perl = "$prefix\\bin\\perl.exe";
$ENV{PATH} = "$prefix\\bin;$ENV{PATH}";

# system($perl, "$prefix/bin/reloc_perl", '-a', '-i', '-v', '-t', $prefix, $replace) == 0
#     or die "Couldn't run reloc_perl: $!";

# Relocate
if (open(my $reloc, "support/reloc.txt")) {
    my $sponge = $Config{prefix};
    die "Can't relocate to a path longer than " . length($sponge) . " chars"
	if length($prefix) > length($sponge);
    my $binary_pad = "\0" x (length($sponge) - length($prefix));

    my($sponge_str,$prefix_str) = ($sponge,$prefix);
    s,\\,\\\\,g for $sponge_str, $prefix_str;

    print "Relocating...";
    my $count = 0;
    local $_;
    while (<$reloc>) {
	chomp;
	my($type, $f) = split(' ', $_, 2);
	$f = "$prefix/$f";
	$f =~ s,/,\\,g;
	#print "Relocating $f...\n";
	my $read_only;
	unless (-w $f) {
	    $read_only++;
	    run("\@attrib", "-r", $f);
	}

	open(my $fh, "+<", $f) || die "Can't open $f: $!";
	binmode($fh);
	my $content = do { local $/; <$fh> };

	if ($type eq "B") {
	    $content =~ s,\Q$sponge\E([^\0]*),$prefix$1$binary_pad,go;
	}
	else {
	    $content =~ s,\Q$sponge\E,$prefix,go;
	    $content =~ s,\Q$sponge_str\E,$prefix_str,go if $^O eq "MSWin32";
	    truncate($fh, length($content)) || die "Can't truncate '$f': $!";
	}

	seek($fh, 0, 0) || die "Can't reset file pos on '$f': $!";
	print $fh $content;
	close($fh) || die "Can't write back content to '$f': $!";

	run("\@attrib", "+r", $f) if $read_only;

	$count++;
    }
    print "done ($count files relocated)\n";
}

if ($^O eq 'MSWin32') {
    create_html_shortcuts() if $create_html_shortcuts;
    create_file_association() if $create_file_association;

    my $perl83 = Win32::GetShortPathName($perl);
    create_script_mapping(".pl", qq("$perl83 \\"%s\\" %s")) if $create_perl_mapping;

    my $perlis = Win32::GetShortPathName("$prefix\\bin\\perlis.dll");
    create_script_mapping(".plx", $perlis) if $create_isapi_mapping;

    create_registry_entries();
    update_path() if $add_path;
    configure_configpm();
}

configure_ppm();
build_html();

print <<EOT;

Thank you for installing $product!

EOT

if (Win32::IsWin95) {
    sleep 5; #STDIN is dead
}
else {
    print "Press return to exit.\n";
    <>;
}

exit;

sub configure_configpm
{
    my ($LIB, $INC);

    my $config_pm = "$prefix\\lib\\Config.pm";
    print "\nConfiguring $config_pm for use in $prefix...\n\n";

    system($perl, "$prefix/bin/config.pl", $prefix) == 0
        or die "Couldn't config $config_pm: $!";

    # Create values for libpth and incpath in Config.pm
    if (defined $ENV{'LIB'}) {
        $LIB = '"' . join(q(" "), split(/;/, $ENV{'LIB'})) . '" ';
    } else {
        $LIB = '/lib /usr/lib /usr/local/lib ';
    }
    $LIB .= qq("$prefix\\lib\\CORE");

    if (defined $ENV{'INCLUDE'}) {
        $INC = '"' . join(q(" "), split(/;/, $ENV{'INCLUDE'})) . '" ';
    } else {
        $INC = '/usr/include /usr/local/include ';
    }
    $INC .= qq("$prefix\\lib\\CORE");

    open (my $fh, "<", $config_pm) or die "Can't open $config_pm for reading: $!";
    my @Config = <$fh>;
    close($fh);
    foreach(@Config) {
        s@^libpth=.*$@libpth='$LIB'@g;
        s@^incpath=.*$@incpath='$INC'@g;
    }

    chmod 0666, $config_pm;
    open ($fh, ">", $config_pm) or die "Can't open $config_pm for writing: $!";
    print $fh @Config;
    close($fh);
    chmod 0444, $config_pm;
}


sub configure_ppm
{
    print "\nConfiguring PPM for use in $prefix...\n\n";

    if (-f "$prefix/bin/ppm2.bat") {
	system($perl, "$prefix/bin/ppm2.bat", 'set', 'build', $temp) == 0
	    or die "Couldn't set ppm2 BUILDDIR: $!";
    }
    if (-f "$prefix/bin/ppm3.bat") {
	system($perl, "$prefix/bin/ppm3.bat", 'set', 'tempdir', $temp) == 0
	    or die "Couldn't set ppm3 TEMPDIR: $!";
    }

    local $ENV{ACTIVEPERL_PPM_SETUP_TIME} = 1;
    run("\@$prefix/bin/perl", "-MActivePerl::PPM::InstallArea", "-e", "ActivePerl::PPM::InstallArea->new('perl')->sync_db(keep_package_version => 1)");
    print <<'EOT';

If you are behind a firewall, you may need to set the HTTP_PROXY
environment variable so that PPM will operate properly:

    set HTTP_PROXY=http://address:port
or
    set HTTP_PROXY=http://username:password@address:port

For example

    set HTTP_PROXY=http://192.0.0.1:8080

Note that the "http://" part of the URL is required!

EOT

}

sub build_html {
    print "\nBuilding HTML documentation, please wait...\n\n";

    # Can't do this in-process because the relocated Config.pm and
    # %Config can't be reloaded easily
    system($perl, "-MActivePerl::DocTools", "-e", "UpdateHTML('wait')") == 0
	or die "Failed to build HTML documentation\n";
}

sub create_html_shortcuts
{
    my ($key, $location);
    $key = 'Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\\';
    $key .= Win32::IsWin95() ? 'Programs' : 'Common Programs';

    my $try = Get(HKEY_LOCAL_MACHINE, $key, \$location);

    unless ($try) {
        $key = 'Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\Programs';
        $location = undef;
        $try = Get(HKEY_CURRENT_USER, $key, \$location);
    }

    unless ($try) {
        warn 'Read of shortcut dir failed: '. Win32::FormatMessage(Win32::GetLastError()) ."\n";
        return undef;
    }

    $location .= sprintf("/%s %vd Build %s", $product, $^V, $APVersion);
    $location .= " (64-bit)" if $Config{ptrsize} == 8;
    mkdir($location, 0777) unless -d $location;

    my $link = new Win32::Shortcut();
    # Stupid NT can't handle / path separator in the shortcut
    ($link->{'Path'} = "$prefix\\html\\index.html") =~ s@/@\\@g;
    ($link->{'WorkingDirectory'} = "$prefix\\html") =~ s@/@\\@g;
    $link->{'Description'} = "$product Documentation in HTML format.";
    $link->{'ShowCmd'} = SW_SHOWNORMAL;
    $link->Save("$location\\Documentation.lnk");

    unless ($is_enterprise) {
	foreach my $cmd (qw(ppm3-bin ppm)) {
	    my $path = "$prefix\\bin\\$cmd.bat";
	    next unless -f $path;
	    $link = new Win32::Shortcut();
	    ($link->{'Path'} = "$prefix\\bin\\wperl.exe") =~ s@/@\\@g;
	    ($link->{'WorkingDirectory'} = "$prefix\\bin") =~ s@/@\\@g;
	    $link->{'Description'} = "Perl Package Manager.";
	    $link->{'ShowCmd'} = SW_SHOWNORMAL;
	    $link->{'Arguments'} = "-x $cmd.bat";
	    $link->Save("$location\\Perl Package Manager.lnk");
	    last;
	}

	my $path = "$prefix\\html\\site\\lib\\Win32\\OLE\\Browser.html";
	$path = "$prefix\\html\\lib\\Win32\\OLE\\Browser.html" unless -f $path;

	$link = new Win32::Shortcut();
	($link->{'Path'} = $path) =~ s@/@\\@g;
	($link->{'WorkingDirectory'} = dirname($path)) =~ s@/@\\@g;
	$link->{'Description'} = "OLE Browser.";
	$link->{'ShowCmd'} = SW_SHOWNORMAL;
	$link->Save("$location\\OLE-Browser.lnk");
    }
}

sub create_registry_entries
{
    # Attempt to set some registry entries.
    (my $prefix = $prefix) =~ s@/@\\@g;

    Set(HKEY_LOCAL_MACHINE, "SOFTWARE\\ActiveState\\$product\\CurrentVersion", $APVersion, REG_SZ)
	|| warn "Couldn't make registry entry: $!\n";

    Set(HKEY_LOCAL_MACHINE, "SOFTWARE\\ActiveState\\$product\\$APVersion\\", $prefix, REG_SZ)
	|| warn "Couldn't make registry entry: $!\n";

    Set(HKEY_LOCAL_MACHINE, 'Software\Perl\\', $prefix, REG_SZ)
	|| warn "Couldn't make registry entry: $!\n";

    Set(HKEY_LOCAL_MACHINE, 'Software\Perl\BinDir', $perl, REG_SZ)
	|| warn "Couldn't make registry entry: $!\n";

    Win32::RegisterServer("$prefix\\bin\\PerlSE.dll")
	|| warn "Couldn't register PerlScript engine\n";

    Win32::RegisterServer("$prefix\\bin\\PerlMsg.dll")
	|| warn "Couldn't register Perl eventlog message catalog\n";
}

sub create_file_association
{
    # Don't leave a space between 'Perl' and '>nul'.
    # See http://bugs.activestate.com/show_bug.cgi?id=68656
    system("assoc .pl=Perl>nul") == 0
	or warn "Could not create .pl file type association\n";
    system(qq(ftype Perl="$perl" "%1" %* >nul)) == 0
	or warn "Could not define command to run .pl files\n";
}

sub create_script_mapping
{
    my($ext,$path) = @_;
    if (-f $ap_iis_config) {
	system($perl, "-x", $ap_iis_config, qw(add map --ext), $ext) == 0
	    or warn "Could not set the script mapping for $ext\n";
    }
    elsif (-f $IISScriptMap) {
	system($perl, $IISScriptMap, "0;1", "", $ext, $path) == 0
	    or warn "Could not set the script mapping for $ext\n";
    }
}

sub update_path
{
    my @path;
    foreach (qw(site/bin bin)) {
	my $dir = "$prefix/$_";
	next if $APVersion < 819 && $dir =~ m,/site/bin$,;
	$dir =~ s,/,\\,g;
	$dir = qq("$dir") if Win32::IsWin95() && index($dir, " ") >= 0;
	push @path, $dir;
    }
    unless (@path) {
	warn "Couldn't find bin directories to add to PATH\n";
	return;
    }

    if (Win32::IsWin95()) {
	my $perlbin = join(";", @path);
	my $path_set = 0;

	if ($ENV{winbootdir}) {
	    my $autoexec = substr($ENV{winbootdir},0,2) .'\autoexec.bat';
	    if (-e $autoexec && ! -w $autoexec) {
		chmod 0755, $autoexec;
	    }
	    if (open(my $F, ">>$autoexec")) {
		print $F "\nSET PATH=$perlbin;%PATH%\n";
		close $F;
		++$path_set;
	    }
	    else {
		warn "Unable to open $autoexec for writing: $!\n";
	    }
	}
	else {
	    warn "No winbootdir environment variable found.\n";
	}
	unless ($path_set) {
	    print <<EOT;

The PATH has not been updated to include '$perlbin'.
You can edit your AUTOEXEC.BAT to add this yourself later.

EOT
	}
	return;
    }

    my $path;
    Get(HKEY_LOCAL_MACHINE, 'System\CurrentControlSet\Control\Session Manager\Environment\Path', \$path)
	|| warn "Unable to read PATH from registry: $!\n";

    foreach my $dir (reverse @path) {
	$path = "$dir;$path" unless $path =~ m,\Q$dir\E,;
    }
    Set(HKEY_LOCAL_MACHINE, 'System\CurrentControlSet\Control\Session Manager\Environment\Path', $path, REG_EXPAND_SZ)
	|| warn "Unable to update PATH in registry: $!\n";
}

sub remove_html_shortcuts
{
    my ($key, $location);
    $key = 'Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\\';
    $key .= Win32::IsWin95() ? 'Programs' : 'Common Programs';

    Get(HKEY_LOCAL_MACHINE, $key, \$location)
	|| warn 'Read of shortcut dir failed: '. Win32::FormatMessage(Win32::GetLastError()) ."\n";

    $location .= '/ActiveState $product';
    unlink("$location/Online Documentation.lnk");
    unlink("$location/Perl Package Manager.lnk");
    unlink("$location/OLE-Browser.lnk");
    unlink($location);
}

sub Get
{
    my ($root, $key, $data) = @_;

    if (defined $$data) {warn "\$data set in Get!"}
    my $hkey;
    my $type;
    $key =~ s#(.*)\\(.*)$#$1#;
    my $value = $2;

    Win32API::Registry::RegOpenKeyEx($root, $key, 0, KEY_READ, $hkey)
	|| return undef;

    Win32API::Registry::RegQueryValueEx( $hkey, $value, [], $type, $$data, [])
	|| return undef;

    return 1;
}

sub Set
{
    my ($root, $key, $data, $type) = @_;
    my $hkey;
    $key =~ s#(.*)\\(.*)$#$1#;
    my $value = $2;

    Win32API::Registry::RegCreateKeyEx($root, $key, 0, '', REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, [], $hkey, [])
	|| return undef;

    if (defined $data) {
	my $olddata;

	if (! $type and Win32API::Registry::RegQueryValueEx($hkey, $value, [], $type, $olddata)) {
	    $type = REG_SZ;
	    warn "assuming type REG_SZ\n";
	}
	Win32API::Registry::RegSetValueEx($hkey, $value, 0, $type, $data, 0)
	    || return undef;
    }
    else {
	Win32API::Registry::RegDeleteValue($hkey, $value)
	    || return undef;
    }
    Win32API::Registry::RegCloseKey($hkey)
	|| return undef;

    return 1;
}

sub can_write {
    my $d = shift;
    my $ok = 0;
    my $file = $d;
    if (-d $d) {
	$file = "$d/foozle.$$";
    }
    $ok = open(TEST, ">", $file);
    close TEST;
    unlink($file) if $ok;
    return $ok;
}

__END__
:endofperl
