#-------------------------------------------------------------------------------
#  ContentBlockConstants.pm:
#  Module with constants to tag block content
#
#  Author    : Fa. Maas
#  Copyright : (C) 2017 by Maas Holding GmbH
#
#  $V100   2017-09-12    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::ContentBlockConstants;

#-------------------------------------------------------------------------------
# Declare constants
#-------------------------------------------------------------------------------
#---- Constants for block types
$BLOCK_TYPE_PARAGRAPH    = 0x01000000;
$BLOCK_TYPE_LIST         = 0x02000000;
$BLOCK_TYPE_TABLE        = 0x03000000;
$BLOCK_TYPE_ILLUSTRATION = 0x04000000;

#---- Constants for paragraph
$TAG_CLASSIFICATION_PARA_ELEMENT_P        = 0x00000001;
$TAG_CLASSIFICATION_PARA_ELEMENT_H        = 0x00000002;
$TAG_CLASSIFICATION_PARA_ELEMENT_H1       = 0x00000004;
$TAG_CLASSIFICATION_PARA_ELEMENT_H2       = 0x00000008;
$TAG_CLASSIFICATION_PARA_ELEMENT_H3       = 0x00000010;
$TAG_CLASSIFICATION_PARA_ELEMENT_H4       = 0x00000020;
$TAG_CLASSIFICATION_PARA_ELEMENT_H5       = 0x00000040;
$TAG_CLASSIFICATION_PARA_ELEMENT_H6       = 0x00000080;

$TAG_CLASSIFICATION_PARA_ELEMENT_P_BEGIN  = ( $BLOCK_TYPE_PARAGRAPH | 0x00000100 | $TAG_CLASSIFICATION_PARA_ELEMENT_P );
$TAG_CLASSIFICATION_PARA_ELEMENT_P_END    = ( $BLOCK_TYPE_PARAGRAPH | 0x00000200 | $TAG_CLASSIFICATION_PARA_ELEMENT_P );
$TAG_CLASSIFICATION_PARA_ELEMENT_H_BEGIN  = ( $BLOCK_TYPE_PARAGRAPH | 0x00000400 | $TAG_CLASSIFICATION_PARA_ELEMENT_H );
$TAG_CLASSIFICATION_PARA_ELEMENT_H_END    = ( $BLOCK_TYPE_PARAGRAPH | 0x00000800 | $TAG_CLASSIFICATION_PARA_ELEMENT_H );
$TAG_CLASSIFICATION_PARA_ELEMENT_H1_BEGIN = ( $BLOCK_TYPE_PARAGRAPH | 0x00001000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H1 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H1_END   = ( $BLOCK_TYPE_PARAGRAPH | 0x00002000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H1 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H2_BEGIN = ( $BLOCK_TYPE_PARAGRAPH | 0x00004000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H2 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H2_END   = ( $BLOCK_TYPE_PARAGRAPH | 0x00008000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H2 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H3_BEGIN = ( $BLOCK_TYPE_PARAGRAPH | 0x00010000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H3 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H3_END   = ( $BLOCK_TYPE_PARAGRAPH | 0x00020000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H3 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H4_BEGIN = ( $BLOCK_TYPE_PARAGRAPH | 0x00040000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H4 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H4_END   = ( $BLOCK_TYPE_PARAGRAPH | 0x00080000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H4 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H5_BEGIN = ( $BLOCK_TYPE_PARAGRAPH | 0x00100000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H5 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H5_END   = ( $BLOCK_TYPE_PARAGRAPH | 0x00200000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H5 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H6_BEGIN = ( $BLOCK_TYPE_PARAGRAPH | 0x00400000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H6 );
$TAG_CLASSIFICATION_PARA_ELEMENT_H6_END   = ( $BLOCK_TYPE_PARAGRAPH | 0x00800000 | $TAG_CLASSIFICATION_PARA_ELEMENT_H6 );

#---- Constants for list
$TAG_CLASSIFICATION_LIST_ELEMENT_L           = 0x00000001;
$TAG_CLASSIFICATION_LIST_ELEMENT_LI          = 0x00000002;
$TAG_CLASSIFICATION_LIST_ELEMENT_LBL         = 0x00000004;
$TAG_CLASSIFICATION_LIST_ELEMENT_LBODY       = 0x00000008;

$TAG_CLASSIFICATION_LIST_ELEMENT_L_BEGIN     = ( $BLOCK_TYPE_LIST | 0x00000100 | $TAG_CLASSIFICATION_LIST_ELEMENT_L );
$TAG_CLASSIFICATION_LIST_ELEMENT_L_END       = ( $BLOCK_TYPE_LIST | 0x00000200 | $TAG_CLASSIFICATION_LIST_ELEMENT_L );
$TAG_CLASSIFICATION_LIST_ELEMENT_LI_BEGIN    = ( $BLOCK_TYPE_LIST | 0x00000400 | $TAG_CLASSIFICATION_LIST_ELEMENT_LI );
$TAG_CLASSIFICATION_LIST_ELEMENT_LI_END      = ( $BLOCK_TYPE_LIST | 0x00000800 | $TAG_CLASSIFICATION_LIST_ELEMENT_LI );
$TAG_CLASSIFICATION_LIST_ELEMENT_LBL_BEGIN   = ( $BLOCK_TYPE_LIST | 0x00001000 | $TAG_CLASSIFICATION_LIST_ELEMENT_LBL );
$TAG_CLASSIFICATION_LIST_ELEMENT_LBL_END     = ( $BLOCK_TYPE_LIST | 0x00002000 | $TAG_CLASSIFICATION_LIST_ELEMENT_LBL );
$TAG_CLASSIFICATION_LIST_ELEMENT_LBODY_BEGIN = ( $BLOCK_TYPE_LIST | 0x00004000 | $TAG_CLASSIFICATION_LIST_ELEMENT_LBODY );
$TAG_CLASSIFICATION_LIST_ELEMENT_LBODY_END   = ( $BLOCK_TYPE_LIST | 0x00008000 | $TAG_CLASSIFICATION_LIST_ELEMENT_LBODY );

#---- Constants for table
$TAG_CLASSIFICATION_TABLE_ELEMENT_TABLE        = 0x00000001;
$TAG_CLASSIFICATION_TABLE_ELEMENT_TR           = 0x00000002;
$TAG_CLASSIFICATION_TABLE_ELEMENT_TH           = 0x00000004;
$TAG_CLASSIFICATION_TABLE_ELEMENT_TD           = 0x00000008;
$TAG_CLASSIFICATION_TABLE_ELEMENT_THEAD        = 0x00000010;
$TAG_CLASSIFICATION_TABLE_ELEMENT_TBODY        = 0x00000020;
$TAG_CLASSIFICATION_TABLE_ELEMENT_TFOOT        = 0x00000040;

$TAG_CLASSIFICATION_TABLE_ELEMENT_TABLE_BEGIN  = ( $BLOCK_TYPE_TABLE | 0x00000100 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TABLE );
$TAG_CLASSIFICATION_TABLE_ELEMENT_TABLE_END    = ( $BLOCK_TYPE_TABLE | 0x00000200 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TABLE );
$TAG_CLASSIFICATION_TABLE_ELEMENT_TR_BEGIN     = ( $BLOCK_TYPE_TABLE | 0x00000400 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TR );
$TAG_CLASSIFICATION_TABLE_ELEMENT_TR_END       = ( $BLOCK_TYPE_TABLE | 0x00000800 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TR );
$TAG_CLASSIFICATION_TABLE_ELEMENT_TH_BEGIN     = ( $BLOCK_TYPE_TABLE | 0x00001000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TH );
$TAG_CLASSIFICATION_TABLE_ELEMENT_TH_END       = ( $BLOCK_TYPE_TABLE | 0x00002000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TH );
$TAG_CLASSIFICATION_TABLE_ELEMENT_TD_BEGIN     = ( $BLOCK_TYPE_TABLE | 0x00004000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TD );
$TAG_CLASSIFICATION_TABLE_ELEMENT_TD_END       = ( $BLOCK_TYPE_TABLE | 0x00008000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TD );
$TAG_CLASSIFICATION_TABLE_ELEMENT_THEAD_BEGIN  = ( $BLOCK_TYPE_TABLE | 0x00010000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_THEAD );
$TAG_CLASSIFICATION_TABLE_ELEMENT_THEAD_END    = ( $BLOCK_TYPE_TABLE | 0x00020000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_THEAD );
$TAG_CLASSIFICATION_TABLE_ELEMENT_TBODY_BEGIN  = ( $BLOCK_TYPE_TABLE | 0x00040000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TBODY );
$TAG_CLASSIFICATION_TABLE_ELEMENT_TBODY_END    = ( $BLOCK_TYPE_TABLE | 0x00080000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TBODY );
$TAG_CLASSIFICATION_TABLE_ELEMENT_LFOOT_BEGIN  = ( $BLOCK_TYPE_TABLE | 0x00100000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TFOOT );
$TAG_CLASSIFICATION_TABLE_ELEMENT_LFOOT_END    = ( $BLOCK_TYPE_TABLE | 0x00200000 | $TAG_CLASSIFICATION_TABLE_ELEMENT_TFOOT );

#---- Constants for illustration
$TAG_CLASSIFICATION_ILLUSTRATION_ELEMENT_FIGURE       = 0x00000001;

$TAG_CLASSIFICATION_ILLUSTRATION_ELEMENT_FIGURE_BEGIN = ( $BLOCK_TYPE_ILLUSTRATION | 0x00000100 | $TAG_CLASSIFICATION_ILLUSTRATION_ELEMENT_FIGURE );
$TAG_CLASSIFICATION_ILLUSTRATION_ELEMENT_FIGURE_END   = ( $BLOCK_TYPE_ILLUSTRATION | 0x00000200 | $TAG_CLASSIFICATION_ILLUSTRATION_ELEMENT_FIGURE );

#---- Common block property constants
$BLOCK_PROP_ALTERNATE_TEXT = "AlternateText";

#---- Table block property constants
$TABLE_BLOCK_PROP_HEADER_SCOPE = "HeaderScope";

#-------------------------------------------------------------------------------
# Don't remove the following lines !!!
#-------------------------------------------------------------------------------
1;
__END__
