#-------------------------------------------------------------------------------
#  ConfigConstants.pm:
#  Module with configuration constants
#
#  Author    : Fa. Maas
#  Copyright : (C) 2015 by Maas Holding GmbH
#
#  $V100   2009-12-31    Initial Release
#
#  $V101   2012-09-25    Added 'AutoRotateImage' config option constant
#
#  $V102   2013-12-03    Added 'AFPOutputFlags' config option constant
#
#  $V103   2014-07-04    Added 'ImageProcessValues' config option constant
#
#  $V104   2014-08-04    Added 'ScriptWriter' config option constant
#
#  $V105   2015-05-14    Added 'ScaleToSize' config option constant
#
#  $V106   2015-10-06    Added 'ObjectContainerPath' config option constant
#
#-------------------------------------------------------------------------------
package a2w::ConfigConstants;

#-------------------------------------------------------------------------------
# Declare constants
#-------------------------------------------------------------------------------
$INIPATH                   = "IniFilePath";
$INIFILENAME               = "IniFilename";
$LICENSEE                  = "Licensee";
$SERIALNR                  = "SerialNr";
$TITLE                     = "Title";
$SUBJECT                   = "Subject";
$KEYWORDS                  = "Keywords";
$LOGGING                   = "Logging";
$LOGGINGFONT               = "LoggingFont";
$LOGGINGLEVEL              = "LoggingLevel";
$EXCEPTIONLOGGINGLEVEL     = "ExceptionLoggingLevel";
$LOGPATH                   = "LogPath";
$RESPATH                   = "ResPath";
$CPPATH                    = "CpPath";
$CODEPAGE                  = "CodePage";
$OUTPUTFILEPATH            = "OutputFilePath";
$INDEXPATH                 = "IndexPath";
$INDEXFORMAT               = "IndexFormat";
$INDEXRECORD               = "IndexRecord";
$PAGEPARSE                 = "PageParse";
$OUTPUTFORMAT              = "OutputFormat";
$INPUTFORMAT               = "InputFormat";
$RESOLUTION                = "Resolution";
$FORMATTYPE                = "FormatType";
$IOMODE                    = "IOMode";
$COLOR                     = "Color";
$PAGEOUTPUT                = "PageOutput";
$STATISTIC                 = "Statistic";
$PROTOCOL                  = "Protocol";
$PDFCOMPRESSION            = "PDFCompression";
$FILECREATIONMODE          = "FileCreationMode";
$PAGELENGTH                = "PageLength";
$QUIETMODE                 = "QuietMode";
$CREATOR                   = "Creator";
$EXTFONTPATH               = "ExtFontPath";
$AFPFONTPATH               = "AFPFontPath";
$GENERATEUNIQUEFILE        = "GenerateUniqueFile";
$PDFDOCLIMITS              = "PDFDocLimits";
$PDFUIOPTIONS              = "PDFUIOptions";
$PDFWINOPTIONS             = "PDFWinOptions";
$FORMDEFEXT                = "FormdefExt";
$OVERLAYEXT                = "OverlayExt";
$PAGESEGEXT                = "PageSegExt";
$CHARSETEXT                = "CharSetExt";
$CODEPAGEEXT               = "CodePageExt";
$CODEDFONTEXT              = "CodedFontExt";
$CODEPAGEDEFAULTCHAR       = "CodePageDefaultChar";
$LAUNCHPREVIEW             = "LaunchPreview";
$PDFBOOKMARK               = "PDFBookMark";
$MAXCOLS                   = "MaxCols";
$MAXROWS                   = "MaxRows";
$OVERLAYPATH               = "OverlayPath";
$PAGESEGMENTPATH           = "PageSegmentPath";
$FORMDEFPATH               = "FormDefPath";
$STRICT                    = "Strict";
$DOCUMENTCOUNT             = "DocumentCount";
$STARTINGDOCUMENT          = "StartingDocument";
$ENDINGDOCUMENT            = "EndingDocument";
$STARTINGPAGE              = "StartingPage";
$ENDINGPAGE                = "EndingPage";
$JPEGQUALITY               = "JPEGQuality";
$WATERMARK                 = "Watermark";
$SAVEOCDATAONDISK          = "SaveOCDataOnDisk";
$TEMPPATH                  = "TempPath";
$MARKER_HEIGHT             = "MarkerHeight";
$MARKER_WIDTH              = "MarkerWidth";
$SCRIPTARGUMENT            = "ScriptArgument";
$SCRIPTPROCEDURE           = "ScriptProcedure";
$SCRIPTUNITBASE            = "ScriptUnitBase";
$FILENAMEPATTERN           = "FilenamePattern";
$SKIPPAGE                  = "SkipPage";
$SKIPOBJECTSIZE            = "SkipObjectSize";
$PDFSECURITY               = "PDFSecurity";
$CMYKTORGB                 = "CMYKTORGB";
$AUTOSPLIT                 = "Autosplit";
$MEMORYOUTPUTSTREAM        = "MemoryOutputStream";
$RESOURCEGROUP             = "ResourceGroup";
$IMAGE_RESIZE_FILTER       = "ImageResizeFilter";
$IMAGE_ROT_FILTER          = "ImageRotationFilter";
$COLORSPACE                = "Colorspace";
$CODEDOUTPUT               = "CodedOutput";
$FLUSH                     = "Flush";
$PDFALEVEL                 = "PDFALevel";
$SPOOLFILETYPE             = "SpoolFileType";
$RESOURCEGROUPFILENAME     = "ResourceGroupFilename";
$DOCUMENTINDEXFILENAME     = "DocumentIndexFilename";
$FORMDEFFILENAME           = "FormdefFilename";
$PAGEROTATION              = "PageRotation";
$IMAGEMAXCACHESIZE         = "ImageMaxCacheSize";
$FONTRESOLUTION            = "FontResolution";
$AFPCOMPLIANCELEVEL        = "AFPComplianceLevel";
$MAXVECTOROBJECTS          = "MaxVectorObjects";
$FONTALIASING              = "FontAliasing";
$OUTPUTSIZE                = "OutputSize";
$NOCONSOLEMESSAGE          = "NoConsoleMessage";
# $V101 Begin
$AUTO_ROTATE_IMAGE         = "AutoRotateImage";
# $V101 End
# $V102 Begin
$AFPOUTPUTFLAGS            = "AFPOutputFlags";
# $V102 End
# $V103 Begin
$IMAGEPROCESSVALUES        = "ImageProcessValues";
# $V103 End
# $V104 Begin
$SCRIPTWRITER              = "ScriptWriter";
# $V104 End
# $V105 Begin
$SCALETOSIZE               = "ScaleToSize";
# $V105 End
# $V106 Begin
$OBJECTCONTAINERPATH       = "ObjectContainerPath";
# $V106 End

#-------------------------------------------------------------------------------
# Don't remove the following lines !!!
#-------------------------------------------------------------------------------
1;
__END__
