#-------------------------------------------------------------------------------
#  ImageConstants.pm:
#  Module with Image constants
#
#  Author  : Fa. Maas
#  Date    : 2013-12-13
#  Version : 1.0.0
#
#  $V100    2013-12-13    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::ImageConstants;

#-------------------------------------------------------------------------------
# Declare constants
#-------------------------------------------------------------------------------
#---- Compression ID constants ----#
$COMPRESSION_UNCOMPRESSED          =  0;
$COMPRESSION_CCITT_G3              =  1;
$COMPRESSION_CCITT_G3_2D           =  2;
$COMPRESSION_CCITT_G4              =  3;
$COMPRESSION_AFP_IOCA_IBM_MMR      =  4;
$COMPRESSION_AFP_IOCA_RL4          =  5;
$COMPRESSION_AFP_IOCA_ABIC         =  6;
$COMPRESSION_AFP_IOCA_ABIC_CONCAT  =  7;
$COMPRESSION_AFP_IOCA_OS2_COLOR    =  8;
$COMPRESSION_JPEG                  =  9;
$COMPRESSION_JPEG_OLD              = 10;
$COMPRESSION_LZW                   = 11;
$COMPRESSION_PACK_BITS             = 12;
$COMPRESSION_PNG                   = 13;
$COMPRESSION_RLE8                  = 14;
$COMPRESSION_GIF                   = 15;
$COMPRESSION_PCX                   = 16;
$COMPRESSION_BMP                   = 17;
$COMPRESSION_RLE4                  = 18;
$COMPRESSION_UNSUPPORTED           = 19;
$COMPRESSION_CCITT_RLE             = 20;
$COMPRESSION_CCITT_RLEW            = 21;
$COMPRESSION_IT8_CT_PAD            = 22;
$COMPRESSION_IT8_LW                = 23;
$COMPRESSION_IT8_MP                = 24;
$COMPRESSION_IT8_BL                = 25;
$COMPRESSION_PIXAR_FILM            = 26;
$COMPRESSION_PIXAR_LOG             = 27;
$COMPRESSION_DEFLATE               = 28;
$COMPRESSION_ADOBE_DEFLATE         = 29;
$COMPRESSION_THUNDERSCAN           = 30;
$COMPRESSION_NEXT                  = 31;
$COMPRESSION_KODAK_DCS             = 32;
$COMPRESSION_JBIG                  = 33;
$COMPRESSION_SGILOG                = 34;
$COMPRESSION_SGILOG_24             = 35;
$COMPRESSION_JPEG_2000             = 36;

#---- Compression Name constants ----#
%hshCompressionNames = (
      $COMPRESSION_UNCOMPRESSED          => "Uncompressed"
    , $COMPRESSION_CCITT_G3               => "CCITT G3"
    , $COMPRESSION_CCITT_G3_2D            => "CCITT G3 2D"
    , $COMPRESSION_CCITT_G4               => "CCITT G4"
    , $COMPRESSION_AFP_IOCA_IBM_MMR      => "IOCA IBM MMR"
    , $COMPRESSION_AFP_IOCA_RL4          => "IOCA RL4"
    , $COMPRESSION_AFP_IOCA_ABIC         => "IOCA ABIC"
    , $COMPRESSION_AFP_IOCA_ABIC_CONCAT  => "IOCA ABIC CONCAT"
    , $COMPRESSION_AFP_IOCA_OS2_COLOR    => "IOCA OS2 COLOR"
    , $COMPRESSION_JPEG                  => "JPEG"
    , $COMPRESSION_JPEG_OLD              => "JPEG OLD"
    , $COMPRESSION_LZW                   => "LZW"
    , $COMPRESSION_PACK_BITS             => "PACK BITS"
    , $COMPRESSION_PNG                   => "PNG"
    , $COMPRESSION_RLE8                  => "RLE8"
    , $COMPRESSION_GIF                   => "GIF"
    , $COMPRESSION_PCX                   => "PCX"
    , $COMPRESSION_BMP                   => "BMP"
    , $COMPRESSION_RLE4                  => "RLE4"
    , $COMPRESSION_UNSUPPORTED           => "UNSUPPORTED"
    , $COMPRESSION_CCITT_RLE             => "CCITT RLE"
    , $COMPRESSION_CCITT_RLEW            => "CCITT RLEW"
    , $COMPRESSION_IT8_CT_PAD            => "IT8 CT PAD"
    , $COMPRESSION_IT8_LW                => "IT8 LW"
    , $COMPRESSION_IT8_MP                => "IT8 MP"
    , $COMPRESSION_IT8_BL                => "IT8 BL"
    , $COMPRESSION_PIXAR_FILM            => "PIXAR FILM"
    , $COMPRESSION_PIXAR_LOG             => "PIXAR LOG"
    , $COMPRESSION_DEFLATE               => "DEFLATE"
    , $COMPRESSION_ADOBE_DEFLATE         => "ADOBE DEFLATE"
    , $COMPRESSION_THUNDERSCAN           => "THUNDERSCAN"
    , $COMPRESSION_NEXT                  => "NEXT"
    , $COMPRESSION_KODAK_DCS             => "KODAK DCS"
    , $COMPRESSION_JBIG                  => "JBIG"
    , $COMPRESSION_SGILOG                => "SGI LOG"
    , $COMPRESSION_SGILOG_24             => "SGI LOG 24"
    , $COMPRESSION_JPEG_2000             => "JPEG 2000"
);

#-------------------------------------------------------------------------------
# Don't remove the following lines !!!
#-------------------------------------------------------------------------------
1;
__END__
