#-------------------------------------------------------------------------------
#  a2w/core/dm/ConfigParser.pm
#
#  Perl module to parse blocks definition config
#
#  Author   : Panneer, AFP2web Team
#  Date     : 2014-02-14
#  Version  : 1.0.0
#
#  $V100   2014-02-14    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::core::dm::ConfigParser;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;
use a2w::core::dm::Constants;
use a2w::core::dm::Config;
use a2w::core::dm::Block;

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    my $this = {};

    bless( $this, $class );

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "new()" );
    #}

    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Parse blocks hash
#
# Returns a2w::core::dm::Config instance with blocks definition
#-----------------------------------------------------------------------
sub parseHash{
    my $this = shift;

    if ( $bLog == $TRUE ){
        $theLogger->logFunctionName( __PACKAGE__, "parseHash" );
    }

    #---- Get parameter
    #
    # 1. Blocks (hash reference)
    #
    my $hrefBlocksPar = shift;

    #---- Create config instance
    my $objConfigTmp = new a2w::core::dm::Config();

    #---- Fetch defined blocks list
    my @arrKeysTmp = sort keys( %{ $hrefBlocksPar } );
    if ( $bLog == $TRUE ){
        $theLogger->logMessage( "Configured Blocks:>@arrKeysTmp<" );
    }
    if ( @arrKeysTmp <= 0 ){
        return $objConfigTmp;
    }

    #---- Iterate through blocks list and create them ----#
    my $blkCurrentTmp    = undef;
    my $blkCurrentDefTmp = undef;
    foreach my $sBlkNameTmp ( @arrKeysTmp ){
        #---- Create block
        $blkCurrentDefTmp = $hrefBlocksPar->{ $sBlkNameTmp };
        if ( $bLog == $TRUE ){
            $theLogger->logMessage( "Name:>" . $sBlkNameTmp . "< Id:>" . $blkCurrentDefTmp->{ 'Id' } . "<" );
        }

        #---- Assert block configuration
        # If block id contain place holder and no content processor is defined, then it is error case
        # Also error, if content process does not contain index defined for given place holder
        if ( $blkCurrentDefTmp->{ 'Id' } =~ /(.*)/ ){
            my $sIdxNameTmp = $1;
            if (    not defined $blkCurrentDefTmp->{ 'ContentProcessor' }
                 || not defined $blkCurrentDefTmp->{ 'ContentProcessor' }{ 'IDX_' . $sIdxNameTmp }
               ){
                if ( $bLog == $TRUE ){
                    $theLogger->logMessage( "Warning! Id has place holder (" . $sIdxNameTmp . "), but no content processor defined with place holder index, Block ignored" );
                }
                next;    # Skip to next
            }
        }

        #---- Create block
        $blkCurrentTmp = new a2w::core::dm::Block();

        #---- Fill in block
        $blkCurrentTmp->fillIn( $blkCurrentDefTmp );

        #---- Add block to config
        $objConfigTmp->addBlock( $blkCurrentTmp );
    }
    return $objConfigTmp;
}

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__

