#-------------------------------------------------------------------------------
#  a2w/core/dm/Constants.pm
#
#  Perl module with constants needed for data mining
#
#  Author   : Panneer, AFP2web Team
#
#  $V100   2014-05-08    Initial Release
#
#  $V101   2015-08-21    Extended to tolerate texts with minor Y position difference as one line
#
#  $V102   2015-11-17    Extended with constant for object sequence id attribute
#
#  $V103   2015-12-09    Extended with constant for page margins (AFP-320)
#
#-------------------------------------------------------------------------------
package a2w::core::dm::Constants;

#-----------------------------------------------------------------------
# Declare constants
#-----------------------------------------------------------------------
#---- Define resource type values
$RT_FONT          = 1;            #---- Font resource
$RT_PSEG          = 2;            #---- Page segment resource
$RT_OVERLAY       = 3;            #---- Overlay resource

#---- Define object type values
$OT_TEXT          = 1;            #---- Text object
$OT_LINE          = 2;            #---- Line object
$OT_VECTOR        = 3;            #---- Vector object
$OT_IMAGE         = 4;            #---- Image object

#---- Define attribute type values
$AT_OBJTYPE       =  1;           #---- Object type
$AT_OBJINFO       =  2;           #---- Object info
$AT_XPOS          =  3;           #---- X position
$AT_YPOS          =  4;           #---- Y position
$AT_ANGLE         =  5;           #---- Angle
$AT_ID            =  6;           #---- Id
$AT_PAGE_COUNT    =  7;           #---- Page count
$AT_PAGE_ID       =  8;           #---- Page Id
$AT_COLOR         =  9;           #---- Color
$AT_RESOLUTION    = 10;           #---- Resolution
# $V102 Begin
$AT_OBJSEQID      = 11;           #---- Object sequence id 
# $V102 End

#---- Define object type specific info
$OI_TEXT_VALUE       = 1;         #---- Text value
$OI_TEXT_LENGTH      = 2;         #---- Text value length
$OI_TEXT_FONTID      = 3;         #---- Text applied font local id
$OI_TEXT_FONTHT      = 4;         #---- Text applied font height
                  
$OI_LINE_WIDTH       = 1;         #---- Line width
$OI_LINE_LENGTH      = 2;         #---- Line length
                  
$OI_VECTOR_WIDTH     = 1;         #---- Line width
$OI_VECTOR_HEIGHT    = 2;         #---- Line length
                  
$OI_IMAGE_WIDTH      = 1;         #---- Image width
$OI_IMAGE_HEIGHT     = 2;         #---- Image height
$OI_IMAGE_NAME       = 3;         #---- Image name
$OI_IMAGE_RESOLUTION = 4;         #---- Image resolution

#---- Define block id constants ----#
$BLK_DMF_PREFIX      = "A2W_DMF_";
$BLK_PAGE_DEF_PREFIX = $BLK_DMF_PREFIX . "PAGE_DEF_";

#---- Page related predefined block ids
$BLK_DOC_HEADER      = $BLK_DMF_PREFIX . "DOCUMENT_HEADER";
$BLK_PAGE_HEADER     = $BLK_DMF_PREFIX . "PAGE_HEADER";
$BLK_PAGE_BODY       = $BLK_DMF_PREFIX . "PAGE_BODY";
$BLK_PAGE_FOOTER     = $BLK_DMF_PREFIX . "PAGE_FOOTER";
$BLK_DOC_FOOTER      = $BLK_DMF_PREFIX . "DOCUMENT_FOOTER";

# $V101 Begin
#---- Content processing constants ----#
$CONT_LINE_TOLERANCE = 0.025;       #---- Value in Inches, Tolerate lines occurring consecutive within given range as ONE line
# $V101 End

# $V103 Begin
$PAGE_MARGIN_LEFT   = 0.1;         #---- Value in Inches, page left margin
$PAGE_MARGIN_RIGHT  = 0.1;         #---- Value in Inches, page right margin
$PAGE_MARGIN_TOP    = 0.1;         #---- Value in Inches, page top margin
$PAGE_MARGIN_BOTTOM = 0.1;         #---- Value in Inches, page bottom margin
# $V103 End

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
