#-------------------------------------------------------------------------------
#  a2w::core::dm::TableContentDef.pm:
#  Data Mining Framework Paragraph Content Definition
#
#  Author  : AFP2web Team, Maas Holding GmbH
#
#  $V100   2014-05-08    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::core::dm::TableContentDef;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;
use a2w::core::dm::Constants;
use a2w::core::dm::ContentDef;

#-----------------------------------------------------------------------
# Inherit from base class
#-----------------------------------------------------------------------
our @ISA = qw( a2w::core::dm::ContentDef );

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Instantiate from base class to inherit base class attributes
    my $this = a2w::core::dm::ContentDef->new( @_ );

    #---- Add this derived class specific attributes
    # Header is complex value used appropriate to define the header of table and possible values are explained below
    #
    # <FALSE | 1stRow | 1stColumn> | <Array reference to column names>
    # Default is "1stRow"
    #
    $this->{ 'Header' } = undef;

    # Columns is hash of column id and column start X position, which in turn used to split up the cell values of table row
    $this->{ 'Columns' } = undef;

    bless( $this, $class );

    #---- Set base class details
    $this->{ 'Type' } = 'table';

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    #---- Get logger
    our $theLogger = a2w::core::log::Logger::getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "new" );
    #}

    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Mutators
#-----------------------------------------------------------------------
sub setHeader{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setHeader()" );
    #}

    $this->{ 'Header' } = shift;
}

sub setColumns{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setColumns()" );
    #}

    $this->{ 'Columns' } = shift;
}

#-----------------------------------------------------------------------
# Accessors
#-----------------------------------------------------------------------
sub getHeader{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getHeader()" );
    #}

    return $this->{ 'Header' };
}

sub getColumns{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getColumns()" );
    #}

    return $this->{ 'Columns' };
}

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
sub isHeaderPredefined(){
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "isHeaderPredefined()" );
    #}

    return ( lc( ref( $this->{ 'Header' } ) ) eq "array" ) ? $TRUE : $FALSE;
}

sub isFirstRowHeader(){
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "isFirstRowHeader()" );
    #}

    return ( lc( $this->{ 'Header' } ) eq "1strow" ) ? $TRUE : $FALSE;
}

sub isFirstColumnHeader(){
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "isFirstColumnHeader()" );
    #}

    return ( lc( $this->{ 'Header' } ) eq "1stcolumn" ) ? $TRUE : $FALSE;
}

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
