#-------------------------------------------------------------------------------
#  a2w/core/utils/Base64.pm
#
#  Perl module to encode/decode data into base 64
#
#  Author   : Panneer, AFP2web Team
#
#  $V100    2015-07-17    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::core::utils::Base64;

#-----------------------------------------------------------------------
# Encode
#-----------------------------------------------------------------------
sub encode{
    #---- Get parameter
    #
    # 1. Data to encode
    my $binDataPar = shift;

    #---- Encode
    my $b64DataTmp = '';
    while ( $binDataPar =~ /(.{1,45})/gs ){
        chop( $b64DataTmp .= substr(pack("u",$1),1) );
    }
    $b64DataTmp =~ tr|` -_|AA-Za-z0-9+/|;

    #---- Apply padding
    my $binPadTmp = ( 3 - length( $binDataPar ) % 3 ) % 3;
    $b64DataTmp=~s/.{$binPadTmp}$/"="x$binPadTmp/e if $binPadTmp;

    #---- Break encoded data in to lines of 76 characters
    $b64DataTmp=~s/(.{1,76})/$1\n/g;

    return $b64DataTmp;

}

#-----------------------------------------------------------------------
# Decode
#-----------------------------------------------------------------------
sub decode{
    #---- Get parameter
    #
    # 1. Data to decode
    my $b64DataPar = shift;

    #---- Decode
    $b64DataPar =~ tr!A-Za-z0-9+/!!cd;
    $b64DataPar =~ s/=+$//;
    $b64DataPar =~ tr!A-Za-z0-9+/! -_!;

    my $binDataTmp = '';
    while ( $b64DataPar =~ /(.{1,60})/gs ){ 
        my $len = chr( 32 + length( $1 ) * 3 / 4 );
        $binDataTmp .= unpack( "u", $len . $1 );
    } 

    return $binDataTmp;
}

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
