#-------------------------------------------------------------------------------
#  customers::epcums1:
#  PERL module to define the content blocks of page/document
#
#  Author  : AFP2web Team
#
#  Date:   2015-01-20    Initial Release
#
#-------------------------------------------------------------------------------
package customers::banbds1;
#package customers::epcums1;

my $iBlockId = 1;

%Blocks = (
#---- Document Start CSS Injection ----#
'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'A2W_DMF_PAGE_HEADER',
	'ContentDef' => {
		'Type' => 'Paragraph',
		'AddContent' => {
			'A2W_DMF_DOC_HEAD' => {
				'Include' => 'Before',
				'Content' => '<link rel="stylesheet" type="text/css" href="epcu/css/monthlystatement.html.css" /> 
<script src="/javascripts/application.js?1362423724" type="text/javascript"></script>'
			}
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'STMT_OF_ACCT',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 8208"
			},
			'COND2' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 288"
            		},
            		'COND3' => {
                		'OBJ_TYPE' => 'LINE',
                		'CONDITION' => "ATTR_LENGTH EQ 6"
            		},
            		'COND4' => {
                		'OBJ_TYPE' => 'LINE',
                		'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        	'COND1' => {
    	        	'OBJ_TYPE' => 'LINE',
                	'CONDITION' => "ATTR_XPOS EQ 10800"
        		},
            	'COND2' => {
                	'OBJ_TYPE' => 'LINE',
                	'CONDITION' => "ATTR_YPOS EQ 518"
            	},
        	'COND3' => {
            		'OBJ_TYPE' => 'LINE',
            		'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    	'COND4' => {
                	'OBJ_TYPE' => 'LINE',
        	    	'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 3448,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'Separator' => ' '
		}
	}
},


'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'PG1_HDR1',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 9346"
			},
			'COND2' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 706"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11664"
        	},
            'COND2' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 1008"
            },
        	'COND3' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    'COND4' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 2318,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'Separator' => ' '
		}
	}
},


'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'PG1_HDR2',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 9346"
			},
			'COND2' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 1037"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11664"
        	},
            'COND2' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 1368"
            },
        	'COND3' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    'COND4' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 2318,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'Separator' => ' '
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'PG1_HDR3',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 9346"
			},
			'COND2' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 1512"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11664"
        	},
            'COND2' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 1800"
            },
        	'COND3' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    'COND4' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 2318,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'Separator' => ' '
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'ADDRESS',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2146"
			},
			'COND2' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 3024"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
            }
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 7200"
            },
            'COND2' => {
                'OBJ_TYPE'  => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 4284"
            },
            'COND3' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 5054,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'Separator' => ' '
		}
	}

},


'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'SECTION_HEADER',
	'StartAnchor' => {
		'Constraints' => {
		'COND1' => {
    		        'OBJ_TYPE' => 'LINE',
        	        'CONDITION' => "ATTR_XPOS EQ 936"
		},
		'COND2' => {
    	        	'OBJ_TYPE' => 'LINE',
			'CONDITION' => "ATTR_WIDTH EQ 6"
		},
            	'COND3' => {
                	'OBJ_TYPE' => 'LINE',
            		'CONDITION' => "ATTR_LENGTH EQ 6"
                }	
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        	'OBJ_TYPE' => 'LINE',
                	'CONDITION' => "ATTR_XPOS EQ 11808"
        	},
        	'COND2' => {
            		'OBJ_TYPE' => 'LINE',
            		'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    	'COND3' => {
                	'OBJ_TYPE' => 'LINE',
        	    	'CONDITION' => "ATTR_WIDTH EQ 6"
		}
		}
	},
	'Width' => 10872,
    	'Quantifier' => '*',
	'ContentDef' => {
		'Type' => 'Paragraph'
	}
},


'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'ACCT_SUMMARY',
	'StartAnchor' => {
		'Constraints' => {
		'COND1' => {
    		        'OBJ_TYPE' => 'LINE',
        	        'CONDITION' => "ATTR_XPOS EQ 1008"
		},
		'COND2' => {
    	        	'OBJ_TYPE' => 'LINE',
			'CONDITION' => "ATTR_WIDTH EQ 6"
		},
            	'COND3' => {
                	'OBJ_TYPE' => 'LINE',
            		'CONDITION' => "ATTR_LENGTH EQ 6"
                }	
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        	'OBJ_TYPE' => 'LINE',
                	'CONDITION' => "ATTR_XPOS EQ 7820"
        	},
        	'COND2' => {
            		'OBJ_TYPE' => 'LINE',
            		'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    	'COND3' => {
                	'OBJ_TYPE' => 'LINE',
        	    	'CONDITION' => "ATTR_WIDTH EQ 6"
		}
		}
	},
	'Width' => 6812,
	'ContentDef' => {
		'Type' => 'Paragraph'
	}

},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'MSG_MGR',
	'StartAnchor' => {
		'Constraints' => {
            'COND1' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 7920"
            },
            'COND2' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 2304"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 12"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 12"
            }
		}
	},
	'EndAnchor' => {
		'Constraints' => {
            'COND1' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11520"
            },
            'COND2' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 5472"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 12"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 12"
			}
		}
	},
	'Width' => 3600

#	'Width' => 3600,
#	'ContentDef' => {
#		'Type' => 'Paragraph',
#		'Definition' => {
#			'Group' => 'TRUE',
#			'GroupBy' => 'font',
#			'Separator' => ' '
#		}
#	},
#    'AddContent' => {
#        'AC_CLASS_EX_START' => {
#            'Include' => 'Before',
#            'Content' => '<div class="mm" msgID="12345">'
#            'Content' => '<div class="msg_mgr">'
#        },
#        'AC_CLASS_EX_END' => {
#            'Include' => 'After',
#            'Content' => '</div>'
#        }
#    }
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'IMP_MSG',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 8280"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 6264"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND4' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11664"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 10008"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND4' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 4046,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'GroupBy' => 'font',
			'Separator' => ' '
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'FILLER_SECTION',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 1008"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11808"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},	
	'Width' => 10800,
    	'Quantifier' => '*'
    	#'Quantifier' => '*',
#	'ContentDef' => {
#		'Type' => 'SKIP'
#	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'SPACE_FILLER',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 14"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 14"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND4' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11592"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 288"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND4' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},	
	'Width' => 11000
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'SHARE_SAVING',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 2160"
			},
			'COND2' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 20"
			},
        	'COND3' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11520"
        	},
        	'COND2' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 20"
	        },
        	'COND3' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 9360
},

#'BLK' . sprintf( "%03d", $iBlockId++ ) => {
#	'Id' => 'CHECKING',
#	'StartAnchor' => {
#		'Constraints' => {
#			'COND1' => {
#                'OBJ_TYPE' => 'LINE',
#                'CONDITION' => "ATTR_XPOS EQ 1008"
#			},
#			'COND2' => {
#            	'OBJ_TYPE' => 'LINE',
#            	'CONDITION' => "ATTR_LENGTH EQ 12"
#			},
#        	'COND3' => {
#                'OBJ_TYPE' => 'LINE',
#        	    'CONDITION' => "ATTR_WIDTH EQ 6"
#			}
#		}
#	},
#	'EndAnchor' => {
#		'Constraints' => {
#	        'COND1' => {
#    	        'OBJ_TYPE' => 'LINE',
#                'CONDITION' => "ATTR_XPOS EQ 11808"
#        	},
#        	'COND2' => {
#            	'OBJ_TYPE' => 'LINE',
#            	'CONDITION' => "ATTR_LENGTH EQ 12"
#	        },
#        	'COND3' => {
#                'OBJ_TYPE' => 'LINE',
#        	    'CONDITION' => "ATTR_WIDTH EQ 6"
#			}
#		}
#	},
#	'Width' => 10800
#},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'SKIP_SECTION',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 994"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 10906"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 9912,
    	'Quantifier' => '*',
	'ContentDef' => {
		'Type' => 'Skip'
	}
},


'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'TRANSACTION_BODY',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 1008"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 18"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 12"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11808"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 18"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 12"
			}
		}
	},
	'Width' => 10800,
        'Quantifier' => '*',
	'ContentDef' => {
		'Type' => 'TABLE',
		'Definition' => {
			'Header' => [ "Date", "Description", "Amount" ],
			'Columns' => {
				'C1' => 600,
				'C2' => 10512,
				'C3' => 1440
			}
		},
		'AddContent' => {
			'AC_CLASS_EX_START' => {
				'Include' => 'Before',
				'Content' => '<div class="trans_table">'
			},
			'AC_CLASS_EX_END' => {
				'Include' => 'After',
				'Content' => '</div>'
			}
		}
	}
},


'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'SAVINGS_TRANSACTION',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2304"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11520"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 11000,
	'ContentDef' => {
		'Type' => 'TABLE',
		'Definition' => {
			'Columns' => {
				'C1' => 2448,
				'C2' => 3744,
				'C3' => 8022,
				'C4' => 9160,
				'C5' => 10400
			}
		},
		'AddContent' => {
			'AC_CLASS_EX_START' => {
				'Include' => 'Before',
				'Content' => '<div class="check_table">'
			},
			'AC_CLASS_EX_END' => {
				'Include' => 'After',
				'Content' => '</div>'
			}
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'REG_DD',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2880"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 36"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 10800"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 36"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 7640
},






'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'DAILY_BAL1',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 979"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 3888"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 2910,
	'ContentDef' => {
		'Type' => 'Table',
		'Definition' => {
			'Header' => [ "Date", "Balance" ],
			'Columns' => {
				'C1' =>  979,
				'C2' => 2500
				#'C2' => 1440
			}
		}
	},
	'Next' => 'DAILY_BAL2'
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'DAILY_BAL2',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 5040"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 8208"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 3169,
	'ContentDef' => {
		'Type' => 'Table',
		'Definition' => {
			'Header' => [ "Date", "Balance" ],
			'Columns' => {
				'C1' => 5040,
				'C2' => 6480
			}
		}
	},
	'Next' => 'DAILY_BAL3'
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'DAILY_BAL3',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 8784"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11707"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 2924,
	'ContentDef' => {
		'Type' => 'Table',
		'Definition' => {
			'Header' => [ "Date", "Balance" ],
			'Columns' => {
				'C1' => 8784,
				'C2' => 10224
			}
		}
	}
},


'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'CHEQUE1',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 979"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 18"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 5616"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 18"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 4637,
	'ContentDef' => {
		'Type' => 'Table',
		'Definition' => {
			'Header' => [ "Date", "Check No", "Amount" ],
			'Columns' => {
				'C1' =>  720,
				'C2' => 1800,
				'C3' => 4320
			}
		}
	},
        'ContentProcessor' => {
                'FNR_CHEQUENR' => {
                        'Column' => 'C2',
                        'Constraints' => {
                                'COND1' => {
                                        'OBJ_TYPE' => 'TEXT',
                                        'CONDITION' => 'ATTR_TEXT EQ qr/(\d{4,})/'
                                }
                        },
                        'Replace' => '<a href="#CHQ-FIND_RESULT">FIND_RESULT</a>'
                }
        },
	'Next' => 'CHEQUE2'
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'CHEQUE2',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 7056"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 18"
                        },
                        'COND3' => {
                                'OBJ_TYPE' => 'LINE',
                                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11808"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 18"
                        },
                        'COND3' => {
                                'OBJ_TYPE' => 'LINE',
                                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => "4752",
	'ContentDef' => {
		'Type' => 'Table',
		'Definition' => {
			'Columns' => {
				'C1' => 6840,
				'C2' => 8280,
				'C3' => 10800
			}
		}
	},
        'ContentProcessor' => {
                'FNR_CHEQUENR' => {
                        'Column' => 'C2',
                        'Constraints' => {
                                'COND1' => {
                                        'OBJ_TYPE' => 'TEXT',
                                        'CONDITION' => 'ATTR_TEXT EQ qr/(\d{4,})/'
                                }
                        },
                        'Replace' => '<a href="#CHQ-FIND_RESULT">FIND_RESULT</a>'
                }
	}
},


#---- Cheque image (left) blocks ----#
'BLK' . sprintf( "%03d", $iBlockId++ ) => {
#'BLK010' => {
        'Id' => 'CHQ-CHQNRCOL1',
        'Quantifier' => '*',
        'StartAnchor' => {
            'Constraints' => {
                'COND1' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_XPOS EQ 1109"
                },
                'COND2' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_WIDTH EQ 24"
                },
                'COND3' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_LENGTH EQ 1716"
                }
            }
        },
        'EndAnchor' => {
            'Constraints' => {
                'COND1' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_XPOS EQ 5760"
                },
                'COND2' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_LENGTH EQ 6"
                }
            }
        },
        'Width' => "4690",
        'ContentDef' => {
                'Type' => 'Paragraph'
        },
        'ContentProcessor' => {
                'IDX_CHQNR' => {
                    # Text@(2833, 4429) Rot=0 Length=4 Text=>3328< OR Text@(2808, 8074) Rot=0 Length=4 Text=>3335<
                        'Constraints' => {
                                'COND1' => {
                                        'OBJ_TYPE'  => 'TEXT',
                                        'CONDITION' => "ATTR_XPOS GE 1296"
                                },
                                'COND2' => {
                                        'OBJ_TYPE'  => 'TEXT',
                                        'CONDITION' => "ATTR_XPOS LE 5760"
                                }
                        },
                        'Value' => 'qr/^(\d+)$/'
                },
                'IDX_COL1' => {
                    # Text@(8622, 4468) Rot=0 Length=4 Text=>3333< OR Text@(8568, 8074) Rot=0 Length=4 Text=>3336<
                        'Constraints' => {
                                'COND1' => {
                                        'OBJ_TYPE'  => 'TEXT',
                                        'CONDITION' => "ATTR_XPOS GE 1296"
                                },
                                'COND2' => {
                                        'OBJ_TYPE'  => 'TEXT',
                                        'CONDITION' => "ATTR_XPOS LE 5760"
                                }
                        },
                        'Value' => ''
                }
        }
},


#---- Cheque image (right) blocks ----#
'BLK' . sprintf( "%03d", $iBlockId++ ) => {
#'BLK011' => {
        'Id' => 'CHQ-CHQNRCOL2',
        'Quantifier' => '*',
        'StartAnchor' => {
            'Constraints' => {
                'COND1' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_XPOS EQ 5801"
                },
                'COND2' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_WIDTH EQ 24"
                },
                'COND3' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_LENGTH EQ 1716"
                }
            }
        },
        'EndAnchor' => {
            'Constraints' => {
                'COND1' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_XPOS EQ 11124"
                },
                'COND2' => {
                    'OBJ_TYPE' => 'LINE',
                    'CONDITION' => "ATTR_LENGTH EQ 6"
                }
            }
        },
        'Width' => "4690",
        'ContentDef' => {
                'Type' => 'Paragraph'
        },
        'ContentProcessor' => {
                'IDX_CHQNR' => {
                    # Text@(8622, 4468) Rot=0 Length=4 Text=>3333< OR Text@(8568, 8074) Rot=0 Length=4 Text=>3336<
                        'Constraints' => {
                                'COND1' => {
                                        'OBJ_TYPE'  => 'TEXT',
                                        'CONDITION' => "ATTR_XPOS GE 6516"
                                },
                                'COND2' => {
                                        'OBJ_TYPE'  => 'TEXT',
                                        'CONDITION' => "ATTR_XPOS LE 11124"
                                }
                        },
                        'Value' => 'qr/^(\d+)$/'
                },
                'IDX_COL2' => {
                    # Text@(8622, 4468) Rot=0 Length=4 Text=>3333< OR Text@(8568, 8074) Rot=0 Length=4 Text=>3336<
                        'Constraints' => {
                                'COND1' => {
                                        'OBJ_TYPE'  => 'TEXT',
                                        'CONDITION' => "ATTR_XPOS GE 6516"
                                },
                                'COND2' => {
                                        'OBJ_TYPE'  => 'TEXT',
                                        'CONDITION' => "ATTR_XPOS LE 11124"
                                }
                        },
                        'Value' => ''
                }
        }
#}
},




#'BLK' . sprintf( "%03d", $iBlockId++ ) => {
#	'Id' => 'LOANS',
#	'StartAnchor' => {
#		'Constraints' => {
#			'COND1' => {
#                'OBJ_TYPE' => 'LINE',
#                'CONDITION' => "ATTR_XPOS EQ 2304"
#			},
#			'COND2' => {
#            	'OBJ_TYPE' => 'LINE',
#            	'CONDITION' => "ATTR_LENGTH EQ 20"
#			},
#        	'COND3' => {
#                'OBJ_TYPE' => 'LINE',
#        	    'CONDITION' => "ATTR_WIDTH EQ 6"
#			}
#		}
#	},
#	'EndAnchor' => {
#		'Constraints' => {
#	        'COND1' => {
#    	        'OBJ_TYPE' => 'LINE',
#                'CONDITION' => "ATTR_XPOS EQ 11520"
#        	},
#        	'COND2' => {
#            	'OBJ_TYPE' => 'LINE',
#            	'CONDITION' => "ATTR_LENGTH EQ 20"
#	        },
#        	'COND3' => {
#                'OBJ_TYPE' => 'LINE',
#        	    'CONDITION' => "ATTR_WIDTH EQ 6"
#			}
#		}
#	},
#	'Width' => 9360
#},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'YTD_SUMMARY',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2376"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11520"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 8640,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'Separator' => ' '
		}
	}
}
);

###########################################################################################################

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__

