#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#  customers::epcums1:
#  PERL module to define the content blocks of page/document
#
#  Author  : AFP2web Team
#
#  Date:   2015-01-20    Initial Release
#
#-------------------------------------------------------------------------------
package customers::epcums1;

my $iBlockId = 1;

%Blocks = (
#---- Document Start CSS Injection ----#
'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'A2W_DMF_PAGE_HEADER',
	'ContentDef' => {
		'Type' => 'Paragraph',
		'AddContent' => {
			'A2W_DMF_DOC_HEAD' => {
				'Include' => 'Before',
				'Content' => '<link rel="stylesheet" type="text/css" href="epcu/css/monthlystatement.html.css" /> 
<script src="/javascripts/application.js?1362423724" type="text/javascript"></script>'
			}
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'PG1_HDR_SKIP',
	'StartAnchor' => {
		'Constraints' => {
	        'COND1' => {
                'OBJ_TYPE'  => 'LINE',
                'CONDITION' => "ATTR_XPOS GE 8194"
            },
            'COND2' => {
                'OBJ_TYPE'  => 'LINE',
                'CONDITION' => "ATTR_YPOS GE 2390"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    		    'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11808"
            },
	        'COND2' => {
    		    'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 2736"
            },
            'COND3' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 3614,
	'ContentDef' => {
		'Type' => 'Skip'
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'PG1_HDR',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_XPOS GE 8194"
			},
			'COND2' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_YPOS GE 1930"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11808"
        	},
            'COND2' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 2376"
            },
        	'COND3' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    'COND4' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 3614,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'Separator' => ' '
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'SUB_PAGE_HDR_SKIP',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 4968"
			},
			'COND2' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 432"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 7920"
			},
			'COND2' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 1440"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
    'Quantifier' => '*',
	'Width' => 2880,
	'ContentDef' => {
		'Type' => 'Skip'
    },
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'ADDRESS',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2275"
			},
			'COND2' => {
				'OBJ_TYPE'  => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 2894"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
            }
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 7013"
            },
            'COND2' => {
                'OBJ_TYPE'  => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 3498"
            },
            'COND3' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 3600,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'Separator' => ' '
		}
	}

},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'ACCT_SUMMARY',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 2160"
			},
			'COND2' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 7128"
			},
			'COND3' => {
    	        'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			},
            'COND4' => {
                    'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 6"
            }
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 6336"
        	},
	        'COND2' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 8568"
        	},
        	'COND3' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 6"
	        },
    	    'COND4' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 3600,
	'ContentDef' => {
		'Type' => 'Paragraph'
	}

},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'MSG_MGR',
	'StartAnchor' => {
		'Constraints' => {
            'COND1' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 7157"
            },
            'COND2' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 7056"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
            }
		}
	},
	'EndAnchor' => {
		'Constraints' => {
            'COND1' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11232"
            },
            'COND2' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_YPOS EQ 8640"
            },
            'COND3' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_LENGTH EQ 6"
            },
            'COND4' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 4147,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'GroupBy' => 'font',
			'Separator' => ' '
		}
	},
    'AddContent' => {
        'AC_CLASS_EX_START' => {
            'Include' => 'Before',
            'Content' => '<div class="msg_mgr">'
        },
        'AC_CLASS_EX_END' => {
            'Include' => 'After',
            'Content' => '</div>'
        }
    }
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'IMP_MSG',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 7157"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 3456"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND4' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11520"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_YPOS EQ 5688"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 6"
			},
			'COND4' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 4046,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'GroupBy' => 'font',
			'Separator' => ' '
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'FILLER_SECTION',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2304"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 12"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11520"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 12"
			}
		}
	},	
	'Width' => 11000,
    'Quantifier' => '*',
	'ContentDef' => {
		'Type' => 'SKIP'
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'SHARE_SAVING',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 2160"
			},
			'COND2' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 20"
			},
        	'COND3' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11520"
        	},
        	'COND2' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 20"
	        },
        	'COND3' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 9360
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'CHECKING',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 2160"
			},
			'COND2' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 22"
			},
        	'COND3' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11520"
        	},
        	'COND2' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 22"
	        },
        	'COND3' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 9360
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'SAVINGS_HDR_SKIP',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2160"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 18"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11520"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 18"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 9360,
    'Quantifier' => '*',
	'ContentDef' => {
		'Type' => 'Skip'
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'SAVINGS_TRANSACTION',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2304"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11520"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 11000,
	'ContentDef' => {
		'Type' => 'TABLE',
		'Definition' => {
			'Columns' => {
				'C1' => 2448,
				'C2' => 3744,
				'C3' => 8022,
				'C4' => 9160,
				'C5' => 10400
			}
		},
		'AddContent' => {
			'AC_CLASS_EX_START' => {
				'Include' => 'Before',
				'Content' => '<div class="check_table">'
			},
			'AC_CLASS_EX_END' => {
				'Include' => 'After',
				'Content' => '</div>'
			}
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'REG_DD',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2880"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 36"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 10800"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 36"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 7640
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'CHEQUE1',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2160"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 24"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 6192"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 24"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 3780,
	'ContentDef' => {
		'Type' => 'Table',
		'Definition' => {
			'Header' => [ "Date", "Check#", "Amount" ],
			'Columns' => {
				'C1' => 2650,
				'C2' => 4000,
				'C3' => 5300
			}
		}
	},
	'Next' => 'CHEQUE2'
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'CHEQUE2',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 6912"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 30"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
		
		'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS GE 11520"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 30"
			}
		}
	},
	'Width' => "3780",
	'ContentDef' => {
		'Type' => 'Table',
		'Definition' => {
			'Columns' => {
				'C1' => 7120,
				'C2' => 8480,
				'C3' => 9690
			}
		}
	}
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'LOANS',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
                'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 2304"
			},
			'COND2' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 20"
			},
        	'COND3' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
	        'COND1' => {
    	        'OBJ_TYPE' => 'LINE',
                'CONDITION' => "ATTR_XPOS EQ 11520"
        	},
        	'COND2' => {
            	'OBJ_TYPE' => 'LINE',
            	'CONDITION' => "ATTR_LENGTH EQ 20"
	        },
        	'COND3' => {
                'OBJ_TYPE' => 'LINE',
        	    'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 9360
},

'BLK' . sprintf( "%03d", $iBlockId++ ) => {
	'Id' => 'YTD_SUMMARY',
	'StartAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 2376"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			}
		}
	},
	'EndAnchor' => {
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_XPOS EQ 11520"
			},
			'COND2' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_LENGTH EQ 12"
			},
			'COND3' => {
				'OBJ_TYPE' => 'LINE',
				'CONDITION' => "ATTR_WIDTH EQ 6"
			}
		}
	},
	'Width' => 8640,
	'ContentDef' => {
		'Type' => 'Paragraph',
		'Definition' => {
			'Group' => 'TRUE',
			'Separator' => ' '
		}
	}
}
);

###########################################################################################################

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__

