#-------------------------------------------------------------------------------
#  dumpIniParms.pm:
#  Scripting Facility to dump Ini Parameters
#
#  Call:
#
#  On Windows:    afp2web.exe -q -c -doc_cold -sp:sfsamples\dumpIniParms.pm samples\medform.afp
#
#  On Unix:    ./afp2web   -q -c -doc_cold -sp:sfsamples/dumpIniParms.pm samples/medform.afp
#
#  Author  : Fa. OXSEED
#  Date    : 2010-01-04
#  Version : 1.0.7
#
#  $V100   2005-08-01  Initial Release
#  $V101   2006-10-05  Extended with following new INI attributes
#                      - PageOutput
#                      - ScriptUnitBase
#                      - MemoryOutputStream
#                      Removed following old INI attributes
#                      - PageOut
#                      - BatchSize
#                      Modified following INI attributes
#                      - "OCDataPath" as "TempPath"
#  $V102   2008-07-10  Extended to add script file path as module search path
#                      on "BEGIN" block
#  $V103   2008-11-27  Added "ResourceGroup" attribute
#  $V104   2009-02-09  Added "ImageResizeFilter" attribute
#  $V105   2009-03-16  Added "ImageRotationFilter" attribute
#  $V106   2009-07-27  Added following new INI attributes
#                      - Colorspace
#                      - CodedOutput
#                      - Flush
#  $V107   2010-01-04  a. Extended to utilize
#                         "a2w::ConfigConstants"
#                         "a2w::DocumentConstants"
#                         "a2w::PageConstants"
#                         "a2w::FontConstants"
#                         packages
#                      b. Optimized constant declarations
#                      c. Modified PERL "@INC" extending to consider the
#                         Scripting Facility samples grouping under "sfsamples"
#                         directory
#-------------------------------------------------------------------------------

# $V102 Begin
#-----------------------------------------------------------------------
# BEGIN block of module
#
# Extends PERL module search path array (@INC) with new element having
# this script modules path in order to have better module portability
#-----------------------------------------------------------------------
BEGIN {
    #---- Fetch script filename
    my $sScriptFilenameTmp = $0;

    #---- Extract script file path from script filename
    my $sScriptFilePathTmp = "";
    if ( $sScriptFilenameTmp =~ /(.*)\/.*\.pm/ ){
        $sScriptFilePathTmp = $1;
    }

    #printf STDERR ( "Script filename: " . $0 . " Script filepath: " . $sScriptFilePathTmp . "\n" );
    # $V107 Begin
    if ( $sScriptFilePathTmp eq "" ){
        $sScriptFilePathTmp = ".";
    }
    else {
        my $sScriptFileParentPathTmp = "";
        if ( $sScriptFilePathTmp =~ /(.*)\/sfsamples/ ){
            $sScriptFileParentPathTmp = $1;
        }

        #---- Add script file parent path to module search path
        if ( $sScriptFileParentPathTmp ne "" ){
            unshift( @INC, $sScriptFileParentPathTmp );
        }
    }
    # $V107 End

    #---- Add script file path to module search path
    unshift( @INC, $sScriptFilePathTmp );
}
# $V102 End

use a2w::Config;
use a2w::Document;
use a2w::Font;
use a2w::Index;
use a2w::Kernel;
use a2w::Line;
use a2w::MediumMap;
use a2w::NOP;
use a2w::Overlay;
use a2w::Page;
use a2w::PSEG;
use a2w::Text;

# $V107 Begin
use a2w::ConfigConstants;
use a2w::DocumentConstants;
use a2w::PageConstants;
use a2w::FontConstants;
# $V107 End

#-----------------------------------------------------------------------
# Initialize once per process
#-----------------------------------------------------------------------
sub initialize(){

    #---- Get Parameter of initialize( Par: a2w::Config, a2w::Kernel )
    ( $a2wConfigPar, $a2wKernelPar ) = @_;

    #---- Define boolean values
    $TRUE  = 1;    # TRUE  boolean value
    $FALSE = 0;    # FALSE boolean value

    #---- Set/Reset Logging
    $bLog = $FALSE;
    if (index( lc($a2wConfigPar->getAttribute( $a2w::ConfigConstants::LOGGINGLEVEL )), "sf") >= 0 ){    # $V107 Change
        $bLog = $TRUE;
    }

    my $sScriptProcTmp = $a2wConfigPar->getAttribute( $a2w::ConfigConstants::SCRIPTPROCEDURE );    # $V107 Change
    my $sScriptArgsTmp = $a2wConfigPar->getAttribute( $a2w::ConfigConstants::SCRIPTARGUMENT );
    $sIndexFilePath    = $a2wConfigPar->getAttribute( $a2w::ConfigConstants::INDEXPATH );
    $sOutputFilePath   = $a2wConfigPar->getAttribute( $a2w::ConfigConstants::OUTPUTFILEPATH );
    $sSpoolFilename    = $a2wKernelPar->getSpoolFilename();

    if ( $bLog == $TRUE ){
        printf STDERR ( "initialize(): Processing $sSpoolFilename\n" );
        printf STDERR ( "initialize(): Args: $sScriptArgsTmp, IndexFilePath: $sIndexFilePath, OutputFilePath: $sOutputFilePath\n" );
    }

    # $V107 Begin
    #---- Page process flags
    $APPEND = 0;    # append page to Current Document
    $SKIP   = 1;    # skip page
    $NEWDOC = 2;    # new document
    # $V107 End

    #---- Open Dump file
    my ($sSpoolFilenamePathTmp, $sDumpFilenameTmp) = ($sSpoolFilename =~ /^((?:.*[:\\\/])?)(.*)/s);
    $sDumpFilenameTmp = $sOutputFilePath . $sDumpFilenameTmp . ".txt";
    open( fDumpFile, ">$sDumpFilenameTmp" );
    printf STDERR ( "Running $sScriptProcTmp: Dumping to $sDumpFilenameTmp...\n" );

    # $V107 Begin
    #---- Get list of constants defined in "ConfigConstants.pm"
    my @arrConstantListTmp = sort keys( %a2w::ConfigConstants:: );

    #---- Loop through Constant List
    my @arrConfigParmNameListTmp = ();
    for( my $i = 0; $i < @arrConstantListTmp; $i++ ){
        #---- Skip empty parameters
        if ( ${ %a2w::ConfigConstants::->{ @arrConstantListTmp[ $i ] } } eq "" ){
            next;
        }

        #---- Fetch value of constant        
        @arrConfigParmNameListTmp[ @arrConfigParmNameListTmp + 0 ] = ${ %a2w::ConfigConstants::->{ @arrConstantListTmp[ $i ] } };
    }
    
    my $iConfigParmCountTmp = @arrConfigParmNameListTmp;

    print fDumpFile ("================================= Ini Parameter List =================================\n");
    for ( my $j = 0; $j < $iConfigParmCountTmp; $j++ ){
        print fDumpFile ( @arrConfigParmNameListTmp[ $j ]
                          . "=>"
                          . $a2wConfigPar->getAttribute( @arrConfigParmNameListTmp[ $j ] )
                          . "<=\n"
                        );
    }
    print fDumpFile ("======================================================================================\n");
    close( fDumpFile );
    # $V107 End
    return 0;
}

#-----------------------------------------------------------------------
# InitializeDoc for each document
#-----------------------------------------------------------------------
sub initializeDoc(){

    #---- Get Parameter of initializeDoc( Par: a2w::Document )
    ($a2wDocumentPar) = @_;

    if ( $bLog == $TRUE ){
        printf STDERR ( "initializeDoc(): DocId " . $a2wDocumentPar->getId() . "\n" );
    }
    return 0;
}

#-----------------------------------------------------------------------
# InitializePage for each page
#-----------------------------------------------------------------------
sub initializePage(){

    #---- Get Parameter of initializePage( Par: a2w::Page )
    ($a2wPagePar) = @_;

    if ( $bLog == $TRUE ){
        printf STDERR ( "initializePage()\n" );
    }
    return 0;
}

#-----------------------------------------------------------------------
# Main entry method
# Return values:
#        < 0:    error
#         0:    append page to Current Document
#         1:    skip page
#         2:    first page / new document
#-----------------------------------------------------------------------
sub afp2web(){

    if ( $bLog == $TRUE ){
        printf STDERR ( "afp2web(): PageId " . $a2wPagePar->getParseId() . "\n" );
    }

    #---- Set default return value
    my $iRetTmp = $SKIP; # skip page

    return $iRetTmp;
}

#-----------------------------------------------------------------------
# FinalizePage for each page
#-----------------------------------------------------------------------
sub finalizePage(){

    if ( $bLog == $TRUE ){
        printf STDERR ( "finalizePage()\n" );
    }
    return 0;
}

#-----------------------------------------------------------------------
# FinalizeDoc for each document
#-----------------------------------------------------------------------
sub finalizeDoc(){

    if ( $bLog == $TRUE ){
        printf STDERR ( "finalizeDoc()\n" );
    }
    return 0;
}

#-----------------------------------------------------------------------
# Finalize once per process
#-----------------------------------------------------------------------
sub finalize(){

    if ( $bLog == $TRUE ){
        printf STDERR ( "finalize()\n" );
    }
    return 0;
}
__END__
