/*
 * Decompiled with CFR 0.152.
 */
package de.maas.jbi.helper.marshallers;

import de.maas.jbi.helper.marshallers.FileParserResult;
import de.maas.saas.data.Order;
import de.maas.saas.indexmapping.IndexInfoContainer;
import de.maas.saas.indexmapping.IndexInfoFactory;
import de.maas.saas.logger.Log;
import java.io.File;
import java.io.IOException;
import org.apache.commons.vfs.FileSystemManager;

public abstract class FileParser {
    private static final String MANDANT_TOKEN = "$mandant";
    private String documentScenario = null;
    private String processScenario = null;
    private String orderScenario = null;
    private String defaultInputType = null;
    private String defaultFolder = null;
    private String processType = null;
    private String workingDirectory = null;
    private FileSystemManager fsManager = null;
    private Log logger = null;
    protected final IndexInfoContainer indexContainer = IndexInfoFactory.getIndexInfoContainer();

    protected FileParser() {
    }

    protected FileParser(String documentScenario, String processScenario, String orderScenario, String defaultInputType, String defaultFolder) {
        this.documentScenario = documentScenario;
        this.processScenario = processScenario;
        this.orderScenario = orderScenario;
        this.defaultInputType = defaultInputType;
        this.defaultFolder = defaultFolder;
    }

    public final void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public final String getWorkingDirectory(String mandant, String orderId) throws IOException {
        String workingDir;
        File f;
        StringBuffer result = new StringBuffer().append(this.workingDirectory);
        if (!this.workingDirectory.endsWith(File.separator)) {
            result.append(File.separatorChar);
        }
        if (mandant != null && mandant.length() > 0) {
            result.append(mandant);
            result.append(File.separatorChar);
        }
        if (orderId != null && orderId.length() > 0) {
            result.append(orderId);
            result.append(File.separatorChar);
        }
        if (!(f = new File(workingDir = result.toString())).exists()) {
            f.mkdirs();
        }
        return f.getCanonicalPath();
    }

    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setFsManager(FileSystemManager fsManager) {
        this.fsManager = fsManager;
    }

    public final FileSystemManager getFsManager() {
        return this.fsManager;
    }

    public IndexInfoContainer getIndexInfoContainer() {
        return this.indexContainer;
    }

    public final void setLog(Log logger) {
        this.logger = logger;
    }

    public final Log getLog() {
        return this.logger;
    }

    public String getDefaultFolder() {
        return this.defaultFolder;
    }

    public void setDefaultFolder(String defaultFolder) {
        this.defaultFolder = defaultFolder;
    }

    public String getDefaultInputType() {
        return this.defaultInputType;
    }

    public void setDefaultInputType(String defaultInputType) {
        this.defaultInputType = defaultInputType;
    }

    public String getDocumentScenario() {
        return this.documentScenario;
    }

    public void setDocumentScenario(String documentScenario) {
        this.documentScenario = documentScenario;
    }

    public String getOrderScenario() {
        return this.orderScenario;
    }

    public void setOrderScenario(String orderScenario) {
        this.orderScenario = orderScenario;
    }

    public String getProcessScenario() {
        return this.processScenario;
    }

    public void setProcessScenario(String processScenario) {
        this.processScenario = processScenario;
    }

    public String getProcessType() {
        return this.processType;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    protected String setMandantInPath(String path, String mandant) {
        return path.replace(MANDANT_TOKEN, mandant);
    }

    public abstract FileParserResult parseFile(File var1, Order var2);
}

