/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.config;

import de.maas.saas.config.OxseedVerifierFieldConfig;
import de.maas.saas.config.ReplacementConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.VFS;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OxseedVerifierFOPConfig
implements InitializingBean {
    private List<OxseedVerifierFieldConfig> verifierFieldList = null;
    private List<ReplacementConfig> replacementConfigList = null;
    private String xsltPath = null;

    public void afterPropertiesSet() throws Exception {
        if (this.verifierFieldList == null) {
            this.verifierFieldList = Collections.EMPTY_LIST;
        }
        if (this.replacementConfigList == null) {
            this.replacementConfigList = Collections.EMPTY_LIST;
        }
    }

    public List<OxseedVerifierFieldConfig> getVerifierFieldList() {
        return this.verifierFieldList;
    }

    public void setVerifierFieldList(List<OxseedVerifierFieldConfig> verifierFieldList) {
        this.verifierFieldList = verifierFieldList;
    }

    public void setXsltPath(String xsltPath) {
        this.xsltPath = xsltPath;
    }

    public synchronized InputStream getXsltStream() throws IOException {
        try {
            FileObject fo = VFS.getManager().resolveFile(this.xsltPath);
            fo.refresh();
            return fo.getContent().getInputStream();
        }
        catch (Exception e) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            InputStream rsrc = null;
            if (contextClassLoader != null) {
                rsrc = contextClassLoader.getResourceAsStream(this.xsltPath);
            }
            if (rsrc == null) {
                throw new IOException("Resources for path '" + this.xsltPath + "' cannot be found");
            }
            return rsrc;
        }
    }

    public List<ReplacementConfig> getReplacementConfigList() {
        return this.replacementConfigList;
    }

    public void setReplacementConfigList(List<ReplacementConfig> replacementConfigList) {
        this.replacementConfigList = replacementConfigList;
    }
}

