/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.saver;

import de.maas.saas.config.OrderSaverConfig;
import de.maas.saas.data.Order;
import de.maas.saas.db.DBException;
import de.maas.saas.db.SessionFactory;
import de.maas.saas.saver.DBOrderSaver;
import de.maas.saas.saver.EmailOrderSaver;
import de.maas.saas.saver.OrderSaverException;
import de.maas.saas.saver.OrderSaverInterface;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchangeFactory;

public class EmailDBOrderSaver
implements OrderSaverInterface {
    private EmailOrderSaver emailSaver;
    private DBOrderSaver dbOrderSaver;

    public EmailDBOrderSaver(SessionFactory sf) throws DBException {
        this.dbOrderSaver = new DBOrderSaver(sf);
        this.emailSaver = new EmailOrderSaver();
    }

    public void saveOrder(String mandant, String orderId, String state, Order orderData, DeliveryChannel dc, MessageExchangeFactory mef) throws OrderSaverException {
        this.dbOrderSaver.saveOrder(mandant, orderId, state, orderData, dc, mef);
        this.emailSaver.saveOrder(mandant, orderId, state, orderData, dc, mef);
    }

    public void setConfig(OrderSaverConfig config) {
        this.emailSaver.setConfig(config);
        this.dbOrderSaver.setConfig(config);
    }
}

