/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.scenario;

import de.maas.saas.data.Action;
import de.maas.saas.exceptions.XMLParseException;
import de.maas.saas.scenario.Scenario;
import de.maas.saas.utils.ActionStatus;
import de.maas.saas.xml.parsers.ActionListParseable;
import de.maas.saas.xml.parsers.ScenarioParseable;
import de.maas.saas.xml.parsers.impl.XMLParseableFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ScenarioList {
    private static final String SCENARIO_CONFIG_NAME = "scenario-list.xml";
    private static ScenarioList scenListInstance = null;
    private Map<String, Scenario> scenarioMap = null;

    public static ScenarioList getInstance() throws XMLParseException {
        return scenListInstance != null ? scenListInstance : (scenListInstance = new ScenarioList());
    }

    private ScenarioList() throws XMLParseException {
        try {
            this.loadScenario();
        }
        catch (IOException e) {
            throw new XMLParseException(e.getMessage(), e);
        }
    }

    public Scenario getScenario(String nameOfScenario) {
        return this.scenarioMap.get(nameOfScenario);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScenario() throws IOException, XMLParseException {
        this.scenarioMap = new Hashtable<String, Scenario>(5);
        InputStream sourceXml = null;
        try {
            sourceXml = this.getClass().getClassLoader().getResourceAsStream(SCENARIO_CONFIG_NAME);
            ScenarioParseable xmlParser = XMLParseableFactory.createScenarioXMLParseable(sourceXml);
            int scenarioListSize = xmlParser.getScenarioListSize();
            for (int i = 0; i < scenarioListSize; ++i) {
                Scenario scenario = new Scenario();
                String scenarioName = xmlParser.getScenarioNameAt(i);
                scenario.setIndexPath(xmlParser.getIndexPathAt(i));
                scenario.setType(xmlParser.getTypeAt(i));
                ActionListParseable actionList = xmlParser.getActionListAt(i);
                int actionListSize = actionList.getActionListSize();
                for (int index = 0; index < actionListSize; ++index) {
                    Action action = this.createAction(actionList.getActionNameAt(index));
                    action.setPriority(Integer.parseInt(actionList.getActionPriorityAt(index)));
                    scenario.getActionList().add(action);
                }
                this.scenarioMap.put(scenarioName, scenario);
            }
        }
        finally {
            try {
                if (sourceXml != null) {
                    sourceXml.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private Action createAction(String actionName) {
        actionName = actionName.trim();
        int parentesisPosition = actionName.indexOf(40);
        Action action = new Action();
        action.setStatus(ActionStatus.Active.toString());
        action.setCreatedBy(this.getClass().getCanonicalName());
        action.setCreationDate(new Date().toString());
        if (parentesisPosition < 0) {
            action.setName(actionName);
        } else {
            action.setName(actionName.substring(0, parentesisPosition));
            StringTokenizer st = new StringTokenizer(actionName.substring(parentesisPosition + 1), ",) ");
            action.setArgumentList(new Action.ArgumentList());
            List argList = action.getArgumentList().getArgument();
            while (st.hasMoreTokens()) {
                argList.add(st.nextToken());
            }
        }
        return action;
    }
}

