/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.xml.parsers.impl;

import de.maas.saas.exceptions.XMLParseException;
import de.maas.saas.xml.parsers.ActionListParseable;
import de.maas.saas.xml.parsers.impl.XMLParser;
import de.maas.saas.xml.parsers.impl.XPathExpressionBuilder;
import org.w3c.dom.Node;

class ActionListParseableImpl
extends XMLParser
implements ActionListParseable {
    private static final String ELEMENT_ACTION = "action";
    private static final String ELEMENT_ACTION_NAME = "name";
    private static final String ELEMENT_ACTION_PRIORITY = "priority";
    private ActionListXPathExpressionBuilder builder = new ActionListXPathExpressionBuilder();

    public ActionListParseableImpl(Node actionListNode) {
        super(actionListNode);
    }

    public int getActionListSize() throws XMLParseException {
        return this.getIntResult(this.builder.buildActionListSizeExpression());
    }

    public String getActionNameAt(int index) throws XMLParseException {
        return this.getStringResult(this.builder.buildActionNameExpression(index));
    }

    public String getActionPriorityAt(int index) throws XMLParseException {
        return this.getStringResult(this.builder.buildActionPriorityExpression(index));
    }

    private class ActionListXPathExpressionBuilder {
        private XPathExpressionBuilder builder = new XPathExpressionBuilder();
        private String[] action = new String[]{"action"};
        private String[] name = new String[]{"name"};
        private String[] priority = new String[]{"priority"};

        private ActionListXPathExpressionBuilder() {
        }

        public String buildActionListSizeExpression() {
            return this.builder.buildCountElementExpression(true, ActionListParseableImpl.ELEMENT_ACTION);
        }

        public String buildActionNameExpression(int index) {
            return this.builder.buildPositionElementExpression(true, this.action, index, this.name);
        }

        public String buildActionPriorityExpression(int index) {
            return this.builder.buildPositionElementExpression(true, this.action, index, this.priority);
        }
    }
}

