/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.box;

import de.maas.saas.pdf.PDFAttachment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;

public class PDFAttachmentImpl
implements PDFAttachment {
    private Date creationDate;
    private String description;
    private String fileName;
    private String type;
    private byte[] document;
    private int size;
    private InputStream inputStream;

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public byte[] getDocument() {
        return this.document;
    }

    public void setDocument(byte[] document) {
        this.document = document;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public InputStream getInputStream() {
        if (this.inputStream == null) {
            return new ByteArrayInputStream(this.document);
        }
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public PDFAttachmentImpl(String desc, PDComplexFileSpecification pc) throws IOException {
        this.setDescription(desc);
        this.setFileName(pc.getFile());
        PDEmbeddedFile pef = pc.getEmbeddedFile();
        this.setSize(pef.getSize());
        this.setCreationDate(pef.getCreationDate().getTime());
        this.setDocument(pef.getByteArray());
    }

    public PDFAttachmentImpl(String description, String fileName, String type) {
        this.description = description;
        this.fileName = fileName;
        this.type = type;
    }
}

