/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.box;

import de.maas.saas.pdf.PDFDocument;
import de.maas.saas.pdf.PDFOutputIntents;
import de.maas.saas.pdf.PDFOutputIntentsException;
import de.maas.saas.pdf.PDFXMP;
import de.maas.saas.pdf.PDFXMPException;
import de.maas.saas.pdf.box.PDFDocumentImpl;
import de.maas.saas.pdf.box.PDFOutputIntentsFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.pdfparser.PDFParser;

public class PDFFactory {
    private File tempDir;

    public PDFFactory(String tempDir) {
        this.tempDir = new File(tempDir);
    }

    public static PDFFactory getInstance() {
        return new PDFFactory(System.getProperty("java.io.tmpdir"));
    }

    public static PDFFactory getInstance(String tempDir) {
        return new PDFFactory(tempDir);
    }

    public PDFDocument newPDFACompliantDocument() throws PDFXMPException, PDFOutputIntentsException, IOException {
        PDFDocumentImpl pdfDocumentImpl = new PDFDocumentImpl();
        PDFXMP pdfXMP = pdfDocumentImpl.createPDFACompliantPDFXMP();
        pdfDocumentImpl.setPDFXMP(pdfXMP);
        PDFOutputIntents outputIntents = PDFOutputIntentsFactory.getInstance().createPDACompliantIO();
        pdfDocumentImpl.setOutputIntents(outputIntents);
        return pdfDocumentImpl;
    }

    public PDFDocument loadPDFDocument(InputStream stream) throws IOException {
        PDFParser parser = new PDFParser((InputStream)new BufferedInputStream(stream), null);
        parser.setTempDirectory(this.tempDir);
        parser.parse();
        PDFDocumentImpl doc = new PDFDocumentImpl(parser.getDocument());
        return doc;
    }

    public PDFDocument newDocument() throws IOException {
        PDFDocumentImpl doc = new PDFDocumentImpl();
        return doc;
    }

    public PDFDocument getPDFDocument(COSDocument document) {
        return new PDFDocumentImpl(document);
    }
}

