/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.box;

import java.awt.Dimension;
import java.awt.Point;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDFPageImageFormat {
    public static final int ALIGMENT_CENTER = 0;
    public static final int ALIGMENT_LEFT = 1;
    public static final int ALIGMENT_RIGHT = 2;
    public static final int FIT_TO_WINDOW = 3;
    public static final int FIT_TO_IMAGE = 4;
    private static PDFPageImageFormat pageImageFormat = null;
    private int aligment = 0;
    private int fitTo = 4;
    private Dimension imageFormatSize = new Dimension();
    private Dimension imageSize = new Dimension();
    private Point oryginalStartPoint = new Point();
    private Point newStartPoint = new Point();
    private PDRectangle pageSize = null;
    private PDRectangle oryginalPageSize = PDPage.PAGE_SIZE_LETTER;
    private boolean aligmentChanged = true;
    private boolean formatSizeChanged = true;

    public static PDFPageImageFormat getDefaultFormat(PDXObjectImage imageObject) {
        if (pageImageFormat == null) {
            pageImageFormat = new PDFPageImageFormat();
        }
        pageImageFormat.setImageObject(imageObject);
        return pageImageFormat;
    }

    public static PDFPageImageFormat newPDFPageImageFormat(int x, int y, PDRectangle pageSize, PDXObjectImage imageObject) {
        return new PDFPageImageFormat(x, y, pageSize, imageObject);
    }

    public static PDFPageImageFormat newPDFPageImageFormat(int x, int y, int pageFit, PDXObjectImage imageObject) {
        return new PDFPageImageFormat(x, y, pageFit, imageObject);
    }

    private PDFPageImageFormat() {
    }

    private PDFPageImageFormat(int x, int y, int fitTo, PDXObjectImage imageObject) {
        this.oryginalStartPoint.x = x;
        this.oryginalStartPoint.y = y;
        this.fitTo = fitTo;
        this.setImageObject(imageObject);
    }

    private PDFPageImageFormat(int x, int y, PDRectangle pageSize, PDXObjectImage imageObject) {
        this.oryginalStartPoint.x = x;
        this.oryginalStartPoint.y = y;
        this.pageSize = pageSize;
        this.setImageObject(imageObject);
    }

    private void setImageObject(PDXObjectImage imageObject) {
        this.imageSize.width = imageObject.getWidth();
        this.imageSize.height = imageObject.getHeight();
        this.recalculate();
    }

    private void recalculate() {
        if (this.formatSizeChanged) {
            this.formatSizeChanged = false;
            this.aligmentChanged = false;
            this.calculateFormatSize();
            this.calculateAligment();
        }
        if (this.aligmentChanged) {
            this.aligmentChanged = false;
            this.calculateAligment();
        }
    }

    private void calculateAligment() {
        switch (this.aligment) {
            case 1: {
                this.newStartPoint = this.getLeftAligment(this.imageFormatSize, this.pageSize);
                break;
            }
            case 0: {
                this.newStartPoint = this.getCenterAligment(this.imageFormatSize, this.pageSize);
                break;
            }
            case 2: {
                this.newStartPoint = this.getRightAligment(this.imageFormatSize, this.pageSize);
            }
        }
    }

    private void calculateFormatSize() {
        switch (this.fitTo) {
            case 4: {
                this.pageSize = new PDRectangle(new Float(this.imageSize.width).floatValue(), new Float(this.imageSize.height).floatValue());
                break;
            }
            default: {
                this.pageSize = this.oryginalPageSize;
            }
        }
        float pageWidth = this.pageSize.getWidth() - (float)(2 * this.oryginalStartPoint.x);
        float pageHeight = this.pageSize.getHeight() - (float)(2 * this.oryginalStartPoint.y);
        float imageScale = (float)this.imageSize.width / (float)this.imageSize.height;
        float pageScale = pageWidth / pageHeight;
        if (imageScale < pageScale) {
            this.imageFormatSize.height = (int)pageHeight;
            this.imageFormatSize.width = (int)(pageHeight * imageScale);
        } else {
            this.imageFormatSize.width = (int)pageWidth;
            this.imageFormatSize.height = (int)(pageWidth / imageScale);
        }
    }

    public void setPageSize(PDRectangle pageSize) {
        this.oryginalPageSize = pageSize;
        this.formatSizeChanged = true;
        this.recalculate();
    }

    public PDRectangle getPageSize() {
        return this.pageSize;
    }

    public void setPageFit(int pageFit) {
        this.fitTo = pageFit;
        this.formatSizeChanged = true;
        this.recalculate();
    }

    public void setAligment(int aligment) {
        this.aligment = aligment;
        this.aligmentChanged = true;
        this.recalculate();
    }

    public void setStartPoint(int x, int y) {
        this.oryginalStartPoint.x = x;
        this.oryginalStartPoint.y = y;
        this.formatSizeChanged = true;
        this.recalculate();
    }

    public int getX() {
        return this.newStartPoint.x;
    }

    public int getY() {
        return this.newStartPoint.y;
    }

    public int getWidth() {
        return this.imageFormatSize.width;
    }

    public int getHeight() {
        return this.imageFormatSize.height;
    }

    private Point getCenterAligment(Dimension imageSize, PDRectangle size) {
        Point centerPoint = new Point();
        int x = (int)size.getWidth() - imageSize.width;
        int y = (int)size.getHeight() - imageSize.height;
        centerPoint.x = (x /= 2) > 0 ? x : 0;
        centerPoint.y = y > 0 ? (y /= 2) : 0;
        return centerPoint;
    }

    private Point getLeftAligment(Dimension imageSize, PDRectangle size) {
        Point leftPoint = new Point();
        int y = (int)size.getHeight() - imageSize.height;
        leftPoint.y = (y /= 2) > 0 ? y : 0;
        return leftPoint;
    }

    private Point getRightAligment(Dimension imageSize, PDRectangle size) {
        Point rightPoint = new Point();
        int x = (int)size.getWidth() - imageSize.width;
        int y = (int)size.getHeight() - imageSize.height;
        rightPoint.x = x > 0 ? x : 0;
        rightPoint.y = y > 0 ? (y /= 2) : 0;
        return rightPoint;
    }
}

