/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.box;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import de.maas.bilevelimaging.BilevelImageData;
import de.maas.bilevelimaging.BilevelImageDataIO;
import de.maas.saas.data.Page;
import de.maas.saas.data.Recognition;
import de.maas.saas.data.Segmentation;
import de.maas.saas.pdf.PDFContentType;
import de.maas.saas.pdf.PDFPage;
import de.maas.saas.pdf.PDFText;
import de.maas.saas.pdf.PDFThumbnail;
import de.maas.saas.pdf.PDFThumbnailException;
import de.maas.saas.pdf.text.TextExtractorFactory;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.graphics.xobject.PDCcitt;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

class PDFPageImpl
extends PDFPage {
    private boolean contentTypeFlag = false;
    private PDFContentType contentType = null;
    private boolean simplePageFlag = false;
    private boolean pdfTextFlag = false;
    private Page simplePage = null;
    private PDFText pdfText = null;

    public static PDFPage createPDFPage(int pageNumber) {
        return new PDFPageImpl(pageNumber);
    }

    public static PDFPage createPDFPage() {
        return new PDFPageImpl();
    }

    public static PDFPage createPDFPage(int pageNumber, COSDictionary dict) {
        return new PDFPageImpl(pageNumber, dict);
    }

    public static PDFPage createPDFPage(COSDictionary dict) {
        return new PDFPageImpl(dict);
    }

    protected PDFPageImpl() {
    }

    protected PDFPageImpl(COSDictionary pageDic) {
        super(pageDic);
    }

    protected PDFPageImpl(int pageNumber, COSDictionary pageDic) {
        super(pageNumber, pageDic);
    }

    protected PDFPageImpl(int pageNumber) {
        super(pageNumber);
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    private PDFThumbnail createJPGThumbnailFromPDJpeg(int maxWidth, int maxHeight, InputStream imageDataIS) throws PDFThumbnailException {
        try {
            JPEGImageDecoder jpgImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)imageDataIS);
            BufferedImage jpgBufferedImage = jpgImageDecoder.decodeAsBufferedImage();
            int orgWidth = jpgBufferedImage.getWidth();
            int orgHeight = jpgBufferedImage.getHeight();
            double scale = (double)maxWidth / (double)orgWidth;
            if ((double)orgHeight * scale > (double)maxHeight) {
                scale = (double)maxHeight / (double)orgHeight;
            }
            int newWidth = (int)Math.round(scale * (double)orgWidth);
            int newHeight = (int)Math.round(scale * (double)orgHeight);
            BufferedImage resizedJPGImage = new BufferedImage(newWidth, newHeight, 1);
            resizedJPGImage.createGraphics().drawImage(jpgBufferedImage, 0, 0, newWidth, newHeight, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JPEGImageEncoder jpgEncoder = JPEGCodec.createJPEGEncoder((OutputStream)baos);
            jpgEncoder.encode(resizedJPGImage);
            return new PDFThumbnail(newWidth, newHeight, baos.toByteArray(), PDFThumbnail.PDFThumbnailFormat.JPG);
        }
        catch (ImageFormatException e) {
            throw new PDFThumbnailException("Couldn't get image from PDF page", e);
        }
        catch (IOException e) {
            throw new PDFThumbnailException("Couldn't get image from PDF page", e);
        }
    }

    private static PDFThumbnail createJPGThumbnailFromImage(int maxWidth, int maxHeight, Image image) throws PDFThumbnailException {
        try {
            int orgWidth = image.getWidth(null);
            int orgHeight = image.getHeight(null);
            double scale = (double)maxWidth / (double)orgWidth;
            if ((double)orgHeight * scale > (double)maxHeight) {
                scale = (double)maxHeight / (double)orgHeight;
            }
            int newWidth = (int)Math.round(scale * (double)orgWidth);
            int newHeight = (int)Math.round(scale * (double)orgHeight);
            BufferedImage resizedJPGImage = new BufferedImage(newWidth, newHeight, 1);
            resizedJPGImage.createGraphics().drawImage(image, 0, 0, newWidth, newHeight, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JPEGImageEncoder jpgEncoder = JPEGCodec.createJPEGEncoder((OutputStream)baos);
            jpgEncoder.encode(resizedJPGImage);
            return new PDFThumbnail(maxWidth, maxHeight, baos.toByteArray(), PDFThumbnail.PDFThumbnailFormat.JPG);
        }
        catch (ImageFormatException e) {
            throw new PDFThumbnailException("Couldn't get image from PDF page", e);
        }
        catch (IOException e) {
            throw new PDFThumbnailException("Couldn't get image from PDF page", e);
        }
    }

    public BilevelImageData getBilevelImageData() throws IOException {
        Object obj;
        PDResources resources = this.getResources();
        Map images = resources.getImages();
        PDXObjectImage objectImage = null;
        Iterator i$ = images.keySet().iterator();
        while (i$.hasNext() && !((objectImage = (PDXObjectImage)images.get(obj = i$.next())) instanceof PDCcitt)) {
        }
        if (objectImage == null) {
            return null;
        }
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        BilevelImageData tmpbid = null;
        try {
            baos = new ByteArrayOutputStream();
            objectImage.write2OutputStream((OutputStream)baos);
            is = new ByteArrayInputStream(baos.toByteArray());
            tmpbid = BilevelImageDataIO.loadFromTiff((InputStream)is);
            COSStream options = objectImage.getCOSStream();
            COSDictionary decodeParms = (COSDictionary)options.getDictionaryObject("DecodeParms");
            float xres = decodeParms.getFloat("XRes", 300.0f);
            float yres = decodeParms.getFloat("YRes", 300.0f);
            BilevelImageData bilevelImageData = new BilevelImageData(tmpbid.getImageData(), tmpbid.getWidth(), tmpbid.getHeight(), xres, yres);
            return bilevelImageData;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (baos != null) {
                    baos.close();
                }
                tmpbid = null;
                System.gc();
            }
            catch (IOException e) {}
        }
    }

    public Page getSimplePage() throws IOException {
        if (!this.simplePageFlag) {
            PDFText pdfText = this.getPDFText();
            this.simplePage = new Page();
            Recognition recognition = new Recognition();
            boolean rsv = this.getContentType().equals((Object)PDFContentType.TiffTextMixed) || this.getContentType().equals((Object)PDFContentType.TextPdf);
            recognition.setRecognized(rsv);
            recognition.setSegmented(rsv);
            recognition.setVerified(rsv);
            this.simplePage.setRecognition(recognition);
            this.simplePage.setPageID(this.pageNumber);
            if (pdfText != null) {
                Segmentation simpleSegmentation = pdfText.getSimpleSegmentation();
                recognition.setSegmentation(simpleSegmentation);
            }
            this.simplePageFlag = true;
        }
        return this.simplePage;
    }

    public PDFText getPDFText() throws IOException {
        if (!this.getContentType().equals((Object)PDFContentType.TiffImage)) {
            if (!this.pdfTextFlag) {
                this.pdfText = TextExtractorFactory.getSingletonInstance().getPDFText(this);
                this.pdfTextFlag = true;
            }
            return this.pdfText;
        }
        return null;
    }

    public PDFContentType getContentType() throws IOException {
        this.checkContentType();
        return this.contentType;
    }

    private void checkContentType() throws IOException {
        if (!this.contentTypeFlag) {
            COSStream stream;
            List tokens;
            boolean tiffImage = false;
            PDResources resources = this.getResources();
            Map images = resources.getImages();
            PDXObjectImage objectImage = null;
            for (Object obj : images.keySet()) {
                objectImage = (PDXObjectImage)images.get(obj);
                if (!(objectImage instanceof PDCcitt)) continue;
                if (tiffImage) {
                    tiffImage = false;
                    break;
                }
                tiffImage = true;
            }
            if (tiffImage) {
                this.contentType = PDFContentType.TiffImage;
            }
            if ((tokens = (stream = this.getContents().getStream()).getStreamTokens()) != null && tokens.size() > 0) {
                this.contentType = tiffImage ? PDFContentType.TiffTextMixed : PDFContentType.TextPdf;
            }
            this.contentTypeFlag = true;
        }
    }
}

