/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.box;

import de.maas.saas.Tiff2PdfVersion;
import de.maas.saas.pdf.PDFThumbnail;
import de.maas.saas.pdf.PDFXMP;
import de.maas.saas.pdf.PDFXMPException;
import de.maas.saas.pdf.PDFXMPOrderData;
import de.maas.saas.pdf.box.NamespaceContextImpl;
import de.maas.saas.pdf.box.PDFDocumentImpl;
import de.maas.saas.utils.SaasUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PDFXMPImpl
implements PDFXMP {
    private Document xmpDocument;
    private static NamespaceContext XMP_NAMESPACE_CONTEXT;
    private XPath xPath;

    @Override
    public Date getModifyDate() throws PDFXMPException {
        return null;
    }

    @Override
    public void setModifyDate(Date date) throws PDFXMPException {
    }

    protected PDFXMPImpl(PDMetadata pdMeta) throws PDFXMPException {
        this(PDFXMPImpl.loadXMPXML(pdMeta));
    }

    protected PDFXMPImpl(byte[] sourceMetadata) throws PDFXMPException {
        this(PDFXMPImpl.loadXMPXML(sourceMetadata));
    }

    private PDFXMPImpl(Document xmpDocument) {
        this.xmpDocument = xmpDocument;
        this.xPath = XPathFactory.newInstance().newXPath();
        this.xPath.setNamespaceContext(XMP_NAMESPACE_CONTEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadXMPXML(byte[] sourceMetadata) throws PDFXMPException {
        ByteArrayInputStream sourceStream = null;
        try {
            sourceStream = new ByteArrayInputStream(sourceMetadata);
            Document document = PDFXMPImpl.loadXMPXML(sourceStream);
            return document;
        }
        finally {
            try {
                if (sourceStream != null) {
                    ((InputStream)sourceStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static Document loadXMPXML(InputStream xmlIS) throws PDFXMPException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(xmlIS);
            Element docElement = document.getDocumentElement();
            if (docElement.getNodeName().equals("x:xmpmeta")) {
                Node firstChild = docElement.getElementsByTagName("rdf:RDF").item(0);
                Document newDoc = documentBuilder.newDocument();
                newDoc.appendChild(newDoc.importNode(firstChild, true));
                return newDoc;
            }
            return document;
        }
        catch (DOMException e) {
            throw new PDFXMPException(e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFXMPException(e);
        }
        catch (SAXException e) {
            throw new PDFXMPException(e);
        }
        catch (IOException e) {
            throw new PDFXMPException(e);
        }
    }

    private static Document loadXMPXML(PDMetadata pdMeta) throws PDFXMPException {
        try {
            InputStream xmlIS = pdMeta.createInputStream();
            return PDFXMPImpl.loadXMPXML(xmlIS);
        }
        catch (IOException e) {
            throw new PDFXMPException(e);
        }
    }

    public static PDFXMP createBasePDFXMPCompliantWithPDFA() throws PDFXMPException {
        InputStream is = null;
        try {
            is = PDFDocumentImpl.class.getResourceAsStream("XMPDocumentBasePDFA.xml");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(is);
            PDFXMPImpl pdfXMPImpl = new PDFXMPImpl(document);
            Date currentDate = new Date();
            pdfXMPImpl.setCreateDate(currentDate);
            pdfXMPImpl.setCreatorTool("Oxseed PDF library (version:" + Tiff2PdfVersion.getVersionNumber() + " build:" + Tiff2PdfVersion.getBuildNumber() + ")");
            PDFXMPImpl pDFXMPImpl = pdfXMPImpl;
            return pDFXMPImpl;
        }
        catch (IOException e) {
            throw new PDFXMPException(e);
        }
        catch (SAXException e) {
            throw new PDFXMPException(e);
        }
        catch (ParserConfigurationException e) {
            throw new PDFXMPException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new PDFXMPException(e);
            }
        }
    }

    @Override
    public boolean hasThumbnail() throws PDFXMPException {
        try {
            Node imageWidth = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:Thumbnails/rdf:Alt/rdf:li/xapGImg:width", this.xmpDocument, XPathConstants.NODE);
            Node imageHeight = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:Thumbnails/rdf:Alt/rdf:li/xapGImg:height", this.xmpDocument, XPathConstants.NODE);
            Node format = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:Thumbnails/rdf:Alt/rdf:li/xapGImg:format", this.xmpDocument, XPathConstants.NODE);
            Node imageDataEncoded = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:Thumbnails/rdf:Alt/rdf:li/xapGImg:image", this.xmpDocument, XPathConstants.NODE);
            return imageWidth != null && imageHeight != null && format != null && imageDataEncoded != null;
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public void setThumbnail(PDFThumbnail pdfThumbnail) throws PDFXMPException {
        try {
            Node thumbnailsNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:Thumbnails", this.xmpDocument, XPathConstants.NODE);
            if (thumbnailsNode == null) {
                Element rdfDecriptionNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Description");
                this.xmpDocument.getDocumentElement().appendChild(rdfDecriptionNode);
                thumbnailsNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmp"), "xmp:Thumbnails");
                rdfDecriptionNode.appendChild(thumbnailsNode);
            }
            Element altElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Alt");
            thumbnailsNode.appendChild(altElement);
            Element liElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:li");
            liElement.setAttribute("rdf:parseType", "Resource");
            altElement.appendChild(liElement);
            Element widthElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xapGImg"), "xapGImg:width");
            widthElement.setTextContent(String.valueOf(pdfThumbnail.getWidth()));
            liElement.appendChild(widthElement);
            Element heightElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xapGImg"), "xapGImg:height");
            heightElement.setTextContent(String.valueOf(pdfThumbnail.getHeight()));
            liElement.appendChild(heightElement);
            Element formatElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xapGImg"), "xapGImg:format");
            formatElement.setTextContent(pdfThumbnail.getFormat().name());
            liElement.appendChild(formatElement);
            Element imageElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xapGImg"), "xapGImg:image");
            imageElement.setTextContent(new BASE64Encoder().encode(pdfThumbnail.getImageData()));
            liElement.appendChild(imageElement);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public PDFThumbnail getThumbnail() throws PDFXMPException {
        try {
            PDFThumbnail out = null;
            String imageDataEncoded = (String)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:Thumbnails/rdf:Alt/rdf:li/xapGImg:image/text()", this.xmpDocument, XPathConstants.STRING);
            String format = (String)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:Thumbnails/rdf:Alt/rdf:li/xapGImg:format/text()", this.xmpDocument, XPathConstants.STRING);
            if (imageDataEncoded.equals("") || format.equals("")) {
                throw new PDFXMPException("Thumbnail data not available in XMP");
            }
            int imageWidth = Integer.parseInt((String)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:Thumbnails/rdf:Alt/rdf:li/xapGImg:width/text()", this.xmpDocument, XPathConstants.STRING));
            int imageHeight = Integer.parseInt((String)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:Thumbnails/rdf:Alt/rdf:li/xapGImg:height/text()", this.xmpDocument, XPathConstants.STRING));
            if (imageDataEncoded.length() > 0) {
                byte[] imageDataDecoded = new BASE64Decoder().decodeBuffer(imageDataEncoded);
                out = new PDFThumbnail(imageWidth, imageHeight, imageDataDecoded, PDFThumbnail.PDFThumbnailFormat.valueOf(format));
            }
            return out;
        }
        catch (Exception e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public boolean hasIndexData() throws PDFXMPException {
        try {
            Node ns = (Node)this.xPath.evaluate("//rdf:RDF/rdf:Description/xmpMHT:IndexList", this.xmpDocument, XPathConstants.NODE);
            return ns != null;
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public void setIndexData(Properties indexes) {
        Element rdfElement = null;
        Element descriptionElement = null;
        Element seqElement = null;
        Element liElement = null;
        rdfElement = this.xmpDocument.getDocumentElement();
        descriptionElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Description");
        descriptionElement.setAttribute("rdf:about", "");
        rdfElement.appendChild(descriptionElement);
        Element indexList = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:IndexList");
        descriptionElement.appendChild(indexList);
        seqElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Seq");
        indexList.appendChild(seqElement);
        for (Object key : indexes.keySet()) {
            liElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:li");
            liElement.setAttribute("rdf:parseType", "Resource");
            seqElement.appendChild(liElement);
            Element name = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Name");
            name.setTextContent((String)key);
            liElement.appendChild(name);
            Element value = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Value");
            value.setTextContent(indexes.getProperty((String)key));
            liElement.appendChild(value);
        }
    }

    @Override
    public Map<String, List<String>> getIndexData() {
        HashMap<String, List<String>> returnProperties = new HashMap<String, List<String>>();
        try {
            NodeList ns = (NodeList)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmpMHT:IndexList/rdf:Seq/rdf:li", this.xmpDocument, XPathConstants.NODESET);
            for (int i = 0; i < ns.getLength(); ++i) {
                NodeList ch = ns.item(i).getChildNodes();
                String value = null;
                String name = null;
                for (int c = 0; c < ch.getLength(); ++c) {
                    Node n = ch.item(c);
                    String nodeName = n.getNodeName();
                    if (nodeName.endsWith("xmpMHT:Name")) {
                        name = n.getFirstChild().getTextContent();
                        continue;
                    }
                    if (!nodeName.endsWith("xmpMHT:Value") || n.getFirstChild() == null) continue;
                    value = n.getFirstChild().getTextContent();
                }
                if (name == null) continue;
                if (returnProperties.containsKey(name)) {
                    List valueList = (List)returnProperties.get(name);
                    valueList.add(value);
                    continue;
                }
                Vector<String> valueList = new Vector<String>();
                valueList.add(value);
                returnProperties.put(name, valueList);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return returnProperties;
    }

    protected void saveToPDDocument(PDDocument pdDocument) throws PDFXMPException {
        try {
            PDDocumentCatalog docCatalog = pdDocument.getDocumentCatalog();
            PDMetadata pdMeta = docCatalog.getMetadata();
            if (pdMeta == null) {
                pdMeta = new PDMetadata(pdDocument);
                docCatalog.setMetadata(pdMeta);
            }
            OutputStream os = pdMeta.createOutputStream();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("indent", "no");
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("media-type", "text/xml");
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(this.xmpDocument), new StreamResult(new OutputStreamWriter(os)));
        }
        catch (IOException e) {
            throw new PDFXMPException(e);
        }
        catch (TransformerException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public String getAuthor() throws PDFXMPException {
        try {
            String author = (String)this.xPath.evaluate("/rdf:RDF/rdf:Description/dc:creator/rdf:Seq/rdf:li/text()", this.xmpDocument, XPathConstants.STRING);
            return author;
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public Date getCreateDate() throws PDFXMPException {
        try {
            String creationDate = (String)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:CreateDate/text()", this.xmpDocument, XPathConstants.STRING);
            if (creationDate == null) {
                return null;
            }
            if ((creationDate = creationDate.trim()).length() > 0) {
                try {
                    return SaasUtils.convertXMLSchemaDateTimeToDate((String)creationDate);
                }
                catch (NumberFormatException e) {
                    throw new PDFXMPException("Number format exception thrown for index value: " + creationDate, e);
                }
            }
            return null;
        }
        catch (ParseException e) {
            throw new PDFXMPException(e);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public String getCreatorTool() throws PDFXMPException {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(XMP_NAMESPACE_CONTEXT);
            return (String)xpath.evaluate("/rdf:RDF/rdf:Description/xmp:CreatorTool/text()", this.xmpDocument, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public String getKeywords() throws PDFXMPException {
        try {
            String keywords = (String)this.xPath.evaluate("/rdf:RDF/rdf:Description/pdf:Keywords/text()", this.xmpDocument, XPathConstants.STRING);
            return keywords;
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public String getProducer() throws PDFXMPException {
        try {
            String producer = (String)this.xPath.evaluate("/rdf:RDF/rdf:Description/pdf:Producer/text()", this.xmpDocument, XPathConstants.STRING);
            return producer;
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public String getSubject() throws PDFXMPException {
        try {
            String subject = (String)this.xPath.evaluate("/rdf:RDF/rdf:Description/dc:subject/rdf:Bag/rdf:li/text()", this.xmpDocument, XPathConstants.STRING);
            return subject;
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public String getTitle() throws PDFXMPException {
        try {
            String title = (String)this.xPath.evaluate("/rdf:RDF/rdf:Description/dc:title/rdf:Alt/rdf:li/text()", this.xmpDocument, XPathConstants.STRING);
            return title;
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public void setAuthor(String author) throws PDFXMPException {
        try {
            Node authorNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/dc:creator/rdf:Seq/rdf:li", this.xmpDocument, XPathConstants.NODE);
            if (authorNode == null) {
                Element rdfDecriptionNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Description");
                this.xmpDocument.getDocumentElement().appendChild(rdfDecriptionNode);
                Element dcCreator = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("dc"), "dc:creator");
                rdfDecriptionNode.appendChild(dcCreator);
                Element rdfSeq = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Seq");
                dcCreator.appendChild(rdfSeq);
                authorNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:li");
                rdfSeq.appendChild(authorNode);
            }
            authorNode.setTextContent(author);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public void setCreateDate(Date date) throws PDFXMPException {
        try {
            Node createDateNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:CreateDate", this.xmpDocument, XPathConstants.NODE);
            if (createDateNode == null) {
                Element rdfDecriptionNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Description");
                this.xmpDocument.appendChild(rdfDecriptionNode);
                createDateNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmp"), "xmp:CreateDate");
                rdfDecriptionNode.appendChild(createDateNode);
            }
            createDateNode.setTextContent(SaasUtils.convertToXMPSchemaDateTime((Date)date));
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public void setCreatorTool(String creator) throws PDFXMPException {
        try {
            Node createToolNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmp:CreatorTool", this.xmpDocument, XPathConstants.NODE);
            if (createToolNode == null) {
                Element rdfDecriptionNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Description");
                this.xmpDocument.appendChild(rdfDecriptionNode);
                createToolNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmp"), "xmp:CreatorTool");
                rdfDecriptionNode.appendChild(createToolNode);
            }
            createToolNode.setTextContent(creator);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public void setKeywords(String keywords) throws PDFXMPException {
        try {
            Node keywordsNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/pdf:Keywords", this.xmpDocument, XPathConstants.NODE);
            if (keywordsNode == null) {
                Element rdfDecriptionNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Description");
                this.xmpDocument.getDocumentElement().appendChild(rdfDecriptionNode);
                keywordsNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("pdf"), "pdf:Keywords");
                rdfDecriptionNode.appendChild(keywordsNode);
            }
            keywordsNode.setTextContent(keywords);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public void setProducer(String producer) throws PDFXMPException {
        try {
            Node producerNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/pdf:Producer", this.xmpDocument, XPathConstants.NODE);
            producerNode.setTextContent(producer);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public void setSubject(String subject) throws PDFXMPException {
        try {
            Node subjectNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/dc:subject/rdf:Bag/rdf:li", this.xmpDocument, XPathConstants.NODE);
            if (subjectNode == null) {
                Element rdfDecriptionNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Description");
                this.xmpDocument.getDocumentElement().appendChild(rdfDecriptionNode);
                Element dcSubject = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("dc"), "dc:subject");
                rdfDecriptionNode.appendChild(dcSubject);
                Element rdfSeq = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Bag");
                dcSubject.appendChild(rdfSeq);
                subjectNode = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:li");
                rdfSeq.appendChild(subjectNode);
            }
            subjectNode.setTextContent(subject);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public void setTitle(String title) throws PDFXMPException {
        try {
            Node titleNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/dc:title/rdf:Alt/rdf:li", this.xmpDocument, XPathConstants.NODE);
            titleNode.setTextContent(title);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
    }

    @Override
    public PDFXMPOrderData getOrderData() throws PDFXMPException {
        PDFXMPOrderData pdfXMPOrderData = null;
        try {
            Node orderDataNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmpMHT:OrderData", this.xmpDocument, XPathConstants.NODE);
            if (orderDataNode != null) {
                pdfXMPOrderData = new PDFXMPOrderData();
                NodeList nodeList = (NodeList)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmpMHT:OrderData/rdf:Seq/rdf:li", this.xmpDocument, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    String nameNode = (String)this.xPath.evaluate("xmpMHT:Name", node, XPathConstants.STRING);
                    String valueNode = (String)this.xPath.evaluate("xmpMHT:Value", node, XPathConstants.STRING);
                    if (nameNode.equals("OrderID")) {
                        pdfXMPOrderData.setOrderID(valueNode);
                        continue;
                    }
                    if (nameNode.equals("StackID")) {
                        pdfXMPOrderData.setStackID(valueNode);
                        continue;
                    }
                    if (nameNode.equals("ProcessID")) {
                        pdfXMPOrderData.setProcessID(valueNode);
                        continue;
                    }
                    if (!nameNode.equals("DocumentID")) continue;
                    pdfXMPOrderData.setDocumentID(valueNode);
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
        return pdfXMPOrderData;
    }

    @Override
    public void setOrderData(PDFXMPOrderData pdfXMPOrderData) throws PDFXMPException {
        Element rdfElement = null;
        Element descriptionElement = null;
        Element orderDataElement = null;
        Element seqElement = null;
        Element liElement = null;
        Element nameElement = null;
        Element valueElement = null;
        try {
            rdfElement = this.xmpDocument.getDocumentElement();
            Node orderDataNode = (Node)this.xPath.evaluate("/rdf:RDF/rdf:Description/xmpMHT:OrderData", this.xmpDocument, XPathConstants.NODE);
            if (orderDataNode != null) {
                orderDataNode.getParentNode().removeChild(orderDataNode);
            }
            descriptionElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Description");
            descriptionElement.setAttribute("rdf:about", "");
            rdfElement.appendChild(descriptionElement);
            orderDataElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:OrderData");
            descriptionElement.appendChild(orderDataElement);
            seqElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:Seq");
            orderDataElement.appendChild(seqElement);
            liElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:li");
            liElement.setAttribute("rdf:parseType", "Resource");
            seqElement.appendChild(liElement);
            nameElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Name");
            nameElement.setTextContent("OrderID");
            liElement.appendChild(nameElement);
            valueElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Value");
            valueElement.setTextContent(pdfXMPOrderData.getOrderID());
            liElement.appendChild(valueElement);
            liElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:li");
            liElement.setAttribute("rdf:parseType", "Resource");
            seqElement.appendChild(liElement);
            nameElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Name");
            nameElement.setTextContent("StackID");
            liElement.appendChild(nameElement);
            valueElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Value");
            valueElement.setTextContent(pdfXMPOrderData.getStackID());
            liElement.appendChild(valueElement);
            liElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:li");
            liElement.setAttribute("rdf:parseType", "Resource");
            seqElement.appendChild(liElement);
            nameElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Name");
            nameElement.setTextContent("ProcessID");
            liElement.appendChild(nameElement);
            valueElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Value");
            valueElement.setTextContent(pdfXMPOrderData.getProcessID());
            liElement.appendChild(valueElement);
            liElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("rdf"), "rdf:li");
            liElement.setAttribute("rdf:parseType", "Resource");
            seqElement.appendChild(liElement);
            nameElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Name");
            nameElement.setTextContent("DocumentID");
            liElement.appendChild(nameElement);
            valueElement = this.xmpDocument.createElementNS(XMP_NAMESPACE_CONTEXT.getNamespaceURI("xmpMHT"), "xmpMHT:Value");
            valueElement.setTextContent(pdfXMPOrderData.getDocumentID());
            liElement.appendChild(valueElement);
        }
        catch (XPathExpressionException e) {
            throw new PDFXMPException(e);
        }
        catch (DOMException e) {
            throw new PDFXMPException(e);
        }
    }

    static {
        NamespaceContextImpl nameSpaceContextImpl = new NamespaceContextImpl();
        nameSpaceContextImpl.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        nameSpaceContextImpl.setNamespace("pdf", "http://ns.adobe.com/pdf/1.3/");
        nameSpaceContextImpl.setNamespace("iX", "http://ns.adobe.com/iX/1.0/");
        nameSpaceContextImpl.setNamespace("xmp", "http://ns.adobe.com/xap/1.0/");
        nameSpaceContextImpl.setNamespace("xapGImg", "http://ns.adobe.com/xap/1.0/g/img/");
        nameSpaceContextImpl.setNamespace("xmpMHT", "http://www.maas.de/xmp/1.0/xmpMHT/");
        nameSpaceContextImpl.setNamespace("dc", "http://purl.org/dc/elements/1.1/");
        nameSpaceContextImpl.setNamespace("x", "adobe:ns:meta/");
        XMP_NAMESPACE_CONTEXT = nameSpaceContextImpl;
    }
}

