/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.text;

import de.maas.saas.pdf.encoding.GermanPolishEncodingFactory;
import de.maas.saas.pdf.text.TextExtractor;
import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.encoding.Encoding;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.operator.OperatorProcessor;

public class TextFontOperation
extends OperatorProcessor {
    public void process(PDFOperator operator, List arguments) throws IOException {
        if (arguments.size() >= 2) {
            TextExtractor context = (TextExtractor)this.context;
            COSName fontName = (COSName)arguments.get(0);
            float fontSize = ((COSNumber)arguments.get(1)).floatValue();
            context.getGraphicsState().getTextState().setFontSize(fontSize);
            context.getGraphicsState().getTextState().setFont((PDFont)context.getFonts().get(fontName.getName()));
            PDFont font = context.getGraphicsState().getTextState().getFont();
            if (font == null) {
                throw new IOException("Error: Could not find font(" + fontName + ") in map=" + context.getFonts());
            }
            Encoding encoding = font.getEncoding();
            font.setEncoding(GermanPolishEncodingFactory.getEncoding(encoding));
        }
    }
}

