/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import de.maas.saas.tiff.TiffReaderException;
import de.maas.saas.tiff.reader.IFDEntry;
import de.maas.saas.tiff.reader.IFDEntryValue;
import de.maas.saas.tiff.reader.IFDName;
import de.maas.saas.tiff.reader.StripByteData;
import de.maas.saas.tiff.reader.TiffStream;
import de.maas.saas.tiff.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

class IFD {
    Hashtable<IFDName, IFDEntry> directoryEntries = new Hashtable();
    List<IFDName> keyList = new ArrayList<IFDName>(5);
    private byte[] numberOfEntries = null;
    private boolean littleEndian = false;
    private boolean readFullyFlag = false;
    float XRes = 0.0f;
    float YRes = 0.0f;
    byte[] xResolution = null;
    byte[] yResolution = null;
    StripByteData stripByteData = null;
    SizeType sizeType = SizeType.INCH;

    IFD(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    boolean readFully(int offset, TiffStream tiffStream) throws TiffReaderException, IOException {
        if (this.readFullyFlag) {
            throw new TiffReaderException("Tiff already readed");
        }
        tiffStream.gotoOffset(offset);
        int entries = tiffStream.read2bytes();
        this.numberOfEntries = tiffStream.getBytes(tiffStream.previousOffset, tiffStream.currentOffset);
        for (int i = 0; i < entries; ++i) {
            int id = tiffStream.read2bytes();
            tiffStream.skeepBytes(10);
            IFDEntry ifdde = new IFDEntry(id, tiffStream.getBytes(tiffStream.previousOffset, tiffStream.currentOffset), this.littleEndian);
            IFDName ifdname = IFDName.getIFDNameByID(id);
            if (ifdname == null) continue;
            if (ifdname.isValueArray()) {
                ifdde.value.setIsOffset(ifdname.isValueArray());
            }
            this.directoryEntries.put(ifdname, ifdde);
            this.keyList.add(ifdname);
        }
        boolean result = this.check4pdfbox();
        if (!result) {
            return false;
        }
        int nextOffset = tiffStream.read4bytes();
        this.directoryEntries.put(IFDName.NEXT_IFD_OFFSET, new IFDEntry(IFDName.NEXT_IFD_OFFSET.getID(), tiffStream.getBytes(tiffStream.previousOffset, tiffStream.currentOffset), this.littleEndian, nextOffset));
        this.setArrayValues(tiffStream);
        this.initImageData(tiffStream);
        this.readFullyFlag = true;
        return true;
    }

    private boolean check4pdfbox() {
        IFDEntry compressionEntry = this.directoryEntries.get((Object)IFDName.Compression);
        if (compressionEntry.getValueOrOffset() != 4) {
            return false;
        }
        IFDEntry stripOffsetsEntry = this.directoryEntries.get((Object)IFDName.StripOffsets);
        return stripOffsetsEntry == null || stripOffsetsEntry.getCount() <= 1;
    }

    private void setArrayValues(TiffStream tiffStream) throws TiffReaderException {
        for (IFDName name : this.directoryEntries.keySet()) {
            IFDEntry entry = this.directoryEntries.get((Object)name);
            if (!entry.isOffset()) continue;
            int entryOffset = entry.getValueOrOffset();
            if (name.equals((Object)IFDName.StripOffsets) || name.equals((Object)IFDName.StripByteCounts)) {
                if (entry.getCount() > 1) {
                    this.setArrayValue(tiffStream, entry);
                    continue;
                }
                entry.value.byteResultArrayValue.clear();
                entry.value.addByteArrayValue(new byte[]{entry.value.byteResultValue[8], entry.value.byteResultValue[9], entry.value.byteResultValue[10], entry.value.byteResultValue[11]});
                continue;
            }
            if (name.equals((Object)IFDName.TileOffsets) || name.equals((Object)IFDName.TileByteCounts)) {
                if (entry.getCount() > 1) {
                    this.setArrayValue(tiffStream, entry);
                    continue;
                }
                entry.value.byteResultArrayValue.clear();
                entry.value.addByteArrayValue(new byte[]{entry.value.byteResultValue[8], entry.value.byteResultValue[9], entry.value.byteResultValue[10], entry.value.byteResultValue[11]});
                continue;
            }
            if (name.equals((Object)IFDName.XResolution) || name.equals((Object)IFDName.YResolution)) {
                entry.value.byteResultArrayValue.clear();
                entry.value.byteResultArrayValue.add(tiffStream.getBytes(entryOffset, entryOffset + 8));
                continue;
            }
            this.setArrayValue(tiffStream, entry);
        }
    }

    private void setArrayValue(TiffStream tiffStream, IFDEntry entry) {
        int numberOfBytes = entry.getNumberOfBytes();
        int entryOffset = entry.getValueOrOffset();
        IFDEntryValue value = entry.value;
        value.byteResultArrayValue.clear();
        for (int i = 0; i < entry.getCount(); ++i) {
            value.addByteArrayValue(tiffStream.getBytes(entryOffset, entryOffset += numberOfBytes));
        }
    }

    private void initImageData(TiffStream tiffStream) throws TiffReaderException, IOException {
        boolean inch;
        IFDEntry stripOffsetseEntry = this.directoryEntries.get((Object)IFDName.StripOffsets);
        IFDEntry stripByteCountsEntry = this.directoryEntries.get((Object)IFDName.StripByteCounts);
        IFDEntry tileOffsetsEntry = this.directoryEntries.get((Object)IFDName.TileOffsets);
        IFDEntry tileByteCountsEntry = this.directoryEntries.get((Object)IFDName.TileByteCounts);
        IFDEntry xResolutionEntry = this.directoryEntries.get((Object)IFDName.XResolution);
        IFDEntry yResolutionEntry = this.directoryEntries.get((Object)IFDName.YResolution);
        IFDEntry resUnit = this.directoryEntries.get((Object)IFDName.ResolutionUnit);
        boolean centymeter = resUnit != null && resUnit.getValueOrOffset() == IFDName.ResolutionUnit.getSubValues()[2];
        boolean bl = inch = resUnit != null && resUnit.getValueOrOffset() == IFDName.ResolutionUnit.getSubValues()[1];
        if (xResolutionEntry == null || yResolutionEntry == null) {
            throw new TiffReaderException("No Resolution unit info.");
        }
        if (stripOffsetseEntry != null) {
            stripOffsetseEntry.value.setIsOffset(stripOffsetseEntry.getCount() > 1);
        }
        if (stripByteCountsEntry != null) {
            stripByteCountsEntry.value.setIsOffset(stripByteCountsEntry.getCount() > 1);
        }
        if (tileOffsetsEntry != null) {
            tileOffsetsEntry.value.setIsOffset(tileOffsetsEntry.getCount() > 1);
        }
        if (tileByteCountsEntry != null) {
            tileByteCountsEntry.value.setIsOffset(tileByteCountsEntry.getCount() > 1);
        }
        this.stripByteData = StripByteData.newInstance(tiffStream, stripOffsetseEntry, stripByteCountsEntry, tileOffsetsEntry, tileByteCountsEntry);
        this.initResolution(tiffStream, xResolutionEntry, yResolutionEntry, centymeter, inch);
    }

    private void initResolution(TiffStream tiffStream, IFDEntry xResolutionEntry, IFDEntry yResolutionEntry, boolean centymeter, boolean inch) {
        int xRes = xResolutionEntry.getValueOrOffset();
        tiffStream.gotoOffset(xRes);
        int nominator = tiffStream.read4bytes();
        int denominator = tiffStream.read4bytes();
        this.XRes = (float)nominator / (float)denominator;
        this.xResolution = tiffStream.getBytes(xRes, xRes + 8);
        if (yResolutionEntry != null) {
            int yRes = yResolutionEntry.getValueOrOffset();
            tiffStream.gotoOffset(yRes);
            nominator = tiffStream.read4bytes();
            denominator = tiffStream.read4bytes();
            this.YRes = (float)nominator / (float)denominator;
            this.yResolution = tiffStream.getBytes(yRes, yRes + 8);
        } else {
            this.YRes = this.XRes;
        }
        if (centymeter) {
            this.sizeType = SizeType.CENTIMETER;
        } else if (inch) {
            this.sizeType = SizeType.INCH;
        }
    }

    public void changeYResolution(long numerator, long denominator) {
        IFDEntry yResEntry = this.directoryEntries.get((Object)IFDName.YResolution);
        if (yResEntry != null) {
            int count = 0;
            byte[] value = yResEntry.value.byteResultArrayValue.get(0);
            value[count++] = (byte)(numerator & 0xFFL);
            value[count++] = (byte)(numerator >> 8 & 0xFFL);
            value[count++] = (byte)(numerator >> 16 & 0xFFL);
            value[count++] = (byte)(numerator >> 24 & 0xFFL);
            value[count++] = (byte)(denominator & 0xFFL);
            value[count++] = (byte)(denominator >> 8 & 0xFFL);
            value[count++] = (byte)(denominator >> 16 & 0xFFL);
            value[count++] = (byte)(denominator >> 24 & 0xFFL);
            yResEntry.value.byteResultArrayValue.clear();
            yResEntry.value.byteResultArrayValue.add(value);
            this.YRes = (float)numerator / (float)denominator;
        }
    }

    public void changeXResolution(long numerator, long denominator) throws TiffReaderException {
        if (!this.readFullyFlag) {
            throw new TiffReaderException("Tiff image has not been read yet.");
        }
        IFDEntry xResEntry = this.directoryEntries.get((Object)IFDName.XResolution);
        byte[] value = xResEntry.value.byteResultArrayValue.get(0);
        int count = 0;
        value[count++] = (byte)(numerator & 0xFFL);
        value[count++] = (byte)(numerator >> 8 & 0xFFL);
        value[count++] = (byte)(numerator >> 16 & 0xFFL);
        value[count++] = (byte)(numerator >> 24 & 0xFFL);
        value[count++] = (byte)(denominator & 0xFFL);
        value[count++] = (byte)(denominator >> 8 & 0xFFL);
        value[count++] = (byte)(denominator >> 16 & 0xFFL);
        value[count++] = (byte)(denominator >> 24 & 0xFFL);
        this.XRes = (float)numerator / (float)denominator;
        if (this.directoryEntries.get((Object)IFDName.YResolution) == null) {
            this.YRes = this.XRes;
        }
    }

    public IFD getNextIFDOffset(TiffStream tiffStream) throws TiffReaderException, IOException {
        if (!this.readFullyFlag) {
            throw new TiffReaderException("Tiff image has not been read yet.");
        }
        IFD ifd = new IFD(this.littleEndian);
        IFDEntry ifdde = this.directoryEntries.get((Object)IFDName.NEXT_IFD_OFFSET);
        if (!ifd.readFully(ifdde.getValueOrOffset(), tiffStream)) {
            return null;
        }
        return ifd;
    }

    public boolean hasNextOffset() {
        IFDEntry ifdde = this.directoryEntries.get((Object)IFDName.NEXT_IFD_OFFSET);
        return ifdde.getValueOrOffset() > 0;
    }

    public void changeEntryValue(IFDName ifdName, int newValue) throws TiffReaderException {
        if (!this.readFullyFlag) {
            throw new TiffReaderException("Tiff image has not been read yet.");
        }
        IFDEntry entry = this.directoryEntries.get((Object)ifdName);
        if (entry != null) {
            entry.changeValue(newValue);
        }
    }

    public byte[] toByteArray() throws IOException, TiffReaderException {
        if (!this.readFullyFlag) {
            throw new TiffReaderException("Tiff image has not been read yet.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            IFDEntry nextOffsetifd = this.directoryEntries.get((Object)IFDName.NEXT_IFD_OFFSET);
            nextOffsetifd.changeValue(0);
            int count = 0;
            for (IFDName key : this.keyList) {
                if (key == null) continue;
                IFDEntry ifdde = this.directoryEntries.get((Object)key);
                baos.write(ifdde.value.byteResultValue);
                baos.flush();
                ++count;
            }
            baos.write(nextOffsetifd.value.byteResultValue);
            baos.flush();
            result.write(StreamUtil.changeValue(this.numberOfEntries, count, 2, this.littleEndian));
            result.flush();
            result.write(baos.toByteArray());
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                baos.close();
                result.close();
            }
            catch (IOException e) {}
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.directoryEntries.clear();
        this.numberOfEntries = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SizeType {
        PIXEL,
        INCH,
        CENTIMETER;

    }
}

