/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum IFDName {
    NEXT_IFD_OFFSET(0, false),
    NewSubfileType(254, 0, "A general indication of the kind of data contaned in this subfile.", false),
    SubfileType(255, "A general indication of the kind of data contained in this subfile."),
    ImageWidth(256, "The number of columns in the image, ile., the number of pixels per row.", false),
    ImageLength(257, "The number of rows of pixels in the image.", false),
    BitsPerSample(258, 1, "Number of bits per component.", true),
    Compression(259, new int[]{1, 2, 3, 4, 5, 6, 32773}, 1, "Compression scheme used on the image data.", false),
    PhotometricInterpretation(262, new int[]{0, 1, 2, 3, 4, 5, 6, 8}, "The color space of the image data", false),
    Threshholding(263, 1, "For black and white TIFF files that represent shades of gray, the technique used to convert from gray to black and white pixels."),
    CellWidth(264, "The width of the dithering or halftoning matrix used to create a dithered or hlftoned bilevbel file."),
    CellLength(265, "The length of the dithering or halftoning matrix used to create a dithered or halftoned bilevel file."),
    FillOrder(266, 1, "The logical order of bits within a byte.", false),
    DocumentName(269, "The description of the document from which this image was scanned."),
    ImageDescription(270, "A string that describes the subject of the image."),
    Make(271, "The scanner manufacturer."),
    Model(272, "The scanner model description or number."),
    StripOffsets(273, "For each strip, the byte offset of that strip.", true),
    Orientation(274, 1, "The orientation of the image with respect to the rows and columns.", false),
    SamplesPerPixel(277, 1, "The number of components per pixel.", false),
    RowsPerStrip(278, "The number of rows per strip.", false),
    StripByteCounts(279, "For each strip, the number of bytes int the strip after compression.", true),
    MinSampleValue(280, 0, "The minimum component value used."),
    MaxSampleValue(281, "The maximum component value used."),
    XResolution(282, "The number of pixels per ResolutionUnit int the ImageWidth direction.", true),
    YResolution(283, "The number of pixels per ResolutionUnit int the ImageLength direction.", true),
    PlanarConfiguration(284, 1, "How the components of each pixel are stored.", false),
    PageName(285, "The description of the pdPage from which this image was scanned."),
    XPosition(286, "X position of the image."),
    YPosition(287, "Y position of the image."),
    FreeOffsets(288, "For each string of contiguous unused bytes in a TIFF file, the byte offset of the string."),
    FreeByteCounts(289, "For each string of contiguous unused bytes in a TIFF file, the number of bytes in the sytring."),
    GrayResponseUnit(290, 2, "The precision og the information cntained in the GrayResponseCurve."),
    GrayResponseCurve(291, "For grayscale data, the optical density of each possible pixel value."),
    T4Options(292, 0, false),
    T6Options(293, 0, false),
    ResolutionUnit(296, new int[]{1, 2, 3}, 2, "The unit of measurement for XResolution and YResolution.", false),
    PageNumber(297, "The pdPage number of the pdPage from which this image was scanned."),
    TransferFunction(301, false),
    Software(305, "Name and version number of the software package(s) used to create the image."),
    DateTime(306, "Date and time of image creation."),
    Artist(315, "Person who created the image."),
    HostComputer(316, "The computer and/or operating system in use at the time of image creation.", false),
    Predictor(317, 1),
    WhitePoint(318),
    PrimaryChromaticities(319),
    ColorMap(320, "A color map for palette color images.", true),
    HalftoneHints(321),
    TileWidth(322, false),
    TileLength(323, false),
    TileOffsets(324, true),
    TileByteCounts(325, true),
    InkSet(332, 1),
    IntNames(333),
    NumberOfInks(334, 4),
    DotRange(336),
    TargetPrinter(337, "A description of the printing environment for which this separation is intended."),
    ExtraSamples(338, "Description of extra components", false),
    SampleFormat(339, 1, "This field specifies how to interpret each data sample in a pixel."),
    SMinSampleValue(340),
    SMaxSampleValue(341),
    TransferRange(342),
    JPEGProc(512, "This field indicates the JPEG process used to produce the compressed data."),
    JPEGInterchangeFormat(513, "This field indicates whether a JPEG interchange format bitstream is present in the TIFF file."),
    JPEGInterchangeFormatLength(514, "This field indicates the length in bytes of the JPEG interchange format bitstream."),
    JPEGRestartInterval(515, "This field indicates the length of the restart interval used in the compressed image data."),
    JPEGLosslessPredictors(517, "This field points to a list of lossless predictor-selection values, one per component."),
    JPEGPointTransforms(518, "This field point to a list of point transform values, one per component."),
    JPEGQTables(519, "This field points to a lst of offsets to the quantization tables, one per component."),
    JPEGDCTables(520, "This field points to a list of offsets to the DC Huffman tables or the lossless Huffman tables, one per component."),
    JPEGACTables(521, "This field points to a list of offsets to the Huffman AC tables, one per component."),
    YCbCrCoeffictients(529, true),
    YCbCrSubSampling(530, true),
    YCbCrPositioning(531, false),
    ReferenceBlackWhite(532, "Specifies a pair of headroom and footroom image data values (codes) for each pixel component."),
    Copyright(33432, "Copyright noice.");

    private static final Hashtable<Integer, IFDName> ifdNames;
    private final int id;
    private int[] subValues;
    private int defaultValue;
    private boolean subValuesAvailable = false;
    private boolean defaultValueAvailable = false;
    private boolean descriptionAvailable = false;
    private boolean valueArray = false;
    private String desctription;

    public static IFDName getIFDNameByID(Integer id) {
        return ifdNames.get(id);
    }

    private IFDName(int id) {
        this.id = id;
    }

    private IFDName(int id, boolean valueArray) {
        this.id = id;
        this.valueArray = valueArray;
    }

    private IFDName(int id, String description) {
        this.id = id;
        this.desctription = description;
        this.descriptionAvailable = true;
    }

    private IFDName(int id, String description, boolean valueArray) {
        this.id = id;
        this.desctription = description;
        this.descriptionAvailable = true;
        this.valueArray = valueArray;
    }

    private IFDName(int id, int defaultValue) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.defaultValueAvailable = true;
    }

    private IFDName(int id, int defaultValue, boolean valueArray) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.defaultValueAvailable = true;
        this.valueArray = valueArray;
    }

    private IFDName(int id, int defaultValue, String description) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.desctription = description;
        this.defaultValueAvailable = true;
        this.descriptionAvailable = true;
    }

    private IFDName(int id, int defaultValue, String description, boolean valueArray) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.desctription = description;
        this.defaultValueAvailable = true;
        this.descriptionAvailable = true;
        this.valueArray = valueArray;
    }

    private IFDName(int id, int[] subValues, int defaultValue, String description, boolean valueArray) {
        this.id = id;
        this.subValues = subValues;
        this.subValuesAvailable = true;
        this.defaultValue = defaultValue;
        this.defaultValueAvailable = true;
        this.desctription = description;
        this.descriptionAvailable = true;
        this.valueArray = valueArray;
    }

    private IFDName(int id, int[] subValues, String description, boolean valueArray) {
        this.id = id;
        this.subValues = subValues;
        this.subValuesAvailable = true;
        this.desctription = description;
        this.descriptionAvailable = true;
        this.valueArray = valueArray;
    }

    public int getID() {
        return this.id;
    }

    public boolean isValueArray() {
        return this.valueArray;
    }

    public int[] getSubValues() {
        return this.subValues;
    }

    public boolean isDefaultValueAvailable() {
        return this.defaultValueAvailable;
    }

    public boolean isDescriptionAvailable() {
        return this.descriptionAvailable;
    }

    public boolean isSubValuesAvailable() {
        return this.subValuesAvailable;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public String getDesctription() {
        return this.desctription;
    }

    static {
        ifdNames = new Hashtable();
        for (IFDName name : IFDName.values()) {
            ifdNames.put(name.getID(), name);
        }
    }
}

