/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.TIFFImage;
import com.sun.media.jai.codecimpl.TIFFImageDecoder;
import com.sun.media.jai.codecimpl.TIFFImageEncoder;
import de.maas.saas.tiff.TiffImage;
import de.maas.saas.tiff.TiffImageEnumeration;
import de.maas.saas.tiff.TiffReaderException;
import de.maas.saas.tiff.reader.IFD;
import de.maas.saas.tiff.reader.TiffImageImpl;
import de.maas.saas.tiff.reader.TiffStream;
import de.maas.saas.tiff.util.StreamUtil;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import sun.awt.image.BytePackedRaster;

class TiffImageEnumerationImpl
implements TiffImageEnumeration {
    private IFD currentIFD;
    private List<TiffStream> tiffStreamList;
    private int currentTiffStreamIndex;
    private boolean processCurrentIFD;
    private boolean jaiConvertError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TiffImageEnumerationImpl(InputStream inputStream) throws IOException, TiffReaderException {
        block8: {
            this.currentIFD = null;
            this.tiffStreamList = new ArrayList<TiffStream>();
            this.currentTiffStreamIndex = 0;
            this.processCurrentIFD = true;
            this.jaiConvertError = false;
            byte[] imageData = StreamUtil.readStream(inputStream);
            TiffStream tiffStream = new TiffStream(imageData);
            boolean readSuccessed = tiffStream.read();
            if (!readSuccessed) {
                ByteArrayInputStream bais = null;
                try {
                    bais = new ByteArrayInputStream(imageData);
                    tiffStream.clear();
                    tiffStream = null;
                    JaiConverterResult convertionResult = TiffJaiConverter.convertImage(bais);
                    if (!convertionResult.isSuccess()) {
                        this.jaiConvertError = true;
                        return;
                    }
                    this.tiffStreamList = convertionResult.getResultStream();
                    readSuccessed = this.tiffStreamList.get(this.currentTiffStreamIndex).read();
                    if (!readSuccessed) {
                        throw new TiffReaderException("Exception while reading tiff image. Compression, tile or strips");
                    }
                    break block8;
                }
                finally {
                    if (bais != null) {
                        bais.close();
                    }
                }
            }
            this.tiffStreamList.add(tiffStream);
        }
        this.currentIFD = this.tiffStreamList.get((int)this.currentTiffStreamIndex).firstIFD;
    }

    public boolean isError() {
        return this.jaiConvertError;
    }

    public boolean hasMoreElements() {
        return this.currentTiffStreamIndex < this.tiffStreamList.size() || this.processCurrentIFD;
    }

    public TiffImage nextElement() {
        try {
            TiffImageImpl tiffImage = null;
            if (this.processCurrentIFD || this.currentIFD.hasNextOffset()) {
                tiffImage = new TiffImageImpl(this.tiffStreamList.get((int)this.currentTiffStreamIndex).tiffHeader, this.currentIFD);
                if (this.currentIFD.hasNextOffset()) {
                    this.currentIFD = this.currentIFD.getNextIFDOffset(this.tiffStreamList.get(this.currentTiffStreamIndex));
                    this.processCurrentIFD = true;
                } else {
                    this.processCurrentIFD = false;
                    ++this.currentTiffStreamIndex;
                }
            } else if (this.currentTiffStreamIndex < this.tiffStreamList.size()) {
                if (this.tiffStreamList.get(this.currentTiffStreamIndex).read()) {
                    this.currentIFD = this.tiffStreamList.get((int)this.currentTiffStreamIndex).firstIFD;
                    tiffImage = new TiffImageImpl(this.tiffStreamList.get((int)this.currentTiffStreamIndex).tiffHeader, this.currentIFD);
                    this.processCurrentIFD = this.currentIFD.hasNextOffset();
                    if (!this.processCurrentIFD) {
                        ++this.currentTiffStreamIndex;
                    }
                } else {
                    throw new RuntimeException("Error while reading next image file directory from tiff image");
                }
            }
            if (this.currentIFD == null) {
                throw new RuntimeException("next ifd is null cannot read from tiff image");
            }
            return tiffImage;
        }
        catch (TiffReaderException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.currentIFD = this.tiffStreamList.get((int)0).firstIFD;
        this.currentTiffStreamIndex = 0;
    }

    protected void finalize() throws Throwable {
        this.tiffStreamList.clear();
        this.tiffStreamList = null;
        super.finalize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JaiConverterResult {
        private List<TiffStream> resultStream = new ArrayList<TiffStream>();
        private boolean success = true;

        public JaiConverterResult() {
        }

        public JaiConverterResult(List<TiffStream> resultStream, boolean success) {
            this.resultStream = resultStream;
            this.success = success;
        }

        public List<TiffStream> getResultStream() {
            return this.resultStream;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }
    }

    static class TiffJaiConverter {
        private static final byte[] RGB = new byte[]{-1, 0};
        private static TiffJaiConverter instance = null;

        private static TiffJaiConverter getInstance() {
            if (instance == null) {
                instance = new TiffJaiConverter();
            }
            return instance;
        }

        private TiffJaiConverter() {
        }

        public static synchronized JaiConverterResult convertImage(InputStream source) throws IOException, TiffReaderException {
            TiffJaiConverter converter = TiffJaiConverter.getInstance();
            JaiConverterResult result = converter.convert(source);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JaiConverterResult convert(InputStream sourceImage) throws IOException {
            SeekableStream jaiStream = null;
            JaiConverterResult converterResult = new JaiConverterResult();
            try {
                jaiStream = SeekableStream.wrapInputStream((InputStream)sourceImage, (boolean)true);
                TIFFImageDecoder imageDecoder = new TIFFImageDecoder(jaiStream, (ImageDecodeParam)new TIFFDecodeParam());
                for (int i = 0; i < imageDecoder.getNumPages(); ++i) {
                    TIFFImage imagetmp = (TIFFImage)imageDecoder.decodeAsRenderedImage(i);
                    ColorModel cm = imagetmp.getColorModel();
                    Raster rasterImage = imagetmp.getData();
                    WritableRaster rasterImageCopy = null;
                    if (rasterImage instanceof WritableRaster || rasterImage instanceof BytePackedRaster) {
                        rasterImageCopy = (WritableRaster)rasterImage;
                        rasterImageCopy = imagetmp.copyData(rasterImageCopy);
                    }
                    Hashtable<String, Object> properties = new Hashtable<String, Object>();
                    TIFFDirectory tiffDirectory = (TIFFDirectory)imagetmp.getProperty("tiff_directory");
                    for (String name : imagetmp.getPropertyNames()) {
                        properties.put(name, imagetmp.getProperty(name));
                    }
                    ArrayList<TIFFField> tiffFieldList = new ArrayList<TIFFField>();
                    TIFFField[] tiffFields = null;
                    TIFFField xfield = tiffDirectory.getField(282);
                    TIFFField yfield = tiffDirectory.getField(283);
                    TIFFField resField = tiffDirectory.getField(296);
                    if (yfield == null) {
                        yfield = this.getDefaultYRes(tiffDirectory);
                    }
                    if (xfield == null) {
                        xfield = this.getDefaultXRes(tiffDirectory);
                    }
                    tiffFieldList.add(xfield);
                    tiffFieldList.add(yfield);
                    if (resField == null) {
                        resField = this.getDefaultResUnit();
                    }
                    tiffFieldList.add(resField);
                    tiffFields = tiffFieldList.toArray(new TIFFField[tiffFieldList.size()]);
                    ByteArrayOutputStream baostmp = new ByteArrayOutputStream();
                    TIFFEncodeParam mainParam = null;
                    TIFFImageEncoder encoder = new TIFFImageEncoder((OutputStream)baostmp, mainParam);
                    BufferedImage decodedImage = new BufferedImage(cm, rasterImageCopy, true, properties);
                    decodedImage.setData(rasterImage);
                    mainParam = new TIFFEncodeParam();
                    if (tiffFields != null && tiffFields.length > 0) {
                        mainParam.setExtraFields(tiffFields);
                    }
                    mainParam.setCompression(4);
                    mainParam.setWriteTiled(true);
                    mainParam.setT4Encode2D(false);
                    encoder.setParam((ImageEncodeParam)mainParam);
                    encoder.encode((RenderedImage)decodedImage);
                    baostmp.flush();
                    converterResult.getResultStream().add(new TiffStream(baostmp.toByteArray()));
                    baostmp.close();
                }
                JaiConverterResult jaiConverterResult = converterResult;
                return jaiConverterResult;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                converterResult.getResultStream().clear();
                converterResult.setSuccess(false);
                System.err.println(e.getMessage());
                e.printStackTrace();
                JaiConverterResult jaiConverterResult = converterResult;
                return jaiConverterResult;
            }
            finally {
                if (jaiStream != null) {
                    jaiStream.close();
                }
            }
        }

        private TIFFField getDefaultXRes(TIFFDirectory tDir) {
            float width = tDir.getFieldAsFloat(256);
            int xRes = (int)(width / 612.0f * 72.0f);
            TIFFField xfield = new TIFFField(282, 5, 1, (Object)new long[][]{{xRes, 1L}});
            return xfield;
        }

        private TIFFField getDefaultYRes(TIFFDirectory tDir) {
            long height = tDir.getFieldAsLong(257);
            long yRes = height * 72L / 792L;
            TIFFField yfield = new TIFFField(283, 5, 1, (Object)new long[][]{{yRes, 1L}});
            return yfield;
        }

        private TIFFField getDefaultResUnit() {
            return new TIFFField(296, 3, 1, (Object)new char[]{'\u0002'});
        }
    }
}

