/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any;

import de.maas.oxseed.office2any.MSOffice2007Converter;
import de.maas.oxseed.office2any.bean.RequestInfo;
import de.maas.oxseed.office2any.blocking.BlockingCommandQueue;
import de.maas.oxseed.office2any.blocking.ResultListener;
import de.maas.oxseed.office2any.exceptions.MSOffice2007ConverterException;
import de.maas.oxseed.office2any.exceptions.MSOfficeManagerException;
import de.maas.oxseed.office2any.exceptions.ProcessManagerException;
import de.maas.oxseed.office2any.exceptions.StorageException;
import de.maas.oxseed.office2any.managers.DcomProcessManagerImpl;
import de.maas.oxseed.office2any.managers.MSExcelDcomManager;
import de.maas.oxseed.office2any.managers.MSOfficeDcomManager;
import de.maas.oxseed.office2any.managers.MSOfficeManager;
import de.maas.oxseed.office2any.managers.MSWordDcomManager;
import de.maas.oxseed.office2any.managers.ProcessManager;
import de.maas.oxseed.office2any.storage.Storage;
import de.maas.oxseed.office2any.storage.StorageFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DcomMSOffice2007Converter
extends MSOffice2007Converter {
    private static Logger logger = Logger.getLogger(DcomMSOffice2007Converter.class);
    protected String host;
    protected String domain;
    protected String username;
    protected String password;

    public DcomMSOffice2007Converter(String id, String application, BlockingCommandQueue<RequestInfo> queueRequest, ResultListener resultListener, String urlStorage, String host, String domain, String username, String password) {
        super(id, application, queueRequest, resultListener, urlStorage);
        this.host = host;
        this.domain = domain;
        this.username = username;
        this.password = password;
    }

    @Override
    protected MSOfficeManager createMSOfficeManagerInstance(String application) throws MSOffice2007ConverterException {
        try {
            MSOfficeDcomManager manager = null;
            if ("WINWORD.EXE".equals(application)) {
                manager = new MSWordDcomManager(this.host, this.domain, this.username, this.password);
            } else if ("EXCEL.EXE".equals(application)) {
                manager = new MSExcelDcomManager(this.host, this.domain, this.username, this.password);
            } else {
                throw new MSOffice2007ConverterException("Application " + application + " is not supported.");
            }
            return manager;
        }
        catch (MSOfficeManagerException e) {
            throw new MSOffice2007ConverterException((Throwable)((Object)e));
        }
    }

    @Override
    protected ProcessManager createProcessManagerInstance() throws MSOffice2007ConverterException {
        try {
            DcomProcessManagerImpl manager = new DcomProcessManagerImpl(this.host, this.domain, this.username, this.password);
            return manager;
        }
        catch (ProcessManagerException e) {
            throw new MSOffice2007ConverterException((Throwable)((Object)e));
        }
    }

    @Override
    protected Storage getShareInstance() throws MSOffice2007ConverterException {
        try {
            Storage storage = StorageFactory.getInstance(this.urlStorage, this.username, this.password, this.domain);
            return storage;
        }
        catch (StorageException e) {
            throw new MSOffice2007ConverterException((Throwable)((Object)e));
        }
    }
}

