/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any;

import de.maas.oxseed.office2any.DcomConstants;
import de.maas.oxseed.office2any.MSOffice2007ApplicationManager;
import de.maas.oxseed.office2any.MSOffice2007Shared;
import de.maas.oxseed.office2any.MSOffice2007Transformer;
import de.maas.oxseed.office2any.bean.RequestInfo;
import de.maas.oxseed.office2any.bean.RequestInfoImpl;
import de.maas.oxseed.office2any.bean.ResultInfo;
import de.maas.oxseed.office2any.blocking.BlockingCommandQueue;
import de.maas.oxseed.office2any.blocking.BlockingCommandQueueImpl;
import de.maas.oxseed.office2any.blocking.BlockingObjectImpl;
import de.maas.oxseed.office2any.blocking.ResultListener;
import de.maas.oxseed.office2any.exceptions.MSOffice2007ApplicationManagerException;
import de.maas.oxseed.office2any.exceptions.MSOffice2007TransformerException;
import de.maas.oxseed.office2any.exceptions.MSOffice2007UnsupportedFormatException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MSOffice2007TransformerImpl
implements MSOffice2007Transformer {
    private static Logger logger = Logger.getLogger(MSOffice2007TransformerImpl.class);
    protected Map<String, MSOffice2007ApplicationManager> applicationManagers;
    protected int countWordApp;
    protected int countExcelApp;
    protected BlockingCommandQueue<ResultInfo> queueResult;
    protected String urlStorage;
    protected ResultListener resultListener;
    protected boolean stateClosed = false;
    protected double horizontalPrintQuality = 0.0;
    protected double verticalPrintQuality = 0.0;

    public MSOffice2007TransformerImpl(int countWordApp, int countExcelApp, String urlStorage, double horizontalPrintQuality, double verticalPrintQuality) {
        this.countWordApp = countWordApp;
        this.countExcelApp = countExcelApp;
        this.urlStorage = urlStorage;
        this.horizontalPrintQuality = horizontalPrintQuality;
        this.verticalPrintQuality = verticalPrintQuality;
        this.queueResult = new BlockingCommandQueueImpl<ResultInfo>(DcomConstants.OUTPUT_QUEUE_MAX_SIZE);
    }

    protected abstract MSOffice2007ApplicationManager createApplicationManagerInstance(String var1, int var2) throws MSOffice2007TransformerException;

    protected void init() throws MSOffice2007TransformerException {
        logger.info((Object)"msoffice-transformer starting...");
        this.resultListener = new ResultListener(this.queueResult);
        this.applicationManagers = new HashMap<String, MSOffice2007ApplicationManager>();
        MSOffice2007ApplicationManager wordManager = this.createApplicationManagerInstance("WINWORD.EXE", this.countWordApp);
        wordManager.init();
        this.applicationManagers.put("WINWORD.EXE", wordManager);
        logger.info((Object)("Word Application Manager (" + this.countWordApp + ") started."));
        MSOffice2007ApplicationManager excelManager = this.createApplicationManagerInstance("EXCEL.EXE", this.countExcelApp);
        excelManager.init();
        this.applicationManagers.put("EXCEL.EXE", excelManager);
        logger.info((Object)("Excel Application Manager (" + this.countExcelApp + ") started."));
        logger.info((Object)"msoffice-transformer started.");
    }

    public byte[] transform(InputStream sourceDocument, long contentType, long outMimeType, String application, long conversionOptions, long timeOut, String password) throws MSOffice2007TransformerException {
        if (this.stateClosed) {
            throw new MSOffice2007TransformerException("Transformer is already closed!");
        }
        String id = this.generateId();
        RequestInfoImpl requestInfo = new RequestInfoImpl();
        requestInfo.setId(id);
        requestInfo.setSource(sourceDocument);
        requestInfo.setContentType(contentType);
        requestInfo.setOutMimeType(outMimeType);
        requestInfo.setPassword(password);
        requestInfo.setHorizontalPrintQuality(this.horizontalPrintQuality);
        requestInfo.setVerticalPrintQuality(this.verticalPrintQuality);
        requestInfo.setConvertionOptions(conversionOptions);
        String app = this.validateRequestInfo(application, requestInfo);
        try {
            MSOffice2007Shared.getExtensionByOutMimeType((long)outMimeType);
        }
        catch (MSOffice2007UnsupportedFormatException e1) {
            throw new MSOffice2007TransformerException("Unknown outMimeType=" + outMimeType, (Throwable)e1);
        }
        MSOffice2007ApplicationManager applicationManager = this.applicationManagers.get(app);
        if (applicationManager != null) {
            BlockingObjectImpl<ResultInfo> blockingObject = new BlockingObjectImpl<ResultInfo>();
            blockingObject.setId(requestInfo.getId());
            this.resultListener.addForListening(blockingObject);
            logger.info((Object)("Add request to application manager. Request: " + requestInfo));
            applicationManager.addTask(requestInfo);
            ResultInfo resultInfo = null;
            try {
                resultInfo = (ResultInfo)blockingObject.getResult(timeOut);
            }
            catch (InterruptedException e) {
                throw new MSOffice2007TransformerException("Error while waiting for result", (Throwable)e);
            }
            finally {
                this.resultListener.removeFromListening(blockingObject);
            }
            if (resultInfo == null) {
                throw new MSOffice2007TransformerException("Timeout (no result)");
            }
            if (resultInfo.getErrorMessage() != null) {
                throw new MSOffice2007TransformerException("Error while transform action:" + resultInfo.getErrorMessage());
            }
            return resultInfo.getData();
        }
        throw new MSOffice2007TransformerException("Could not find suitable application for given application, contentType and outMimeType.");
    }

    public byte[] transform(InputStream sourceDocument, long contentType, long outMimeType, String application, long conversionOptions, long timeOut) throws MSOffice2007TransformerException {
        return this.transform(sourceDocument, contentType, outMimeType, application, conversionOptions, timeOut, null);
    }

    protected abstract String generateId();

    protected void stopSignal() {
        Iterator<Map.Entry<String, MSOffice2007ApplicationManager>> i = this.applicationManagers.entrySet().iterator();
        while (i.hasNext()) {
            MSOffice2007ApplicationManager applicationManager = i.next().getValue();
            applicationManager.stopSignal();
        }
    }

    protected void stop() {
        Iterator<Map.Entry<String, MSOffice2007ApplicationManager>> i = this.applicationManagers.entrySet().iterator();
        while (i.hasNext()) {
            MSOffice2007ApplicationManager applicationManager = i.next().getValue();
            applicationManager.stop();
        }
    }

    protected void releaseResources() {
        Iterator<Map.Entry<String, MSOffice2007ApplicationManager>> i = this.applicationManagers.entrySet().iterator();
        while (i.hasNext()) {
            MSOffice2007ApplicationManager applicationManager = i.next().getValue();
            try {
                applicationManager.releaseResources();
            }
            catch (MSOffice2007ApplicationManagerException e) {
                logger.error((Object)"Error while releasing resources of applicationManager", (Throwable)((Object)e));
            }
        }
    }

    public void close() {
        logger.info((Object)"msoffice-transformer is closing...");
        this.stopSignal();
        this.stop();
        this.releaseResources();
        this.stateClosed = true;
        logger.info((Object)"msoffice-transformer closed.");
    }

    protected String validateRequestInfo(String application, RequestInfo requestInfo) throws MSOffice2007UnsupportedFormatException {
        String suitableApplication = application;
        long contentType = requestInfo.getContentType();
        long convertionOptions = requestInfo.getConvertionOptions();
        if ("APPLICATION_AUTO".equals(suitableApplication)) {
            if ((contentType & 0xFL) != 0L) {
                if (convertionOptions == 1L) {
                    convertionOptions = 0L;
                }
                suitableApplication = "WINWORD.EXE";
            } else if ((contentType & 0xF0L) != 0L) {
                if (convertionOptions == 1L) {
                    convertionOptions = 0L;
                }
                suitableApplication = "EXCEL.EXE";
            } else if ((contentType & 0xF00L) != 0L) {
                if ((contentType & 0xF000L) != 0L) {
                    if (convertionOptions == 1L) {
                        convertionOptions = 45056L;
                    }
                    suitableApplication = "EXCEL.EXE";
                } else {
                    if (convertionOptions == 1L) {
                        convertionOptions = 0L;
                    }
                    suitableApplication = "WINWORD.EXE";
                }
            } else {
                throw new MSOffice2007UnsupportedFormatException("Can not find suitalbe application for contentType=" + contentType + ".");
            }
        }
        requestInfo.setConvertionOptions(convertionOptions);
        logger.debug((Object)("Suitable application = " + suitableApplication + " for " + requestInfo));
        return suitableApplication;
    }
}

