/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.blocking;

import de.maas.oxseed.office2any.bean.ResultInfo;
import de.maas.oxseed.office2any.blocking.BlockingCommandQueue;
import de.maas.oxseed.office2any.blocking.BlockingObject;
import de.maas.oxseed.office2any.exceptions.MSOffice2007RuntimeException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultListener {
    public static Logger logger = Logger.getLogger(ResultListener.class);
    public static final int RESULT_NO_ID = -2;
    public static final int RESULT_ID_NOT_FOUND = -1;
    public static final int RESULT_OK = 0;
    private BlockingCommandQueue<ResultInfo> queueResult;
    private Map<String, BlockingObject<ResultInfo>> map = new ConcurrentHashMap<String, BlockingObject<ResultInfo>>();
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private long WAIT_AFTER_SHUTDOWN = 60000L;

    public ResultListener(BlockingCommandQueue<ResultInfo> queue) {
        this.queueResult = queue;
        this.startManager();
    }

    public void addForListening(BlockingObject<ResultInfo> lock) {
        String id = lock.getId();
        if (id == null) {
            throw new MSOffice2007RuntimeException("BlockingObject should have id!");
        }
        if (this.map.containsKey(id)) {
            throw new MSOffice2007RuntimeException("BlockingObject id=\"" + id + "\" is already listened!");
        }
        this.map.put(id, lock);
        logger.debug((Object)("lock id=" + lock.getId() + " is added for listening"));
    }

    public void removeFromListening(BlockingObject<ResultInfo> lock) {
        String id = lock.getId();
        if (id == null) {
            throw new MSOffice2007RuntimeException("BlockingObject should have id!");
        }
        if (!this.map.containsKey(id)) {
            throw new MSOffice2007RuntimeException("BlockingObject id=\"" + id + "\" is not already listened!");
        }
        this.map.remove(id);
        logger.debug((Object)("lock id=" + lock.getId() + " is removed for listening"));
    }

    public boolean isRequestListened(String id) {
        return this.map.containsKey(id);
    }

    public int countListenedObjects() {
        return this.map.size();
    }

    protected void startManager() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (!ResultListener.this.executorService.isShutdown()) {
                    try {
                        logger.debug((Object)("before take queueSize: " + ResultListener.this.queueResult.size()));
                        final ResultInfo resultObject = (ResultInfo)ResultListener.this.queueResult.take();
                        logger.debug((Object)("after take result (id=" + resultObject.getId() + ") queueSize: " + ResultListener.this.queueResult.size()));
                        Callable<Integer> task = new Callable<Integer>(){

                            @Override
                            public Integer call() throws Exception {
                                return ResultListener.this.handleQueueObject(resultObject);
                            }
                        };
                        Future<Integer> future = ResultListener.this.executorService.submit(task);
                        Integer result = null;
                        try {
                            result = future.get();
                            logger.debug((Object)("result=" + result + " for id=" + resultObject.getId() + "."));
                        }
                        catch (Exception e) {
                        }
                    }
                    catch (RejectedExecutionException e) {
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        thread.start();
    }

    private synchronized int handleQueueObject(ResultInfo resultObject) {
        String id = resultObject.getId();
        if (id == null) {
            return -2;
        }
        if (!this.map.containsKey(id)) {
            return -1;
        }
        BlockingObject<ResultInfo> blockingObject = this.map.get(id);
        blockingObject.setResult(resultObject);
        return 0;
    }

    public void stopSignal() {
        this.executorService.shutdown();
    }

    public void stop() throws InterruptedException {
        this.stopSignal();
        this.executorService.awaitTermination(this.WAIT_AFTER_SHUTDOWN, TimeUnit.MILLISECONDS);
    }

    public void addResultToQueue(ResultInfo resultInfo) {
        this.queueResult.add(resultInfo);
    }
}

