/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.storage;

import de.maas.oxseed.office2any.exceptions.StorageException;
import de.maas.oxseed.office2any.storage.StorageFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FilesystemStorageFile
implements StorageFile {
    private File file;

    public FilesystemStorageFile(String url) {
        this.file = new File(url);
    }

    public void delete() {
        this.file.delete();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public InputStream getInputStream() throws StorageException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new StorageException(e);
        }
    }

    public boolean canRead() throws StorageException {
        try {
            return this.file.canRead();
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    public OutputStream getOutputStream() throws StorageException {
        try {
            return new FileOutputStream(this.file);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public String getCanonicalPath() throws StorageException {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public boolean isDirectory() throws StorageException {
        return this.file.isDirectory();
    }

    public String[] listStorageFileNames() throws StorageException {
        return this.file.list();
    }

    public void mkDirs() throws StorageException {
        this.file.mkdirs();
    }
}

