/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.storage;

import de.maas.oxseed.office2any.exceptions.StorageException;
import de.maas.oxseed.office2any.storage.StorageConstants;
import de.maas.oxseed.office2any.storage.StorageFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class Storage
implements StorageConstants {
    public static final Logger log = Logger.getLogger(Storage.class);
    protected static Map<String, Storage> openShares = new HashMap<String, Storage>();
    protected int users = 0;
    protected String url;
    protected String localSharePath;

    protected synchronized void addUser() {
        ++this.users;
        log.debug((Object)("Added new user to " + this.url.toString() + ": " + this.users));
    }

    public synchronized void close() {
        if (--this.users < 1) {
            Storage o = openShares.remove(this.url.toString());
            log.debug((Object)("remove url.toString(): " + (o != null)));
        }
    }

    public BufferedInputStream retrieveFile(String filePath, long timeout) throws StorageException {
        InputStream in = this.waitAndGetInputStream(filePath, timeout);
        BufferedInputStream result = new BufferedInputStream(in);
        return result;
    }

    public void sendFile(File file, String name) throws StorageException {
        try {
            if (!file.isDirectory()) {
                FileInputStream fis = new FileInputStream(file);
                this.sendDataToFile(fis, name);
                fis.close();
            } else {
                this.getStorageFile(name).mkDirs();
                for (File file2send : file.listFiles()) {
                    this.sendFile(file2send, name + "/" + file2send.getName());
                }
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendDataToFile(InputStream is, String filePath) throws StorageException {
        BufferedInputStream bis;
        block13: {
            StorageFile to = null;
            OutputStream out = null;
            bis = null;
            try {
                try {
                    to = this.getStorageFile(filePath);
                    log.debug((Object)("CALL send " + to.getCanonicalPath()));
                    out = to.getOutputStream();
                    bis = new BufferedInputStream(is);
                    byte[] b = new byte[4096];
                    int i = 0;
                    while ((i = bis.read(b)) != -1) {
                        out.write(b, 0, i);
                    }
                    log.debug((Object)("DONE send " + to.getCanonicalPath()));
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
                Object var9_9 = null;
                if (out == null) break block13;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Error while closing stream. File:" + to.getCanonicalPath() + "ErrorMsg:" + e.getMessage()));
                        throw new StorageException(e);
                    }
                    out = null;
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        throw new StorageException(e);
                    }
                    bis = null;
                }
                to = null;
                throw throwable;
            }
            try {}
            catch (IOException e) {
                log.error((Object)("Error while closing stream. File:" + to.getCanonicalPath() + "ErrorMsg:" + e.getMessage()));
                throw new StorageException(e);
            }
            out.close();
            out = null;
        }
        if (bis == null) return;
        try {}
        catch (IOException e) {
            throw new StorageException(e);
        }
        bis.close();
    }

    public boolean fileExists(String filename) throws StorageException {
        StorageFile f = this.getStorageFile(filename);
        return f.exists();
    }

    protected boolean deleteSingleFile(String filename, long timoutMillis) throws StorageException {
        StorageFile f = null;
        f = this.getStorageFile(filename);
        log.debug((Object)("CALL deleting " + f.getCanonicalPath()));
        int i = 0;
        while ((long)i <= timoutMillis) {
            try {
                f.delete();
                if (!f.exists()) {
                    log.debug((Object)("File " + f.getCanonicalPath() + " deleted."));
                    return true;
                }
            }
            catch (StorageException e) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
            i = (int)((long)i + 500L);
        }
        return false;
    }

    public boolean deleteFile(String filename, long timoutMillis) throws StorageException {
        StorageFile file = this.getStorageFile(filename);
        if (file.isDirectory()) {
            for (String name : file.listStorageFileNames()) {
                this.deleteFile(filename + "/" + name + "/", timoutMillis);
            }
        }
        return this.deleteSingleFile(filename, timoutMillis);
    }

    public InputStream waitAndGetInputStream(String filePath, long timeoutMillis) throws StorageException {
        StorageFile from = this.getStorageFile(filePath);
        boolean bFileReadableTmp = false;
        InputStream inRetTmp = null;
        StorageException excepTmp = null;
        String sFilenameTmp = from.getCanonicalPath();
        int iCountTmp = 0;
        int i = 0;
        while ((long)i <= timeoutMillis) {
            ++iCountTmp;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                break;
            }
            try {
                inRetTmp = from.getInputStream();
                bFileReadableTmp = true;
                log.info((Object)(sFilenameTmp + " file is readable. Number of FileRead checkings: " + iCountTmp));
                break;
            }
            catch (StorageException ePar) {
                excepTmp = ePar;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sFilenameTmp + " file is not readable yet." + ePar.getMessage()));
                }
                i = (int)((long)i + 500L);
            }
        }
        if (bFileReadableTmp) {
            return inRetTmp;
        }
        log.info((Object)(sFilenameTmp + " file is not readable. Number of FileRead checkings: " + iCountTmp));
        throw excepTmp;
    }

    public abstract StorageFile getStorageFile(String var1) throws StorageException;

    public abstract String getLocalStoragePath() throws StorageException;

    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "Storage ( " + super.toString() + "    " + "url = " + this.url + "    " + "users = " + this.users + "    " + "localSharePath = " + this.localSharePath + "    " + " )";
        return retValue;
    }
}

