*   [Overview](#overview)
*   [Installation](#installation)
*   [Configuration](#configuration)
*   [Dependencies](#dependencies)
*   [Routes](#routes)
*   [Services](#services)
    *   [Sync.Transformation](#syncTransformation)
        *   [Request](#syncReq)
        *   [Response](#syncRes)
    *   [Async.Transformation](#asyncTransformation)
        *   [Request](#asyncReq)
        *   [Response](#asyncRes)        
    *   [Job Status](#jobStatus)
        *   [Request](#jobReq)
        *   [Response](#jobRes)
*   [Download](#download)

<a name="overview"></a>
<h2 id="overview">Overview</h2>

  * Plugin to do AFP2web supported transformations. 
  * It internally calls AFP2web Server to do the transformations.
  * Run npm install before running any grunt tasks for the plugin
  * Run 'grunt' to get list of grunt tasks

<a name="installation"></a>
<h2 id="installation">Installation</h2>

Plugin can be installed using Node Package Manager (`npm`):
```bash
    npm install afp2any
```

<a name="configuration"></a>
<h2 id="configuration">Configuration</h2>

Plugin configuration is maintained in conf/afp2any.json. It contains the following properties.

|Property Name|Description|
|:--:|:--|
|module|Name of the plugin|
|enable|Enable Flag. Values: on\|off. Default is 'off'|
|logLevel|Plugin Log Level. Values: DEBUG\|INFO\|ERROR. Default is 'INFO'|
|routes|Array of Routes|
|name|AFP2web server host name or IP Address|
|port|AFP2web server listening port|
|logging|AFP2web Server logging. Values. on\|off. Default is 'off'|

### afp2any.json

```json
{
    "module":   "Name of the plugin",
    "module":   "afp2any",
    "enable":   "on",
    "logLevel": "Available Log Levels are DEBUG|INFO|ERROR",
    "logLevel": "INFO",     
    "routes": [
    {
      "path":     "/services/afp2any/version",
      "method":   "get",
      "service":  "version"
    },
    {
      "path":     "/services/afp2any/transform",
      "method":   "post",
      "service":  "syncTransform"
    },
    {
      "path":     "/services/afp2any/asynctransform",
      "method":   "post",
      "service":  "asyncTransform"
    },
    {
      "path":     "/services/afp2any/status",
      "method":   "post",
      "service":  "getStatus"
    }
  ],

  "name":     "AFP2web Server IP Address",
  "name":     "localhost",
  "port":     "AFP2web Server Port",
  "port":     84,
  "logging":  "Turn AFP2web Server Logging On/Off/All",
  "logging":  "Off"
}
    
```
<a name="dependencies"></a>
<h2 id="dependencies">Dependencies</h2>

  * async
  * fs
  * http  
  * log4js
  * os

<a name="routes"></a>
<h2 id="routes">Routes</h2>

|Path|Description|
|:--:|:--|
|/services/afp2any/version|Gets AFP2web server version|
|/services/afp2any/transform|Used for afp2any synchronous transformation.|
|/services/afp2any/asynctransform|Start an afp2any asynchronous transformation.|
|/services/afp2any/status|Get the status of an afp2any asynchronous transformation.|

<a name="services"></a>
<h2 id="services">Services</h2>

<a name="syncTransformation"></a>
<h3 id="syncTransformation">Sync.Transformation</h3>

<a name="syncReq"></a>
<h4 id="syncReq">Request</h4>

|Name|Value|
|:--:|:--|
|Method|Post|
|URL|http://&lt;server&gt;[:&lt;port&gt;]/services/afp2any/transform|
|Content-Type|application/json|
|Parameters|Transform JSON Request Object as given below|

```json
{    
  "input":{         
    "type":     <Input type>,        
    "ownerpw":  <Owner password of input document>,            
    "userpw":   <User password of input document>,            
    "buffer":   <Input document data as Base64 encoded>    
  },
  "output":{                     
    "type":    <Output type>,        
    "ownerpw": <Owner password of output document>,            
    "userpw":  <User password of output document>,            
    "flags":   <Permission flags>        
  }
}
```
### Sample Request

```json
POST /services/afp2any/transform HTTP/1.1
Content-Type: application/json
Content-Length: 2252
Host: 192.168.10.53
{ 
    "input":{ 
        "type":     "afp",
        "ownerpw":  "",    
        "userpw":   "",
        "buffer":   "JVBERi0xLjIKJdTBweIKMS.."
    },
    "output":{             
        "type":    "pdf",
        "ownerpw": "mhtmht",    
        "userpw":  "mhtmht",    
        "flags":   "1|2|3"
    }
}
```
<a name="syncRes"></a>
<h4 id="syncRes">Response</h3>

```json
{ 
    "ResponseMessage":{ 
        "responseData":              <Output document data as Base64 encoded>,
        "responseStatus":            "Done"|"Error",  
        "responseStatusDescription": <Response Status Description>
    }
}
```

### Sample Response

```json
HTTP/1.1 200 OK
Content-Type: application/json
Content-Length: 2252
{ 
    "ResponseMessage":{ 
                "responseData":              "gVGNf0pkpPc3hPW5uo4volCe...",
                "responseStatus":            "Done",    
                "responseStatusDescription": ""
    }
}
```

<a name="asyncTransformation"></a>
<h3 id="asyncTransformation">Async.Transformation</h3>

<a name="asyncReq"></a>
<h4 id="asyncReq">Request</h4>

|Name|Value|
|:--:|:--|
|Method|Post|
|URL|http://&lt;server&gt;[:&lt;port&gt;]/services/afp2any/asynctransform|
|Content-Type|application/json|
|Parameters|Async.Transformation JSON Request Object as given below|

```json
{
    "input":{ 
        "type":     <must always be "asyncafp">,
        "document": <Name of the input file name>
    },
    "output":{             
        "type":    <Output type>,
        "ownerpw": <Owner password of output document>,
        "userpw":  <User password of output document>,    
        "flags":   <Permission flags>    
    }
}
```
### Sample Request

```json
POST /services/afp2any/asynctransform HTTP/1.1
Content-Type: application/json
Content-Length: 2252
Host: 192.168.10.53
{ 
    "input":{ 
        "type":     "asyncafp",
        "document": "var/lib/apache2/fcgid/a2wserver/samples/bigfile.afp"
    },
    "output":{             
        "type":    "pdf"
  }
}
```

<a name="asyncRes"></a>
<h4 id="asyncRes">Response</h4>

```json
{ 
    "ResponseMessage":{ 
        "responseData":        <Unique JobId of the asynchronous transformation. Used with the Status request to get the status>,
        "responseStatus":      "Done"|"Error"|"Working",  
        "responseStatusDescription": <Response Status Description>
    }
}
```

### Sample Response

```json
HTTP/1.1 200 OK
Content-Type: application/json
Content-Length: 2252
{ 
    "ResponseMessage":{ 
                "responseData":              "gVGNf0pkpPc3hPW5uo4volCe...",
                "responseStatus":            "Working",    
                "responseStatusDescription": ""
    }
}
```

<a name="jobStatus"></a>
<h3 id="jobStatus">Job Status</h3>

<a name="jobReq"></a>
<h4 id="jobReq">Request</h4>

|Name|Value|
|:--:|:--|
|Method|Post|
|URL|http://&lt;server&gt;[:&lt;port&gt;]/services/afp2any/status|
|Content-Type|application/json|
|Parameters|Job Status JSON Request Object as given below|

```json
{
    "input":{ 
        "type":  "asyncafp",
        "jobId": <Unique JobId of the asynchronous transformation>,
    },
    "output":{             
        "type": "status"
    }
}
```
### Sample Request

```json
POST /services/afp2any/status HTTP/1.1
Content-Type: application/json
Content-Length: 2252
Host: 192.168.10.53
{ 
    "input":{ 
        "type":    "asyncafp",
        "jobId: "141008190201709"
    },
    "output":{             
        "type": "status"
    }
}
```

<a name="jobRes"></a>
<h4 id="jobRes">Response</h4>

```json
{ 
   "ResponseMessage":{ 
         "responseData":               <Unique JobId of the asynchronous transformation>,
         "responseStatus":             "Done"|"Error"|"Working",  
         "responseStatusDescription":  <Response Status Description>
   }
}
```

### Sample Response

```json
HTTP/1.1 200 OK
Content-Type: application/json
Content-Length: 2252
{ 
    "ResponseMessage":{ 
         "responseData":              "141008190201709",
         "responseStatus":            "Done",    
         "responseStatusDescription": ""
    }
} 
```
<a name="download"></a>
<h2 id="download">Download</h2>

The source is available for download from
[SVN](https://development.oxseed.net/svn/AFP2web/OXSNPS/base/plugins/afp2any/trunk).



