/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.managers;

import de.maas.oxseed.office2any.DcomConstants;
import de.maas.oxseed.office2any.exceptions.MSOfficeManagerException;
import de.maas.oxseed.office2any.managers.MSOfficeDcomManager;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class MSWordDcomManager
extends MSOfficeDcomManager {
    public static Logger logger = Logger.getLogger(MSWordDcomManager.class);
    private boolean bAllowPixelUnitsDefValue = true;

    public MSWordDcomManager(String host, String domain, String username, String password) throws MSOfficeManagerException {
        try {
            this.session = JISession.createSession((String)domain, (String)username, (String)password);
            this.comStub = new JIComServer(JIProgId.valueOf((String)"Word.Application"), host, this.session);
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
        catch (UnknownHostException e) {
            throw new MSOfficeManagerException(e);
        }
        this.start();
    }

    protected void start() throws MSOfficeManagerException {
        try {
            try {
                Thread.sleep(DcomConstants.DCOM_SYSTEM_DELAY);
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.unknown = this.comStub.createInstance();
            this.dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)this.unknown.queryInterface("00020400-0000-0000-c000-000000000046"));
            int dispId = this.dispatch.getIDsOfNames("DisplayAlerts");
            JIVariant variant = new JIVariant((Object)Boolean.FALSE);
            this.dispatch.put(dispId, variant);
            JIVariant optionsVariantTmp = this.dispatch.get("Options");
            IJIDispatch optionsTmp = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)optionsVariantTmp.getObjectAsComObject());
            JIVariant allowPixelUnitsTmp = optionsTmp.get("AllowPixelUnits");
            this.bAllowPixelUnitsDefValue = allowPixelUnitsTmp.getObjectAsBoolean();
            logger.debug((Object)("DOC : Default value of AllowPixelUnits property:" + this.bAllowPixelUnitsDefValue));
            if (logger.isDebugEnabled()) {
                this.logAppProperties();
            }
            logger.debug((Object)"DOC : Application started.");
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    public void openFile(String fileName, String password) throws MSOfficeManagerException {
        try {
            logger.debug((Object)("DOC: CALL open file : " + fileName + "."));
            JIVariant variant = this.dispatch.get("Documents");
            IJIDispatch documents = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            JIString filePath = new JIString(fileName);
            JIVariant variantBool = new JIVariant((Object)Boolean.TRUE);
            JIString variantPassword = new JIString(password);
            JIVariant[] variant2 = documents.callMethodA("open", new Object[]{filePath.VariantByRef, JIVariant.OPTIONAL_PARAM(), variantBool, JIVariant.OPTIONAL_PARAM(), variantPassword, JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            this.document = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant2[0].getObjectAsComObject());
            if (this.document != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("DOC: File " + fileName + " opened."));
                }
                this.fileName = fileName;
                this.document.callMethodA("Activate");
                logger.debug((Object)("DOC: File " + fileName + " is activated"));
                this.setAllowPixelUnitsProperty(true);
            } else {
                logger.error((Object)("DOC: File " + fileName + " not opened."));
            }
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    public void setLandscape(boolean landscape) throws MSOfficeManagerException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DOC: CALL SetLandscape=" + landscape + "."));
            }
            if (this.fileName == null || this.fileName == "") {
                logger.warn((Object)"DOC: No one opened document");
                return;
            }
            if (this.document == null) {
                logger.warn((Object)("DOC: No one assigned document to " + this.fileName));
                return;
            }
            JIVariant variant = this.document.get("PageSetup");
            IJIDispatch pageSetup = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            int var = 0;
            if (landscape) {
                var = 1;
            }
            pageSetup.put("Orientation", new Object[]{new Integer(var)});
            logger.debug((Object)("DOC: SetLandscape=" + landscape + " done for file " + this.fileName));
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    protected void saveAsPdf(String outputFileName) throws MSOfficeManagerException {
        try {
            Long time = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DOC: CALL save " + outputFileName + "."));
            }
            JIString fileSave = new JIString(outputFileName);
            JIVariant[] variant = this.document.callMethodA("SaveAs", new Object[]{fileSave.VariantByRef, new Integer(17), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            Long time2 = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DOC: File " + outputFileName + " saved. Time (ms)=" + (time2 - time)));
            }
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    protected void saveAsTif(String outputFileName) throws MSOfficeManagerException {
        try {
            Long time = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DOC: CALL save " + outputFileName + "."));
            }
            JIString fileSave = new JIString(outputFileName);
            JIVariant[] variant3 = this.document.callMethodA("PrintOut", new Object[]{JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), fileSave.VariantByRef, JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            Long time2 = System.currentTimeMillis();
            logger.debug((Object)("DOC: File " + outputFileName + " sended on printer. Time (ms)=" + (time2 - time)));
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    public void close() throws MSOfficeManagerException {
        try {
            logger.debug((Object)"CALL Quit Word");
            JIVariant[] variant3 = this.dispatch.callMethodA("Quit", new Object[]{new JIVariant(-1, false), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
            JISession.destroySession((JISession)this.session);
            logger.debug((Object)"Session destroyed.");
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    public void closeOpenedFile() throws MSOfficeManagerException {
        try {
            logger.debug((Object)("DOC: CALL Close Document Word " + this.fileName));
            this.setAllowPixelUnitsProperty(this.bAllowPixelUnitsDefValue);
            if (this.document != null) {
                JIVariant[] variant3 = this.document.callMethodA("Close", new Object[]{new Integer(0), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
                logger.debug((Object)("DOC: Document " + this.fileName + " closed."));
                this.document = null;
                this.fileName = null;
            } else {
                logger.debug((Object)"DOC: closeOpenedFile() : No one opened document.");
            }
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    protected void autoboxDataInWidth() {
        throw new UnsupportedOperationException("Word does not support autobox.");
    }

    public boolean supportPrintQuality() {
        return false;
    }

    public void setHorizontalPrintQuality(double horizontalPrintQuality) {
        throw new UnsupportedOperationException("Word does not support autobox.");
    }

    public void setVerticalPrintQuality(double verticalPrintQuality) {
        throw new UnsupportedOperationException("Word does not support autobox.");
    }

    private void setAllowPixelUnitsProperty(boolean bValuePar) throws MSOfficeManagerException {
        try {
            if (this.dispatch == null) {
                throw new MSOfficeManagerException("Word application dispatch handle is null");
            }
            JIVariant variant = this.dispatch.get("Options");
            if (variant == null) {
                throw new MSOfficeManagerException("Error while getting Word application options object handle");
            }
            IJIDispatch options = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            options.put("AllowPixelUnits", new JIVariant(bValuePar));
            logger.debug((Object)("AllowPixelUnits property set to " + bValuePar));
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }

    private void logAppProperties() throws MSOfficeManagerException {
        try {
            logger.debug((Object)"Application Properties:");
            logger.debug((Object)"***********************");
            JIVariant variant = this.dispatch.get("Options");
            IJIDispatch options = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)variant.getObjectAsComObject());
            JIVariant allowPixelUnits = options.get("AllowPixelUnits");
            boolean bAllowPixelUnits = allowPixelUnits.getObjectAsBoolean();
            logger.debug((Object)("AllowPixelUnits:" + bAllowPixelUnits));
            JIVariant measurementUnit = options.get("MeasurementUnit");
            int iMeasurementUnit = measurementUnit.getObjectAsInt();
            logger.debug((Object)("MeasurementUnit:" + iMeasurementUnit));
            JIVariant mapPaperSize = options.get("MapPaperSize");
            boolean bMapPaperSize = mapPaperSize.getObjectAsBoolean();
            logger.debug((Object)("MapPaperSize:" + bMapPaperSize));
            JIVariant optimizeForWord97byDefault = options.get("OptimizeForWord97byDefault");
            boolean boptimizeForWord97byDefault = optimizeForWord97byDefault.getObjectAsBoolean();
            logger.debug((Object)("OptimizeForWord97byDefault:" + boptimizeForWord97byDefault));
            JIVariant pagination = options.get("Pagination");
            boolean bPagination = pagination.getObjectAsBoolean();
            logger.debug((Object)("pagination:" + bPagination));
            JIVariant precisePositioning = options.get("PrecisePositioning");
            boolean bPrecisePositioning = precisePositioning.getObjectAsBoolean();
            logger.debug((Object)("PrecisePositioning:" + bPrecisePositioning));
            JIVariant printBackground = options.get("PrintBackground");
            boolean bPrintBackground = printBackground.getObjectAsBoolean();
            logger.debug((Object)("PrintBackground:" + bPrintBackground));
            JIVariant printBackgrounds = options.get("PrintBackgrounds");
            boolean bPrintBackgrounds = printBackgrounds.getObjectAsBoolean();
            logger.debug((Object)("PrintBackgrounds:" + bPrintBackgrounds));
            JIVariant updateFieldsAtPrint = options.get("UpdateFieldsAtPrint");
            boolean bUpdateFieldsAtPrint = updateFieldsAtPrint.getObjectAsBoolean();
            logger.debug((Object)("UpdateFieldsAtPrint:" + bUpdateFieldsAtPrint));
            JIVariant useCharacterUnit = options.get("UseCharacterUnit");
            boolean bUseCharacterUnit = useCharacterUnit.getObjectAsBoolean();
            logger.debug((Object)("UseCharacterUnit:" + bUseCharacterUnit));
            if (this.document != null) {
                JIVariant defVariant = this.document.get("WebOptions");
                IJIDispatch defWebOptions = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)defVariant.getObjectAsComObject());
                JIVariant relyOnCSS = defWebOptions.get("RelyOnCSS");
                boolean bRelyOnCSS = relyOnCSS.getObjectAsBoolean();
                logger.debug((Object)("RelyOnCSS:" + bRelyOnCSS));
            }
        }
        catch (JIException e) {
            throw new MSOfficeManagerException(e);
        }
    }
}

