/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.storage;

import de.maas.oxseed.office2any.exceptions.StorageException;
import de.maas.oxseed.office2any.storage.FilesystemStorageFile;
import de.maas.oxseed.office2any.storage.Storage;
import de.maas.oxseed.office2any.storage.StorageFile;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class FileStorage
extends Storage {
    public static synchronized Storage getInstance(String url) throws MalformedURLException {
        Storage shareToReturn = null;
        if (openShares.containsKey(url)) {
            shareToReturn = (Storage)openShares.get(url);
        } else {
            shareToReturn = new FileStorage(url);
            openShares.put(url, shareToReturn);
            if (log.isDebugEnabled()) {
                log.debug((Object)("FileShare(" + url + ") was created"));
            }
        }
        shareToReturn.addUser();
        return shareToReturn;
    }

    protected FileStorage(String url) throws MalformedURLException {
        this.url = url;
    }

    public StorageFile getStorageFile(String filePath) throws StorageException {
        try {
            String fileUrl = this.url;
            fileUrl = fileUrl.endsWith("/") ? fileUrl + filePath : fileUrl + '/' + filePath;
            FilesystemStorageFile file = new FilesystemStorageFile(new URL(fileUrl).getFile());
            return file;
        }
        catch (MalformedURLException e) {
            throw new StorageException(e);
        }
    }

    public String getLocalStoragePath() throws StorageException {
        try {
            String urlShare = new URL(this.url).getFile();
            String sharePath = new File(urlShare).getAbsolutePath();
            return sharePath;
        }
        catch (MalformedURLException e) {
            throw new StorageException(e);
        }
    }
}

