/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any.storage;

import de.maas.oxseed.office2any.exceptions.StorageException;
import de.maas.oxseed.office2any.storage.SambaStorageFile;
import de.maas.oxseed.office2any.storage.Storage;
import de.maas.oxseed.office2any.storage.StorageFile;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Properties;
import jcifs.Config;
import jcifs.smb.Handler;
import org.apache.log4j.Logger;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.JIDefaultAuthInfoImpl;
import org.jinterop.dcom.common.JIException;
import org.jinterop.winreg.IJIWinReg;
import org.jinterop.winreg.JIPolicyHandle;
import org.jinterop.winreg.JIWinRegFactory;

public class SambaStorage
extends Storage {
    public static final Logger logger = Logger.getLogger(SambaStorage.class);
    public static final URLStreamHandler SMB_HANDLER = new Handler();
    protected String domain;

    public static synchronized Storage getInstance(String url, String domain) throws MalformedURLException {
        Storage shareToReturn = null;
        if (openShares.containsKey(url)) {
            shareToReturn = (Storage)openShares.get(url);
        } else {
            shareToReturn = new SambaStorage(url, domain);
            openShares.put(url, shareToReturn);
            log.debug((Object)("SambaShare(" + url + ") was created"));
        }
        shareToReturn.addUser();
        return shareToReturn;
    }

    public static synchronized Storage getInstance(String url, String defaultUser, String defaultPassword, String domain) throws MalformedURLException {
        URL urlShare = new URL(null, url, SMB_HANDLER);
        logger.debug((Object)("Samba Share instance Info: url" + url + "Domain" + domain + "User:" + defaultUser + "Pwd:" + defaultPassword + "UrlUserInfo" + urlShare.getUserInfo()));
        if (urlShare.getUserInfo() == null || urlShare.getUserInfo().equals("")) {
            StringBuilder sb = new StringBuilder();
            if (defaultUser != null && defaultUser.length() > 0) {
                sb.append(defaultUser);
                if (defaultPassword != null && defaultPassword.length() > 0) {
                    sb.append(':').append(defaultPassword);
                }
                sb.append('@');
            }
            String userInfo = sb.toString();
            String newUrlString = urlShare.getProtocol() + "://" + userInfo + urlShare.getAuthority() + urlShare.getFile();
            logger.debug((Object)("Using url to share : " + newUrlString));
            url = newUrlString;
        }
        return SambaStorage.getInstance(url, domain);
    }

    protected SambaStorage(String url, String domain) {
        this.url = url;
        this.domain = domain;
    }

    public StorageFile getStorageFile(String filePath) throws StorageException {
        if (this.url.endsWith("/")) {
            return new SambaStorageFile(this.url + filePath);
        }
        return new SambaStorageFile(this.url + '/' + filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getLocalStoragePath() throws StorageException {
        Object urlShare;
        IJIWinReg registry = null;
        try {
            try {
                if (this.localSharePath == null) {
                    urlShare = new URL(null, this.url, SMB_HANDLER);
                    String host = ((URL)urlShare).getHost();
                    String domain = this.domain;
                    String userInfo = ((URL)urlShare).getUserInfo();
                    String[] userInfoSplitted = userInfo.split(":");
                    String username = userInfoSplitted[0];
                    String password = userInfoSplitted[1];
                    JIDefaultAuthInfoImpl authInfo = new JIDefaultAuthInfoImpl(domain, username, password);
                    registry = JIWinRegFactory.getSingleTon().getWinreg((IJIAuthInfo)authInfo, host, true);
                    JIPolicyHandle policyHandle = registry.winreg_OpenHKLM();
                    JIPolicyHandle policyHandle2 = registry.winreg_OpenKey(policyHandle, "System\\CurrentControlSet\\Services\\lanmanserver\\Shares", 131097);
                    String shareName = this.url.substring(7);
                    if (shareName.indexOf("/") >= 0) {
                        shareName = shareName.substring(shareName.indexOf(47) + 1);
                    }
                    if (shareName.lastIndexOf("/") == shareName.length() - 1) {
                        shareName = shareName.substring(0, shareName.length() - 1);
                    }
                    Object[] values = registry.winreg_QueryValue(policyHandle2, shareName, 1024);
                    Properties properties = new Properties();
                    byte[][] data = (byte[][])values[1];
                    String s = "";
                    for (int i = 0; i < data.length && s != null; ++i) {
                        s = null;
                        try {
                            s = new String(data[i]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (s == null) continue;
                        String key = s.substring(0, s.indexOf(61));
                        String value = s.substring(s.indexOf(61) + 1);
                        properties.setProperty(key, value);
                    }
                    this.localSharePath = (String)properties.get("Path");
                }
                urlShare = this.localSharePath;
                Object var21_23 = null;
                if (registry == null) return urlShare;
            }
            catch (JIException e) {
                throw new StorageException(e);
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var21_24 = null;
            if (registry == null) throw throwable;
            try {
                registry.closeConnection();
                throw throwable;
            }
            catch (JIException e) {
                logger.warn((Object)("Error while closing Registry Connection. ErrorMsg:" + (Object)((Object)e)));
                throw throwable;
            }
        }
        try {}
        catch (JIException e) {
            logger.warn((Object)("Error while closing Registry Connection. ErrorMsg:" + (Object)((Object)e)));
            return urlShare;
        }
        registry.closeConnection();
        return urlShare;
    }

    static {
        Config.registerSmbURLHandler();
    }
}

