/*
 * Decompiled with CFR 0.152.
 */
package de.maas.oxseed.office2any;

import de.maas.oxseed.office2any.MSOffice2007Constants;
import de.maas.oxseed.office2any.exceptions.MSOffice2007UnsupportedFormatException;
import java.util.HashMap;
import java.util.Map;

public class MSOffice2007Shared
implements MSOffice2007Constants {
    protected static long OUT_MIME_TIF_IMAGE;
    protected static long CONTENT_TYPE_HTM_DEFAULT;
    protected static Map<Long, String> contentTypesMap;
    protected static Map<Long, String> outMimeTypesMap;

    public static long getContentTypeByExtension(String extension) throws MSOffice2007UnsupportedFormatException {
        for (Map.Entry<Long, String> entry : contentTypesMap.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(extension)) continue;
            return entry.getKey() & 0xFFFFL;
        }
        throw new MSOffice2007UnsupportedFormatException(extension + " is unknown type");
    }

    public static String getExtensionByContentType(long contentType) throws MSOffice2007UnsupportedFormatException {
        long contentTypeClean = contentType & 0xFFFL;
        String extension = contentTypesMap.get(contentTypeClean);
        if (extension != null) {
            return extension;
        }
        throw new MSOffice2007UnsupportedFormatException("ContentType=" + contentTypeClean + "(" + contentType + ") is unknown");
    }

    public static long getOutMimeTypeByExtension(String extension) throws MSOffice2007UnsupportedFormatException {
        for (Map.Entry<Long, String> entry : outMimeTypesMap.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(extension)) continue;
            return entry.getKey() & 0xFL;
        }
        throw new MSOffice2007UnsupportedFormatException(extension + " is unknown outMimeType");
    }

    public static String getExtensionByOutMimeType(long outMimeType) throws MSOffice2007UnsupportedFormatException {
        long outMimeTypeClean = outMimeType & 0xFFL;
        String extension = outMimeTypesMap.get(outMimeTypeClean);
        if (extension != null) {
            return extension;
        }
        throw new MSOffice2007UnsupportedFormatException("OutMimeType=" + outMimeTypeClean + "(" + outMimeType + ") is unknown");
    }

    static {
        int i;
        OUT_MIME_TIF_IMAGE = 0x10000002L;
        CONTENT_TYPE_HTM_DEFAULT = 0x10000100L;
        String[][] contentTypes = new String[][]{{"1", "doc"}, {"2", "docx"}, {"16", "xls"}, {"32", "xlsx"}, {"3", "rtf"}, {"4", "txt"}, {"256", "html"}, {"" + CONTENT_TYPE_HTM_DEFAULT, "htm"}, {"512", "mht"}};
        contentTypesMap = new HashMap<Long, String>();
        for (i = 0; i < contentTypes.length; ++i) {
            contentTypesMap.put(Long.parseLong(contentTypes[i][0]), contentTypes[i][1]);
        }
        String[][] outMimeTypes = new String[][]{{"1", "pdf"}, {"2", "tiff"}, {"" + OUT_MIME_TIF_IMAGE, "tif"}};
        outMimeTypesMap = new HashMap<Long, String>();
        for (i = 0; i < outMimeTypes.length; ++i) {
            outMimeTypesMap.put(Long.parseLong(outMimeTypes[i][0]), outMimeTypes[i][1]);
        }
    }
}

