/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.box;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codecimpl.JPEGImageEncoder;
import de.maas.saas.pdf.PDFThumbnail;
import de.maas.saas.pdf.PDFThumbnailException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;

public class PDF2Thumbnail {
    private int maxWidth;
    private int maxHeight;

    public static PDF2Thumbnail getInstance(int maxWidth, int maxHeight) {
        return new PDF2Thumbnail(maxWidth, maxHeight);
    }

    protected PDF2Thumbnail(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public PDFThumbnail createPDFThumbnail(InputStream pdfIS, int page) throws PDFThumbnailException {
        PdfDecoder decoder = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buff = new byte[2048];
            while ((len = pdfIS.read(buff)) != -1) {
                baos.write(buff, 0, len);
            }
            baos.flush();
            decoder = new PdfDecoder(true);
            decoder.openPdfArray(baos.toByteArray());
            if (decoder.isFileViewable()) {
                PDFThumbnail pDFThumbnail = PDF2Thumbnail.createJPGThumbnailFromImage(this.maxWidth, this.maxHeight, decoder.getPageAsImage(page + 1));
                return pDFThumbnail;
            }
            try {
                throw new PDFThumbnailException("Couldn't create thumbnail - pdf is not viewable");
            }
            catch (PdfException e) {
                throw new PDFThumbnailException(e);
            }
            catch (IOException e) {
                throw new PDFThumbnailException(e);
            }
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (decoder != null) {
                    decoder.closePdfFile();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public PDFThumbnail createPDFThumbnail(InputStream pdfIS) throws PDFThumbnailException {
        return this.createPDFThumbnail(pdfIS, 0);
    }

    public static PDFThumbnail createJPGThumbnailFromImage(int maxWidth, int maxHeight, BufferedImage image) throws PDFThumbnailException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            double scale = 0.6f;
            int smoothWidth = image.getWidth();
            int smoothHeight = image.getHeight();
            scale = (float)maxWidth / (float)smoothWidth;
            if ((double)smoothHeight * scale > (double)maxHeight) {
                scale = (float)maxHeight / (float)smoothHeight;
            }
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(scale);
            pb.add(scale);
            RenderedOp scaledImage = JAI.create((String)"SubsampleAverage", (ParameterBlock)pb);
            JPEGEncodeParam jpgEncodeParam = new JPEGEncodeParam();
            jpgEncodeParam.setQuality(0.8f);
            JPEGImageEncoder jpgImageEncoder = new JPEGImageEncoder((OutputStream)baos, (ImageEncodeParam)jpgEncodeParam);
            jpgImageEncoder.encode((RenderedImage)scaledImage);
            baos.flush();
            PDFThumbnail pDFThumbnail = new PDFThumbnail(maxWidth, maxHeight, baos.toByteArray(), PDFThumbnail.PDFThumbnailFormat.JPG);
            return pDFThumbnail;
        }
        catch (ImageFormatException e) {
            throw new PDFThumbnailException("Couldn't get image from PDF page", e);
        }
        catch (IOException e) {
            throw new PDFThumbnailException("Couldn't get image from PDF page", e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ignored) {}
        }
    }

    private static final byte clampByte(int i) {
        if (i > 255) {
            return -1;
        }
        if (i < 0) {
            return 0;
        }
        return (byte)i;
    }
}

