/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.pdf.text;

import de.maas.saas.data.Segment;
import de.maas.saas.pdf.PDFWord;
import java.awt.Rectangle;
import java.io.IOException;
import org.pdfbox.pdmodel.font.PDFont;

class PDFWordImpl
implements PDFWord {
    private Rectangle bounds;
    private String text;
    private String wordSpace = "";
    private PDFont font;
    private float fontSize;
    private Segment segment = null;
    private boolean flagSegment = false;

    PDFWordImpl() {
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setWordSpace() {
        this.wordSpace = this.wordSpace + " ";
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public String getText() {
        return this.getWordWithSpacing();
    }

    public String getWordWithSpacing() {
        if (this.wordSpace.length() > 0) {
            return this.wordSpace + this.text;
        }
        return this.text;
    }

    public PDFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public Segment toSegment() throws IOException {
        if (this.flagSegment) {
            return this.segment;
        }
        this.segment = new Segment();
        this.segment.setVerified(this.text);
        this.segment.setFontStyle(this.font.getBaseFont());
        this.segment.setFontThickness(this.font.getFontBoundingBox().getWidth());
        this.segment.setX(this.bounds.x);
        this.segment.setY(this.bounds.y);
        this.segment.setW(this.bounds.width);
        this.segment.setH(this.bounds.height);
        this.flagSegment = true;
        return this.segment;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.text).append("[").append(this.bounds.x).append(",");
        buffer.append(this.bounds.y).append(",");
        buffer.append(this.bounds.width).append(",");
        buffer.append(this.bounds.height).append("]");
        return buffer.toString();
    }
}

