/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import de.maas.saas.tiff.reader.IFDEntry;
import de.maas.saas.tiff.reader.TiffStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class StripByteData {
    private byte[] stripData = null;
    private byte[] tileData = null;
    private IFDEntry stripByteCountsEntry = null;
    private IFDEntry stripOffsetsEntry = null;
    private IFDEntry tileOffsets = null;
    private IFDEntry tileByteCounts = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StripByteData newInstance(TiffStream tiffStream, IFDEntry stripOffsetsEntry, IFDEntry stripByteCountsEntry, IFDEntry tileOffsetsEntry, IFDEntry tileByteCountsEntry) throws IOException {
        int valueLength;
        int valueOffset;
        int i;
        ByteArrayOutputStream stripData = null;
        ByteArrayOutputStream tileData = null;
        byte[] stripArray = null;
        byte[] tileArray = null;
        if (stripOffsetsEntry != null && stripByteCountsEntry != null) {
            int[] stripOffsetsValue = stripOffsetsEntry.getValue();
            int[] stripBytesCountsValue = stripByteCountsEntry.getValue();
            stripData = new ByteArrayOutputStream();
            try {
                for (i = 0; i < stripOffsetsValue.length; ++i) {
                    valueOffset = stripOffsetsValue[i];
                    valueLength = stripBytesCountsValue[i];
                    stripData.write(tiffStream.getBytes(valueOffset, valueOffset + valueLength));
                }
                if (stripData != null) {
                    stripArray = stripData.toByteArray();
                }
            }
            finally {
                stripData.close();
            }
        }
        if (tileOffsetsEntry != null && tileByteCountsEntry != null) {
            int[] tileOffsetValue = tileOffsetsEntry.getValue();
            int[] tileByteCountsValue = tileByteCountsEntry.getValue();
            tileData = new ByteArrayOutputStream();
            try {
                for (i = 0; i < tileOffsetValue.length; ++i) {
                    valueOffset = tileOffsetValue[i];
                    valueLength = tileByteCountsValue[i];
                    tileData.write(tiffStream.getBytes(valueOffset, valueOffset + valueLength));
                }
                if (tileData != null) {
                    tileArray = tileData.toByteArray();
                }
            }
            finally {
                tileData.close();
            }
        }
        return new StripByteData(stripArray, tileArray, stripByteCountsEntry, stripOffsetsEntry, tileOffsetsEntry, tileByteCountsEntry);
    }

    private StripByteData(byte[] stripData, byte[] tileData, IFDEntry stripByteCountsEntry, IFDEntry stripOffsetsEntry, IFDEntry tileOffsetsEntry, IFDEntry tileByteCountsEntry) {
        this.stripData = stripData;
        this.tileData = tileData;
        this.stripByteCountsEntry = stripByteCountsEntry;
        this.stripOffsetsEntry = stripOffsetsEntry;
        this.tileByteCounts = tileByteCountsEntry;
        this.tileOffsets = tileOffsetsEntry;
    }

    public byte[] getStripsData() {
        return this.stripData;
    }

    public byte[] getTileData() {
        return this.tileData;
    }

    public IFDEntry getStripByteCounts() {
        return this.stripByteCountsEntry;
    }

    public IFDEntry getStripOffsets() {
        return this.stripOffsetsEntry;
    }

    public IFDEntry getTileOffsets() {
        return this.tileOffsets;
    }

    public IFDEntry getTileByteCounts() {
        return this.tileByteCounts;
    }
}

