/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.reader;

import de.maas.saas.tiff.TiffImage;
import de.maas.saas.tiff.TiffReaderException;
import de.maas.saas.tiff.reader.IFD;
import de.maas.saas.tiff.reader.IFDEntry;
import de.maas.saas.tiff.reader.IFDName;
import de.maas.saas.tiff.reader.StripBytesReverse;
import de.maas.saas.tiff.reader.TiffHeader;
import java.io.IOException;
import javax.naming.directory.NoSuchAttributeException;

class TiffImageImpl
implements TiffImage {
    TiffHeader header = null;
    IFD ifd = null;
    private boolean checkWidth = false;
    private boolean checkHeight = false;
    private IFD.SizeType sizeType = IFD.SizeType.INCH;
    private float width;
    private float height;

    TiffImageImpl(TiffHeader header, IFD ifd) {
        this.ifd = ifd;
        this.header = header;
        this.setSizeType(ifd.sizeType);
    }

    public byte[] getImageData() throws IOException, TiffReaderException {
        IFDEntry fillOrder = this.ifd.directoryEntries.get((Object)IFDName.FillOrder);
        return StripBytesReverse.getSingletonInstance().getTiffImageData(this.ifd.stripByteData, fillOrder);
    }

    public float getXRes() {
        return this.ifd.XRes;
    }

    public float getYRes() {
        return this.ifd.YRes;
    }

    void setSizeType(IFD.SizeType sizeType) {
        this.sizeType = sizeType;
        this.checkWidth = false;
        this.checkHeight = false;
    }

    public float getOriginalWidth() throws NoSuchAttributeException {
        if (this.checkWidth) {
            return this.width;
        }
        this.checkWidth = true;
        float xres = this.getXRes();
        this.width = this.ifd.directoryEntries.get((Object)IFDName.ImageWidth).getValueOrOffset();
        switch (this.sizeType) {
            case PIXEL: {
                return this.width;
            }
            case INCH: {
                this.width = this.width / xres * 72.0f;
                return this.width;
            }
            case CENTIMETER: {
                this.width = this.width / xres / 2.54f * 72.0f;
                return this.width;
            }
        }
        this.checkWidth = false;
        throw new NoSuchAttributeException("There is no such type of size: " + (Object)((Object)this.sizeType));
    }

    public float getOriginalHeight() throws NoSuchAttributeException {
        if (this.checkHeight) {
            return this.height;
        }
        this.checkHeight = true;
        float yres = this.getYRes();
        this.height = this.ifd.directoryEntries.get((Object)IFDName.ImageLength).getValueOrOffset();
        switch (this.sizeType) {
            case PIXEL: {
                return this.height;
            }
            case INCH: {
                this.height = this.height / yres * 72.0f;
                return this.height;
            }
            case CENTIMETER: {
                this.height = this.height / yres / 2.54f * 72.0f;
                return this.height;
            }
        }
        this.checkHeight = false;
        throw new NoSuchAttributeException("There is no such type of size: " + (Object)((Object)this.sizeType));
    }

    public byte[] toByteArray() throws IOException, TiffReaderException {
        return null;
    }
}

