/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.tiff.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamUtil {
    public static List<byte[]> getBytes(byte[] bufferImageData, int[] offsets, int[] offsetsCount) {
        ArrayList<byte[]> b = new ArrayList<byte[]>();
        for (int i = 0; i < offsets.length; ++i) {
            byte[] bytes = new byte[offsetsCount[i]];
            int begin = offsets[i];
            for (int k = 0; k < offsetsCount[i]; ++k) {
                bytes[k] = bufferImageData[begin++];
            }
            b.add(bytes);
        }
        return b;
    }

    public static byte[] getBytes(byte[] bufferImageData, int start, int end) {
        byte[] b = new byte[end - start];
        int begin = start;
        for (int i = 0; i < b.length; ++i) {
            b[i] = bufferImageData[begin++];
        }
        return b;
    }

    public static byte[] changeValue(byte[] source, int newValue, int numberOfBytes, boolean isLittleEndian) {
        switch (numberOfBytes) {
            case 2: {
                byte i2;
                byte i1;
                if (isLittleEndian) {
                    i1 = (byte)newValue;
                    i2 = (byte)(newValue >> 8);
                } else {
                    i1 = (byte)(newValue >> 8);
                    i2 = (byte)newValue;
                }
                source[0] = i1;
                source[1] = i2;
                break;
            }
            case 4: {
                byte i4;
                byte i3;
                byte i2;
                byte i1;
                if (isLittleEndian) {
                    i1 = (byte)newValue;
                    i2 = (byte)(newValue >> 8);
                    i3 = (byte)(newValue >> 16);
                    i4 = (byte)(newValue >> 24);
                } else {
                    i1 = (byte)(newValue >> 24);
                    i2 = (byte)(newValue >> 16);
                    i3 = (byte)(newValue >> 8);
                    i4 = (byte)newValue;
                }
                source[0] = i1;
                source[1] = i2;
                source[2] = i3;
                source[3] = i4;
            }
        }
        return source;
    }

    public static int read1byte(byte[] byteValue) {
        int result = 0xFF & byteValue[0];
        return result;
    }

    public static int read2bytes(byte[] byteValue, boolean isLittleEndian) {
        int currentOffset = 0;
        int i1 = 0xFF & byteValue[currentOffset++];
        int i2 = 0xFF & byteValue[currentOffset++];
        int result = isLittleEndian ? i1 + (i2 << 8) : (i1 << 8) + i2;
        return result;
    }

    public static int read4bytes(byte[] byteValue, boolean isLittleEndian) {
        int currentOffset = 0;
        int i1 = 0xFF & byteValue[currentOffset++];
        int i2 = 0xFF & byteValue[currentOffset++];
        int i3 = 0xFF & byteValue[currentOffset++];
        int i4 = 0xFF & byteValue[currentOffset++];
        int result = isLittleEndian ? i1 + (i2 << 8) + (i3 << 16) + (i4 << 24) : i4 + (i3 << 8) + (i2 << 16) + (i1 << 24);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(InputStream source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] result = new byte[16384];
            int len = 0;
            while ((len = source.read(result)) > 0) {
                baos.write(result, 0, len);
                baos.flush();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            baos.close();
        }
    }
}

