/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.archiver;

import de.maas.saas.archiver.ArchiveResolverException;
import de.maas.saas.logger.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveResolver {
    private Log logger = (Log)LogFactory.getLog(this.getClass());
    protected FileSystemManager fsManager;

    protected ArchiveResolver() {
        try {
            this.fsManager = VFS.getManager();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Log getLog() {
        return this.logger;
    }

    protected void copyStreams(InputStream source, OutputStream target) throws IOException {
        byte[] b = new byte[16384];
        int len = 0;
        while ((len = source.read(b)) > 0) {
            target.write(b, 0, len);
            target.flush();
        }
    }

    public abstract boolean save(String var1, String var2, InputStream var3) throws ArchiveResolverException;

    public abstract InputStream load(String var1, String var2) throws ArchiveResolverException;

    public abstract URI getArchiveURILocationAsURI(String var1, String var2) throws URISyntaxException, IOException, ArchiveResolverException;

    public abstract URL getArchiveURLLocation(String var1, String var2) throws URISyntaxException, IOException, ArchiveResolverException;

    public abstract Iterator<URI> getAllAvailableArchiveURILocations(String var1) throws FileSystemException;
}

