/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.archiver;

import de.maas.saas.archiver.ObjectListParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ArchiveResolverException
extends Exception {
    private String message = null;

    public ArchiveResolverException(HttpURLConnection conn) {
        SAXParser m_parser = null;
        try {
            SAXParserFactory parserfactory = SAXParserFactory.newInstance();
            parserfactory.setNamespaceAware(false);
            parserfactory.setValidating(false);
            m_parser = parserfactory.newSAXParser();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("parser creation failed", e);
        }
        InputStream errorData = conn.getErrorStream();
        if (errorData == null) {
            return;
        }
        ObjectListParser olp = new ObjectListParser("message");
        try {
            m_parser.parse(errorData, (DefaultHandler)olp);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("SAX parser failed", e);
        }
        finally {
            try {
                errorData.close();
            }
            catch (IOException e) {}
        }
        StringBuffer buffer = new StringBuffer();
        for (String msg : olp.getList()) {
            buffer.append(msg).append("\n");
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        this.message = buffer.toString();
    }

    public ArchiveResolverException(String message) {
        super(message);
    }

    public ArchiveResolverException(Throwable cause) {
        super(cause);
    }

    public ArchiveResolverException(String message, Throwable cause) {
        super(message, cause);
    }

    public String toString() {
        String s = this.getClass().getName();
        String message = null;
        message = this.message != null ? this.message : this.getLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }
}

