/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.archiver;

import de.maas.saas.archiver.ArchiveResolver;
import de.maas.saas.archiver.ArchiveResolverException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubfolderFileArchiver
extends ArchiveResolver {
    private static final String PATH_SEPARATOR_CHAR = "/";
    private static final String FRAGMENT_SEPARATOR_CHAR = ",";
    private static final String FRAGMENT_START_CHAR = "{";
    private static final String FRAGMENT_END_CHAR = "}";
    private static final String MANDANT_PATTERN = "$mandant";
    private String subfoldersPattern = null;
    private String targetURI;

    public String getArchiveURILocation(String ID, String mandant) {
        if (mandant == null) {
            mandant = "";
        }
        StringBuffer path = new StringBuffer(this.targetURI);
        path.append(PATH_SEPARATOR_CHAR);
        path.append(this.convertTargetFragment(ID, this.subfoldersPattern));
        String result = path.toString();
        result = result.replace(MANDANT_PATTERN, mandant);
        result = result + ID;
        return result;
    }

    @Override
    public URI getArchiveURILocationAsURI(String ID, String mandant) throws URISyntaxException, IOException, ArchiveResolverException {
        String archiveLocation = this.getArchiveURILocation(ID, mandant);
        return new URI(archiveLocation);
    }

    @Override
    public URL getArchiveURLLocation(String ID, String mandant) throws URISyntaxException, IOException, ArchiveResolverException {
        return this.getArchiveURILocationAsURI(ID, mandant).toURL();
    }

    @Override
    public Iterator<URI> getAllAvailableArchiveURILocations(String mandant) throws FileSystemException {
        if (mandant == null) {
            mandant = "";
        }
        StringBuffer path = new StringBuffer(this.targetURI);
        path.append(PATH_SEPARATOR_CHAR);
        String mandantFolderURI = this.targetURI.replace(MANDANT_PATTERN, mandant);
        FileObject fo = this.fsManager.resolveFile(mandantFolderURI);
        return new FolderIterator(fo);
    }

    private String convertTargetFragment(String strObjectIdPar, String strTargetFragmentPar) {
        if (strTargetFragmentPar == null) {
            return strObjectIdPar;
        }
        StringBuffer strbTargetFragment = new StringBuffer();
        StringTokenizer strTokenizerTmp = new StringTokenizer(strTargetFragmentPar, PATH_SEPARATOR_CHAR);
        while (strTokenizerTmp.hasMoreElements()) {
            strbTargetFragment.append(this.convertFragment(strObjectIdPar, strTokenizerTmp.nextToken()));
            strbTargetFragment.append(PATH_SEPARATOR_CHAR);
        }
        return strbTargetFragment.toString();
    }

    private String convertFragment(String strObjectIdPar, String strTargetfragmentPar) {
        int iStartIndexTmp = 0;
        int iEndIndexTmp = 0;
        String strStartIndexTmp = null;
        String strEndIndexTmp = null;
        int iFragmentStart = strTargetfragmentPar.indexOf(FRAGMENT_START_CHAR) + 1;
        int iFragmentEnd = strTargetfragmentPar.indexOf(FRAGMENT_SEPARATOR_CHAR);
        strStartIndexTmp = strTargetfragmentPar.substring(iFragmentStart, iFragmentEnd);
        iStartIndexTmp = Integer.parseInt(strStartIndexTmp);
        strEndIndexTmp = strTargetfragmentPar.substring(strTargetfragmentPar.indexOf(FRAGMENT_SEPARATOR_CHAR) + 1, strTargetfragmentPar.indexOf(FRAGMENT_END_CHAR));
        iEndIndexTmp = Integer.parseInt(strEndIndexTmp);
        return strObjectIdPar.substring(iStartIndexTmp, iStartIndexTmp + iEndIndexTmp);
    }

    @Override
    public InputStream load(String ID, String mandant) throws ArchiveResolverException {
        String fileURI = this.getArchiveURILocation(ID, mandant);
        try {
            if (fileURI.startsWith("file")) {
                return this.loadLocalFile(fileURI);
            }
            return this.loadFromFileObject(fileURI);
        }
        catch (IOException e) {
            throw new ArchiveResolverException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveResolverException(e.getMessage(), e);
        }
    }

    private InputStream loadFromFileObject(String fileURI) throws IOException {
        FileObject fObject = this.fsManager.resolveFile(fileURI);
        fObject.refresh();
        return fObject.getContent().getInputStream();
    }

    private InputStream loadLocalFile(String fileURI) throws IOException, URISyntaxException {
        return new BufferedInputStream(new FileInputStream(new File(new URI(fileURI))));
    }

    @Override
    public boolean save(String ID, String mandant, InputStream source) throws ArchiveResolverException {
        FileObject fObject = null;
        OutputStream target = null;
        String fileURI = this.getArchiveURILocation(ID, mandant);
        try {
            fObject = this.fsManager.resolveFile(fileURI);
            if (fObject.exists()) {
                this.getLog().warn((Object)("File already exists in repository: " + fileURI));
                fObject.delete();
                fObject.refresh();
            }
            target = fObject.getContent().getOutputStream();
            this.copyStreams(source, target);
            this.getLog().debug((Object)("File saved to location:" + fileURI));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new ArchiveResolverException(e);
        }
        finally {
            try {
                if (fObject != null) {
                    fObject.close();
                }
                if (target != null) {
                    target.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public String getSubfoldersPattern() {
        return this.subfoldersPattern;
    }

    public void setSubfoldersPattern(String subfoldersPattern) {
        this.subfoldersPattern = subfoldersPattern;
    }

    public String getTargetURI() {
        return this.targetURI;
    }

    public void setTargetURI(String targetURI) {
        this.targetURI = targetURI;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FolderIterator
    implements Iterator<URI> {
        private List<FileObject> allFolderList;
        private int currentFolderIndex;
        private List<FileObject> iteratedFiles = new ArrayList<FileObject>();

        private FolderIterator(FileObject rootFileObject) throws FileSystemException {
            this.allFolderList = this.getAllSubfoldersFolders(rootFileObject);
            if (rootFileObject.getType().equals(FileType.FOLDER)) {
                this.allFolderList.add(rootFileObject);
            }
            this.currentFolderIndex = 0;
        }

        private List<FileObject> getAllSubfoldersFolders(FileObject rootFileObject) throws FileSystemException {
            FileObject[] children;
            ArrayList<FileObject> returnList = new ArrayList<FileObject>();
            for (FileObject fileObject : children = rootFileObject.getChildren()) {
                if (!fileObject.getType().equals(FileType.FOLDER)) continue;
                returnList.add(fileObject);
            }
            children = null;
            ArrayList tmpList = new ArrayList(returnList);
            for (FileObject fileObject : tmpList) {
                returnList.addAll(this.getAllSubfoldersFolders(fileObject));
            }
            return returnList;
        }

        private void loadNextFolder() throws FileSystemException {
            while (this.allFolderList.size() > this.currentFolderIndex) {
                FileObject[] children;
                FileObject folder = this.allFolderList.get(this.currentFolderIndex++);
                for (FileObject fileObject : children = folder.getChildren()) {
                    if (!fileObject.getType().equals(FileType.FILE)) continue;
                    this.iteratedFiles.add(fileObject);
                }
                if (this.iteratedFiles.isEmpty()) continue;
            }
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.iteratedFiles.isEmpty()) {
                    this.loadNextFolder();
                }
                return !this.iteratedFiles.isEmpty();
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public URI next() {
            try {
                if (this.hasNext()) {
                    return this.iteratedFiles.remove(0).getURL().toURI();
                }
                throw new NoSuchElementException();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
        }
    }
}

