/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class SavedOrderSummaryConfig
implements InitializingBean {
    private String notificationType = "mail";
    private String targetValue = null;
    private String from = null;
    private String hostName = null;
    private long maxTime;

    public void afterPropertiesSet() throws Exception {
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public void setNotificationType(String notificationType) {
        this.notificationType = notificationType;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public void setMaxDiffTime(String maxTime) {
        try {
            if (maxTime.matches("[0-9]+(\\.[0-9]*)*[ ]*(m|M|h|H|d|D|w|W)[ ]*")) {
                String time = maxTime;
                while (time.endsWith(" ")) {
                    time = time.substring(0, time.length() - 1);
                }
                String type = time.substring(time.length() - 1);
                time = time.substring(0, time.length() - 1);
                float typeValue = Float.parseFloat(time);
                Delay delay = Delay.fromName(type);
                if (delay == null) {
                    throw new RuntimeException("Not recognized value of property 'maxDiffTime': " + maxTime);
                }
                this.maxTime = (long)(typeValue * (float)delay.getMilliseconds());
            } else {
                this.maxTime = (long)Float.parseFloat(maxTime);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Delay {
        Minute("m", 60000L),
        Hour("h", 3600000L),
        Day("d", 86400000L),
        Week("w", 604800000L);

        private String name;
        private long mlsTime;
        private static Map<String, Delay> delayMap;

        public static Delay fromName(String name) {
            return delayMap.get(name.toLowerCase());
        }

        private Delay(String name, long mlsTime) {
            this.name = name;
            this.mlsTime = mlsTime;
        }

        public String getName() {
            return this.name;
        }

        public long getMilliseconds() {
            return this.mlsTime;
        }

        static {
            delayMap = new HashMap<String, Delay>();
            for (Delay d : Delay.values()) {
                delayMap.put(d.getName(), d);
            }
        }
    }
}

