/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.indexmapping;

import java.security.InvalidParameterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IndexType {
    IntegerIndex("integer", "int"),
    FloatIndex("float", "float"),
    StringIndex("string", "str"),
    DateIndex("date", "date"),
    FullTextIndex("fullText", "ftxt");

    private String indexTypeName;
    private String indexTypeSolrSuffix;

    private IndexType(String name, String solrSuffix) {
        this.indexTypeName = name;
        this.indexTypeSolrSuffix = solrSuffix;
    }

    public static IndexType getIndexTypeForIndexName(String name) {
        for (IndexType it : IndexType.values()) {
            if (!it.getIndexTypeName().equalsIgnoreCase(name)) continue;
            return it;
        }
        throw new InvalidParameterException("IndexType with name:" + name + " is unknown.");
    }

    public static IndexType getIndexTypeForSolrSuffix(String suffix) {
        for (IndexType it : IndexType.values()) {
            if (!it.getIndexTypeSolrSuffix().equalsIgnoreCase(suffix)) continue;
            return it;
        }
        throw new InvalidParameterException("IndexType with suffix:" + suffix + " is unknown.");
    }

    public String getIndexTypeName() {
        return this.indexTypeName;
    }

    public String getIndexTypeSolrSuffix() {
        return this.indexTypeSolrSuffix;
    }
}

