/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.saver;

import com.sun.istack.ByteArrayDataSource;
import de.maas.saas.config.OrderSaverConfig;
import de.maas.saas.config.OrderSaverEntry;
import de.maas.saas.data.Order;
import de.maas.saas.saver.OrderSaverException;
import de.maas.saas.saver.OrderSaverInterface;
import de.maas.saas.utils.NMRXMLSerializer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;

public class EmailOrderSaver
implements OrderSaverInterface {
    private Map<String, OrderSaverEntry> entries;
    private OrderSaverEntry defaultEntry;

    public void saveOrder(String mandant, String orderId, String state, Order orderData, DeliveryChannel dc, MessageExchangeFactory mef) throws OrderSaverException {
        try {
            OrderSaverEntry oe = this.entries.get(mandant);
            if (oe == null) {
                oe = this.defaultEntry;
            }
            if (oe == null) {
                throw new OrderSaverException("Can't find Email configuration for mandant:" + mandant);
            }
            String fileName = orderId + "_" + mandant + "_" + state;
            byte[] compressedOrder = EmailOrderSaver.ZIPOrderData(fileName + ".xml", orderData);
            String subject = fileName;
            String textToSend = "Attachment:" + fileName;
            InOnly exchange = mef.createInOnlyExchange();
            exchange.setService(new QName("http://www.maas.de/h2w/oxseed", "mail_sender_service"));
            NormalizedMessage message = exchange.createMessage();
            exchange.setInMessage(message);
            message.setProperty("org.apache.servicemix.email.to", (Object)oe.getToEmail());
            if (oe.getBCCEmail() != null) {
                message.setProperty("org.apache.servicemix.email.bcc", (Object)oe.getBCCEmail());
            }
            if (oe.getCCEmail() != null) {
                message.setProperty("org.apache.servicemix.email.cc", (Object)oe.getCCEmail());
            }
            message.setProperty("org.apache.servicemix.email.from", (Object)oe.getFromEmail());
            message.setProperty("org.apache.servicemix.email.subject", (Object)subject);
            message.setProperty("org.apache.servicemix.email.text", (Object)textToSend);
            this.addAttachment(message, fileName + ".zip", compressedOrder);
            dc.send((MessageExchange)exchange);
        }
        catch (OrderSaverException se) {
            throw se;
        }
        catch (Exception e) {
            throw new OrderSaverException("Can't send order by email", e);
        }
    }

    public void setConfig(OrderSaverConfig config) {
        this.entries = config.getEntries();
        this.defaultEntry = config.getDefaultEntry();
    }

    public static byte[] ZIPOrderData(String fileName, Order data) throws OrderSaverException {
        ByteArrayOutputStream outZipOS = new ByteArrayOutputStream();
        ZipOutputStream zipOS = new ZipOutputStream(outZipOS);
        zipOS.setLevel(9);
        ByteArrayOutputStream dataBytes = new ByteArrayOutputStream();
        try {
            NMRXMLSerializer.writeObject((Object)data, (OutputStream)dataBytes);
            dataBytes.flush();
            ZipEntry compressedOrderFile = new ZipEntry(fileName);
            zipOS.putNextEntry(compressedOrderFile);
            zipOS.write(dataBytes.toByteArray());
            zipOS.closeEntry();
            zipOS.flush();
            zipOS.close();
            outZipOS.close();
        }
        catch (Exception e) {
            throw new OrderSaverException("Can't send order by email", e);
        }
        return outZipOS.toByteArray();
    }

    private void addAttachment(NormalizedMessage message, String fileName, byte[] zipFile) throws MessagingException {
        DataHandler dh = new DataHandler((DataSource)new ByteArrayDataSource(zipFile, "application/zip"));
        message.addAttachment(fileName, dh);
    }
}

