/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.utils;

import de.maas.saas.data.Document;
import de.maas.saas.data.Order;
import de.maas.saas.data.Process;
import de.maas.saas.data.Stack;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class OrderFilesManager {
    private String workingDirectory;

    public static OrderFilesManager getInstance(String workingDirectory) {
        return new OrderFilesManager(workingDirectory);
    }

    protected OrderFilesManager(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public InputStream loadDocumentFile(Order order, Document document) throws FileNotFoundException {
        return new FileInputStream(this.getDocumentFilePath(order, document));
    }

    public InputStream loadDocumentFile(Order order, Document document, String inputType) throws FileNotFoundException {
        return new FileInputStream(this.getDocumentFilePath(order, document, inputType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDocumentFile(Order order, Document document, InputStream iStream, String documentInputType) throws FileNotFoundException, IOException {
        File documentFile = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            documentFile = new File(this.getDocumentFilePath(order, document, documentInputType));
            fos = new FileOutputStream(documentFile);
            bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[2048];
            int readLength = 0;
            while ((readLength = iStream.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, readLength);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDocumentFile(String mandantID, String orderID, String documentID, String documentInputType, InputStream iStream) throws FileNotFoundException, IOException {
        File orderFolder = new File(this.getOrderFolderPath(mandantID, orderID));
        if (!orderFolder.exists() && !orderFolder.mkdirs()) {
            throw new IOException("Couldn't create folder:" + orderFolder.getAbsolutePath() + " [DocumentID:" + documentID + "]");
        }
        File documentFile = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            documentFile = new File(this.getDocumentFilePath(mandantID, orderID, documentID, documentInputType));
            fos = new FileOutputStream(documentFile);
            bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[2048];
            int readLength = 0;
            while ((readLength = iStream.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, readLength);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDocumentFile(Order order, Document document, InputStream iStream) throws FileNotFoundException, IOException {
        File orderFolder = new File(this.getOrderFolderPath(order));
        if (!orderFolder.exists() && !orderFolder.mkdirs()) {
            throw new IOException("Couldn't create folder:" + orderFolder.getAbsolutePath() + " [DocumentID:" + document.getId() + "]");
        }
        File documentFile = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            documentFile = new File(this.getDocumentFilePath(order, document));
            fos = new FileOutputStream(documentFile);
            bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[2048];
            int readLength = 0;
            while ((readLength = iStream.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, readLength);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public boolean removeOrderDocuments(Order order) {
        Stack stack = order.getStack();
        if (stack != null) {
            Stack.ProcessList processList = stack.getProcessList();
            if (processList != null) {
                for (Process process : processList.getProcess()) {
                    Process.DocumentList documentList = process.getDocumentList();
                    if (documentList == null) continue;
                    for (Document document : documentList.getDocument()) {
                        if (this.removeDocumentFile(order, document)) continue;
                        return false;
                    }
                }
            }
            File orderFolder = new File(this.getOrderFolderPath(order));
            return orderFolder.delete();
        }
        return true;
    }

    public boolean removeDocumentFile(Order order, final Document document) {
        File orderFolder = new File(this.getOrderFolderPath(order));
        File[] documentFiles = orderFolder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(document.getId());
            }
        });
        if (documentFiles != null) {
            for (File documentFile : documentFiles) {
                if (documentFile.delete()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean removeDocumentFile(Order order, Document document, String documentInputType) {
        File documentFile = new File(this.getDocumentFilePath(order, document, documentInputType));
        return documentFile.delete();
    }

    private String getDocumentFilePath(String mandantID, String orderID, String documentID, String documentInputType) {
        StringBuilder path = new StringBuilder();
        path.append(this.getOrderFolderPath(mandantID, orderID));
        path.append(File.separatorChar);
        path.append(documentID);
        if (documentInputType != null) {
            path.append(".");
            path.append(documentInputType);
        }
        return path.toString();
    }

    private String getDocumentFilePath(Order order, Document document) {
        return this.getDocumentFilePath(order, document, document.getInputType());
    }

    private String getDocumentFilePath(Order order, Document document, String documentInputType) {
        return this.getDocumentFilePath(order.getMandant(), order.getId(), document.getId(), documentInputType);
    }

    private String getOrderFolderPath(String mandantID, String orderID) {
        StringBuilder path = new StringBuilder();
        path.append(this.workingDirectory);
        path.append(File.separatorChar);
        path.append(mandantID);
        path.append(File.separatorChar);
        path.append(orderID);
        return path.toString();
    }

    private String getOrderFolderPath(Order order) {
        return this.getOrderFolderPath(order.getMandant(), order.getId());
    }
}

