/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.utils;

import de.maas.saas.data.Action;
import de.maas.saas.utils.NMRXMLSerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jbi.messaging.ExchangeStatus;

public class PollerUtil {
    public static boolean isActive(Action action) {
        if (action == null) {
            return false;
        }
        return action.getStatus().equals(ExchangeStatus.ACTIVE.toString());
    }

    public static void copyStreams(InputStream source, OutputStream target) throws IOException {
        byte[] b = new byte[32768];
        int len = 0;
        while ((len = source.read(b)) > -1) {
            target.write(b, 0, len);
            target.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFiles(File source, File target) throws IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fis = new FileInputStream(source);
            bis = new BufferedInputStream(fis);
            fos = new FileOutputStream(target);
            bos = new BufferedOutputStream(fos);
            PollerUtil.copyStreams(bis, bos);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (fis != null) {
                    fis.close();
                }
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ignored) {}
        }
    }

    public static String getURL(String path) throws MalformedURLException {
        try {
            new URL(path);
            return path;
        }
        catch (MalformedURLException e) {
            return new File(path).toURL().toString();
        }
    }

    public static String getTmpDirectoryName(String orderID) {
        return orderID.substring(0, 4) + (int)(Math.random() * 10000.0);
    }

    public static String url2fileName(String urlPath) {
        int index = urlPath.lastIndexOf("/");
        if (index < 0) {
            return "";
        }
        if (index == urlPath.length() - 1) {
            return PollerUtil.url2fileName(urlPath.substring(index - 2));
        }
        return urlPath.substring(index + 1);
    }

    public static String getParentDir(String path) {
        int index = path.lastIndexOf("/");
        if (index < 0) {
            index = path.lastIndexOf("\\");
        }
        if (index < 0) {
            return "";
        }
        return path.substring(0, index);
    }

    public static void save(Object source, File targetFile) {
        try {
            NMRXMLSerializer.writeObject((Object)source, (File)targetFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getMandant(String subDir) {
        if (subDir == null) {
            return null;
        }
        int index = subDir.indexOf("/");
        if (index < 0) {
            index = subDir.indexOf("\\");
        }
        if (index < 0) {
            return subDir;
        }
        if (index == 1) {
            return PollerUtil.getMandant(subDir.substring(1));
        }
        return subDir.substring(0, index);
    }
}

