/*
 * Decompiled with CFR 0.152.
 */
package de.maas.saas.utils;

import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathApi {
    private static XPathFactory xpathFactory = null;

    public static Object selectSingleNode(Object contextNode, String xpathExpression, NamespaceContext nsContext) throws XPathExpressionException, XPathException {
        XPathExpression expression = XPathApi.createExpression(xpathExpression, nsContext);
        Object result = expression.evaluate(contextNode, XPathConstants.NODE);
        return result;
    }

    public static List<Object> selectSequence(Object contextNode, String xpathExpression, NamespaceContext nsContext) throws XPathExpressionException, XPathException {
        XPathExpression expression = XPathApi.createExpression(xpathExpression, nsContext);
        Object result = expression.evaluate(contextNode, XPathConstants.NODESET);
        if (result instanceof List) {
            return (List)result;
        }
        return null;
    }

    public static List<Object> selectSequence(Object contextNode, XPathExpression expression) throws XPathExpressionException, XPathException {
        Object result = expression.evaluate(contextNode, XPathConstants.NODESET);
        if (result instanceof List) {
            return (List)result;
        }
        return null;
    }

    public static NodeList selectNodeList(Object contextNode, String xpathExpression, NamespaceContext nsContext) throws XPathExpressionException, XPathException {
        XPathExpression expression = XPathApi.createExpression(xpathExpression, nsContext);
        Object obj = expression.evaluate(contextNode, XPathConstants.NODESET);
        return (NodeList)obj;
    }

    public static boolean matchExpression(Object contextNode, String xpathExpression, NamespaceContext nsContext) throws XPathExpressionException, XPathException {
        XPathExpression expression = XPathApi.createExpression(xpathExpression, nsContext);
        Boolean result = (Boolean)expression.evaluate(contextNode, XPathConstants.BOOLEAN);
        return result.equals(Boolean.TRUE);
    }

    public static synchronized String selectString(Object contextNode, String xpathExpression, NamespaceContext nsContext) throws XPathExpressionException, XPathException {
        XPathExpression expression = XPathApi.createExpression(xpathExpression, nsContext);
        Object obj = expression.evaluate(contextNode, XPathConstants.STRING);
        return (String)obj;
    }

    public static synchronized boolean selectBoolean(Object contextNode, String xpathExpression, NamespaceContext nsContext) throws XPathExpressionException, XPathException {
        XPathExpression expression = XPathApi.createExpression(xpathExpression, nsContext);
        Object result = expression.evaluate(contextNode, XPathConstants.BOOLEAN);
        return (Boolean)result;
    }

    public static synchronized int selectNumber(Object contextNode, String xpathExpression, NamespaceContext nsContext) throws XPathExpressionException, XPathException {
        XPathExpression expression = XPathApi.createExpression(xpathExpression, nsContext);
        int result = ((Double)expression.evaluate(contextNode, XPathConstants.NUMBER)).intValue();
        return result;
    }

    public static synchronized XPathExpression createExpression(String xpathExpression, NamespaceContext nsContext) throws XPathExpressionException {
        XPath xpath = xpathFactory.newXPath();
        if (nsContext != null) {
            xpath.setNamespaceContext(nsContext);
        }
        return xpath.compile(xpathExpression);
    }

    static {
        xpathFactory = XPathFactory.newInstance();
    }
}

