// Generated by CoffeeScript 1.6.3
(function() {
  var EventEmitter, NodeCache, _,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __slice = [].slice;

  _ = require("underscore");

  EventEmitter = require('events').EventEmitter;

  module.exports = NodeCache = (function(_super) {
    __extends(NodeCache, _super);

    function NodeCache(options) {
      this.options = options != null ? options : {};
      this._error = __bind(this._error, this);
      this._getValLength = __bind(this._getValLength, this);
      this._getKeyLength = __bind(this._getKeyLength, this);
      this._unwrap = __bind(this._unwrap, this);
      this._wrap = __bind(this._wrap, this);
      this._check = __bind(this._check, this);
      this._checkData = __bind(this._checkData, this);
      this.flushAll = __bind(this.flushAll, this);
      this.getStats = __bind(this.getStats, this);
      this.keys = __bind(this.keys, this);
      this.ttl = __bind(this.ttl, this);
      this.del = __bind(this.del, this);
      this.set = __bind(this.set, this);
      this.get = __bind(this.get, this);
      this.data = {};
      this.options = _.extend({
        forceString: false,
        objectValueSize: 80,
        arrayValueSize: 40,
        stdTTL: 0,
        checkperiod: 600
      }, this.options);
      this.stats = {
        hits: 0,
        misses: 0,
        keys: 0,
        ksize: 0,
        vsize: 0
      };
      this._checkData();
    }

    NodeCache.prototype.get = function(keys, cb) {
      var key, oRet, _i, _len;
      if (_.isString(keys)) {
        keys = [keys];
      }
      oRet = {};
      for (_i = 0, _len = keys.length; _i < _len; _i++) {
        key = keys[_i];
        if ((this.data[key] != null) && this._check(key, this.data[key])) {
          this.stats.hits++;
          oRet[key] = this._unwrap(this.data[key]);
        } else {
          this.stats.misses++;
        }
      }
      if (cb != null) {
        cb(null, oRet);
      }
      return oRet;
    };

    NodeCache.prototype.set = function(key, value, ttl, cb) {
      var existend;
      existend = false;
      if (this.options.forceString && !_.isString(value)) {
        value = JSON.stringify(value);
      }
      if (arguments.length === 3 && _.isFunction(ttl)) {
        cb = ttl;
        ttl = this.options.stdTTL;
      }
      if (this.data[key]) {
        existend = true;
        this.stats.vsize -= this._getValLength(this._unwrap(this.data[key]));
      }
      this.data[key] = this._wrap(value, ttl);
      this.stats.vsize += this._getValLength(value);
      if (!existend) {
        this.stats.ksize += this._getKeyLength(key);
        this.stats.keys++;
      }
      this.emit("set", key, value);
      if (cb != null) {
        cb(null, true);
      }
      return true;
    };

    NodeCache.prototype.del = function(keys, cb) {
      var delCount, key, _i, _len;
      if (_.isString(keys)) {
        keys = [keys];
      }
      delCount = 0;
      for (_i = 0, _len = keys.length; _i < _len; _i++) {
        key = keys[_i];
        if (this.data[key] != null) {
          this.stats.vsize -= this._getValLength(this._unwrap(this.data[key]));
          this.stats.ksize -= this._getKeyLength(key);
          this.stats.keys--;
          delCount++;
          delete this.data[key];
          this.emit("del", key);
        } else {
          this.stats.misses++;
        }
      }
      if (cb != null) {
        cb(null, delCount);
      }
      return delCount;
    };

    NodeCache.prototype.ttl = function() {
      var arg, args, cb, key, ttl, _i, _len;
      key = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      for (_i = 0, _len = args.length; _i < _len; _i++) {
        arg = args[_i];
        switch (typeof arg) {
          case "number":
            ttl = arg;
            break;
          case "function":
            cb = arg;
        }
      }
      ttl || (ttl = this.options.stdTTL);
      if (!key) {
        if (cb != null) {
          cb(null, false);
        }
        return false;
      }
      if ((this.data[key] != null) && this._check(key, this.data[key])) {
        if (ttl > 0) {
          this.data[key] = this._wrap(this.data[key].v, ttl);
        } else {
          this.del(key);
        }
        if (cb != null) {
          cb(null, true);
        }
        return true;
      } else {
        if (cb != null) {
          cb(null, false);
        }
        return false;
      }
    };

    NodeCache.prototype.keys = function(cb) {
      var _keys;
      _keys = Object.keys(this.data);
      if (cb != null) {
        cb(null, _keys);
      }
      return _keys;
    };

    NodeCache.prototype.getStats = function() {
      return this.stats;
    };

    NodeCache.prototype.flushAll = function(_startPeriod) {
      if (_startPeriod == null) {
        _startPeriod = true;
      }
      this.data = {};
      this.stats = {
        hits: 0,
        misses: 0,
        keys: 0,
        ksize: 0,
        vsize: 0
      };
      this._killCheckPeriod();
      this._checkData(_startPeriod);
      this.emit("flush");
    };

    NodeCache.prototype._checkData = function(startPeriod) {
      var key, value, _ref;
      if (startPeriod == null) {
        startPeriod = true;
      }
      _ref = this.data;
      for (key in _ref) {
        value = _ref[key];
        this._check(key, value);
      }
      if (startPeriod && this.options.checkperiod > 0) {
        this.checkTimeout = setTimeout(this._checkData, this.options.checkperiod * 1000);
      }
    };

    NodeCache.prototype._killCheckPeriod = function() {
      if (this.checkTimeout != null) {
        return clearTimeout(this.checkTimeout);
      }
    };

    NodeCache.prototype._check = function(key, data) {
      if (data.t !== 0 && data.t < Date.now()) {
        this.del(key);
        this.emit("expired", key, this._unwrap(data));
        return false;
      } else {
        return true;
      }
    };

    NodeCache.prototype._wrap = function(value, ttl) {
      var livetime, now, oReturn, ttlMultiplicator;
      now = Date.now();
      livetime = 0;
      ttlMultiplicator = 1000;
      if (ttl === 0) {
        livetime = 0;
      } else if (ttl) {
        livetime = now + (ttl * ttlMultiplicator);
      } else {
        if (this.options.stdTTL === 0) {
          livetime = this.options.stdTTL;
        } else {
          livetime = now + (this.options.stdTTL * ttlMultiplicator);
        }
      }
      return oReturn = {
        t: livetime,
        v: value
      };
    };

    NodeCache.prototype._unwrap = function(value) {
      if (value.v != null) {
        return value.v;
      }
      return null;
    };

    NodeCache.prototype._getKeyLength = function(key) {
      return key.length;
    };

    NodeCache.prototype._getValLength = function(value) {
      if (_.isString(value)) {
        return value.length;
      } else if (this.options.forceString) {
        return JSON.stringify(value).length;
      } else if (_.isArray(value)) {
        return this.options.arrayValueSize * value.length;
      } else if (_.isNumber(value)) {
        return 8;
      } else if (_.isObject(value)) {
        return this.options.objectValueSize * _.size(value);
      } else {
        return 0;
      }
    };

    NodeCache.prototype._error = function(type, data, cb) {
      var error;
      if (data == null) {
        data = {};
      }
      error = new Error();
      error.name = type;
      error.errorcode = type;
      error.msg = "-";
      error.data = data;
      if (cb && _.isFunction(cb)) {
        cb(error, null);
      } else {
        return error;
      }
    };

    return NodeCache;

  })(EventEmitter);

}).call(this);
